/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextureUtil {
    public static int[] intToRgba(int color) {
        int[] rgba = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF};
        return rgba;
    }

    public static int rgbaToInt(int[] rgba) {
        int r = rgba[0];
        int g = rgba[1];
        int b = rgba[2];
        int a = rgba[3];
        int color = a << 24 | r << 16 | g << 8 | b;
        return color;
    }

    public static int rgbaToIntHex(int[] rgba) {
        int color = TextureUtil.rgbaToInt(rgba);
        return color;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static int getAverageColorServer(String textureLocation) {
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getAverageColor(String textureLocation) {
        ResourceLocation resourceLocation = new ResourceLocation("nuclearcraft", textureLocation);
        String path = "assets/" + resourceLocation.m_135827_() + "/" + resourceLocation.m_135815_();
        try {
            InputStream texStream = resourceLocation.getClass().getClassLoader().getResourceAsStream(path);
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)texStream);
            int textureWidth = nativeImage.m_84982_();
            int textureHeight = nativeImage.m_85084_();
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            int pixelCount = 0;
            for (int x = textureWidth / 2 - 4; x < textureWidth / 2 + 4; ++x) {
                for (int y = textureHeight / 2 - 4; y < textureHeight / 2 + 4; ++y) {
                    Color pixel = new Color(nativeImage.m_84985_(x, y));
                    redSum += Math.min(254, pixel.getRed() + 20);
                    greenSum += pixel.getGreen();
                    blueSum += Math.max(0, pixel.getBlue() - 30);
                    ++pixelCount;
                }
            }
            int redAvg = redSum / pixelCount;
            int greenAvg = greenSum / pixelCount;
            int blueAvg = blueSum / pixelCount;
            return TextureUtil.rgbaToIntHex(new int[]{redAvg, greenAvg, blueAvg, 255});
        }
        catch (IOException | NullPointerException e) {
            System.out.print("Source texture for auto color not found: " + path + "\n");
            return TextureUtil.rgbaToIntHex(new int[]{0, 0, 0, 0});
        }
    }
}

