/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes;

import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.type.NcRecipe;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface INcRecipeTypeProvider<RECIPE extends NcRecipe> {
    default public ResourceLocation getRegistryName() {
        return this.getRecipeType().getRegistryName();
    }

    public NcRecipeType<RECIPE> getRecipeType();

    @NotNull
    default public List<RECIPE> getRecipes(@Nullable Level world) {
        return this.getRecipeType().getRecipes(world);
    }

    default public Stream<RECIPE> stream(@Nullable Level world) {
        return this.getRecipes(world).stream();
    }

    @Nullable
    default public RECIPE findFirst(@Nullable Level world, Predicate<RECIPE> matchCriteria) {
        return (RECIPE)((NcRecipe)this.stream(world).filter(matchCriteria).findFirst().orElse(null));
    }

    default public boolean contains(@Nullable Level world, Predicate<RECIPE> matchCriteria) {
        return this.stream(world).anyMatch(matchCriteria);
    }
}

