/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.item;

import igentuman.nc.handler.ItemEnergyHandler;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.util.CapabilityUtils;
import igentuman.nc.util.CustomEnergyStorage;
import igentuman.nc.util.TextUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BatteryBlockItem
extends BlockItem {
    public BatteryBlockItem(Block pBlock, Item.Properties props) {
        super(pBlock, new Item.Properties().m_41487_(1));
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return false;
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    protected int getEnergyMaxStorage() {
        return CommonConfig.ENERGY_STORAGE.getCapacityFor(this.toString());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemEnergyHandler(stack, this.getEnergyMaxStorage(), this.getEnergyMaxStorage(), this.getEnergyMaxStorage());
    }

    public CustomEnergyStorage getEnergy(ItemStack stack) {
        return (CustomEnergyStorage)((Object)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY));
    }

    public int m_142158_(ItemStack stack) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        float chargeRatio = (float)energyStorage.getEnergyStored() / (float)this.getEnergyMaxStorage();
        return (int)Math.min(13.0f, 13.0f * chargeRatio);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237110_((String)"tooltip.nc.energy_stored", (Object[])new Object[]{this.formatEnergy(this.getEnergy(stack).getEnergyStored()), this.formatEnergy(this.getEnergy(stack).getMaxEnergyStored())}).m_130940_(ChatFormatting.BLUE));
        list.add((Component)Component.m_237115_((String)"tooltip.nc.use_multitool").m_130940_(ChatFormatting.YELLOW));
    }

    public String formatEnergy(int energy) {
        if (energy >= 1000000000) {
            return TextUtils.numberFormat(energy / 1000000000) + " GFE";
        }
        if (energy >= 1000000) {
            return TextUtils.numberFormat(energy / 1000000) + " MFE";
        }
        if (energy >= 1000) {
            return TextUtils.numberFormat(energy / 1000) + " kFE";
        }
        return TextUtils.numberFormat(energy) + " FE";
    }
}

