/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided.capability;

import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.recipes.ingredient.creator.FluidStackIngredientCreator;
import igentuman.nc.util.TagUtil;
import java.util.HashMap;
import mekanism.api.Action;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;

public class Gas2FluidConverter
implements IGasHandler {
    private FluidCapabilityHandler fluidCapability;
    private Direction side;
    private HashMap<Gas, Fluid> gasFluidMap = new HashMap();

    public int getTanks() {
        return 1;
    }

    @NotNull
    public GasStack getChemicalInTank(int tank) {
        return this.getEmptyStack();
    }

    public void setChemicalInTank(int tank, @NotNull GasStack stack) {
    }

    public long getTankCapacity(int tank) {
        return 100L;
    }

    public boolean isValid(int tank, @NotNull GasStack stack) {
        return false;
    }

    private String specialConvertRules(String input) {
        if (input.matches("clean_[a-z]+")) {
            return input.substring(6) + "_clean_slurry";
        }
        if (input.matches("dirty_[a-z]+")) {
            return input.substring(6) + "_slurry";
        }
        return input;
    }

    private FluidStack convert(GasStack stack) {
        FluidStack fluidStack;
        int amount = (int)stack.getAmount();
        if (amount <= 0) {
            amount = 1000;
        }
        if (this.gasFluidMap.containsKey(stack.getType()) && !(this.gasFluidMap.get(stack.getType()) instanceof EmptyFluid)) {
            return new FluidStack(this.gasFluidMap.get(stack.getType()), amount);
        }
        String name = stack.getTypeRegistryName().m_135815_();
        name = this.specialConvertRules(name);
        ITagManager tagManager = TagUtil.manager(ForgeRegistries.FLUIDS);
        TagKey key = tagManager.createTagKey(new ResourceLocation("forge", name));
        ITag fluidITag = TagUtil.tag(ForgeRegistries.FLUIDS, key);
        if (fluidITag.isEmpty()) {
            return FluidStack.EMPTY;
        }
        try {
            fluidStack = (FluidStack)FluidStackIngredientCreator.INSTANCE.from(fluidITag.getKey(), amount).getRepresentations().get(0);
        }
        catch (Exception e) {
            return FluidStack.EMPTY;
        }
        this.gasFluidMap.put((Gas)stack.getType(), fluidStack.getFluid());
        return new FluidStack(this.gasFluidMap.get(stack.getType()), (int)stack.getAmount());
    }

    @NotNull
    public GasStack insertChemical(int tank, @NotNull GasStack stack, @NotNull Action action) {
        FluidStack fluidStack = this.convert(stack);
        if (fluidStack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < this.fluidCapability.inputSlots; ++i) {
            if (!this.fluidCapability.haveAccessFromSide(this.side, i) || !this.fluidCapability.isValidForInputSlot(i, fluidStack)) continue;
            boolean doInsert = action.execute();
            FluidStack inserted = this.fluidCapability.insertFluidInternal(i, fluidStack, doInsert);
            stack.setAmount((long)inserted.getAmount());
            return stack;
        }
        return stack;
    }

    @NotNull
    public GasStack extractChemical(int tank, long amount, @NotNull Action action) {
        return this.getEmptyStack();
    }

    public void setFluidHandler(FluidCapabilityHandler fluidCapability) {
        this.fluidCapability = fluidCapability;
    }

    public Gas2FluidConverter forSide(Direction side) {
        this.side = side;
        return this;
    }

    @NotNull
    public GasStack getEmptyStack() {
        return GasStack.EMPTY;
    }
}

