/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import igentuman.nc.content.materials.Blocks;
import igentuman.nc.content.materials.Chunks;
import igentuman.nc.content.materials.Dusts;
import igentuman.nc.content.materials.Gems;
import igentuman.nc.content.materials.Ingots;
import igentuman.nc.content.materials.Nuggets;
import igentuman.nc.content.materials.Plates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeConfigSpec;

public class MaterialsConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final MaterialProductsConfig MATERIAL_PRODUCTS = new MaterialProductsConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class MaterialProductsConfig {
        public List<ForgeConfigSpec.ConfigValue<Boolean>> INGOTS;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> NUGGETS;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> BLOCK;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> RAW_CHUNKS;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> PLATES;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> DUSTS;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> GEMS;
        public ForgeConfigSpec.ConfigValue<List<String>> MODS_PRIORITY;

        public MaterialProductsConfig(ForgeConfigSpec.Builder builder) {
            this.RAW_CHUNKS = this.registrationList(builder, "raw_chunks", Chunks.get().all().keySet());
            this.INGOTS = this.registrationList(builder, "ingots", Ingots.get().all().keySet());
            this.NUGGETS = this.registrationList(builder, "nuggets", Nuggets.get().all().keySet());
            this.PLATES = this.registrationList(builder, "plates", Plates.get().all().keySet());
            this.DUSTS = this.registrationList(builder, "dusts", Dusts.get().all().keySet());
            this.BLOCK = this.registrationList(builder, "blocks", Blocks.get().all().keySet());
            this.GEMS = this.registrationList(builder, "gems", Gems.get().all().keySet());
            this.MODS_PRIORITY = builder.push("forge_tag_priority").comment("Priority of mods to resolve forge tags to itemstack and fluidstack.").define("mods_priority", List.of("minecraft", "nuclearcraft", "mekanism", "immersiveengineering", "tconstruct"), o -> o instanceof ArrayList);
        }

        private List<ForgeConfigSpec.ConfigValue<Boolean>> registrationList(ForgeConfigSpec.Builder builder, String subCategory, Set<String> items) {
            ArrayList<ForgeConfigSpec.ConfigValue<Boolean>> rawOres = new ArrayList<ForgeConfigSpec.ConfigValue<Boolean>>();
            builder.push(subCategory);
            for (String item : items) {
                rawOres.add((ForgeConfigSpec.ConfigValue<Boolean>)builder.define(item, (Object)true, o -> o instanceof Boolean));
            }
            builder.pop();
            return rawOres;
        }
    }
}

