/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import igentuman.nc.content.energy.BatteryBlocks;
import igentuman.nc.content.energy.RTGs;
import igentuman.nc.content.energy.SolarPanels;
import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.content.storage.ContainerBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final EnergyGenerationConfig ENERGY_GENERATION = new EnergyGenerationConfig(BUILDER);
    public static final EnergyStorageConfig ENERGY_STORAGE = new EnergyStorageConfig(BUILDER);
    public static final StorageBlocksConfig STORAGE_BLOCKS = new StorageBlocksConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class EnergyGenerationConfig {
        public ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_SOLAR_PANELS;
        public ForgeConfigSpec.ConfigValue<List<Integer>> SOLAR_PANELS_GENERATION;
        public ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_RTG;
        public ForgeConfigSpec.ConfigValue<List<Integer>> RTG_GENERATION;
        public ForgeConfigSpec.ConfigValue<List<Integer>> RTG_RADIATION;
        public ForgeConfigSpec.ConfigValue<Integer> STEAM_TURBINE;
        public ForgeConfigSpec.ConfigValue<Integer> DECAY_GENERATOR;
        public ForgeConfigSpec.ConfigValue<Double> GENERATION_MULTIPLIER;

        public EnergyGenerationConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Energy");
            this.GENERATION_MULTIPLIER = builder.comment("Multiplier for all power generation in the mod").defineInRange("generation_multiplier", 1.0, 0.001, 1000.0);
            this.REGISTER_SOLAR_PANELS = builder.comment("Allow solar panel registration: " + String.join((CharSequence)", ", SolarPanels.all().keySet())).define("register_panel", SolarPanels.initialRegistered(), o -> o instanceof ArrayList);
            this.SOLAR_PANELS_GENERATION = builder.comment("Solar panel power generation: " + String.join((CharSequence)", ", SolarPanels.all().keySet())).define("panel_power", SolarPanels.initialPower(), o -> o instanceof ArrayList);
            this.REGISTER_RTG = builder.comment("Allow rtg registration: " + String.join((CharSequence)", ", RTGs.all().keySet())).define("register_rtg", RTGs.initialRegistered(), o -> o instanceof ArrayList);
            this.RTG_GENERATION = builder.comment("rtg generation: " + String.join((CharSequence)", ", RTGs.all().keySet())).define("rtg_power", RTGs.initialPower(), o -> o instanceof ArrayList);
            this.RTG_RADIATION = builder.comment("rtg radiation: " + String.join((CharSequence)", ", RTGs.all().keySet())).define("rtg_radiation", RTGs.initialRadiation(), o -> o instanceof ArrayList);
            this.STEAM_TURBINE = builder.comment("Steam turbine (one block) base power gen").define("steam_turbine_power_gen", (Object)50);
            this.DECAY_GENERATOR = builder.comment("Decay Generator base power gen").define("decay_generator_power_gen", (Object)100);
            builder.pop();
        }
    }

    public static class EnergyStorageConfig {
        public ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_ENERGY_BLOCK;
        public ForgeConfigSpec.ConfigValue<List<Integer>> ENERGY_BLOCK_STORAGE;
        public ForgeConfigSpec.ConfigValue<Integer> LITHIUM_ION_BATTERY_STORAGE;
        public ForgeConfigSpec.ConfigValue<Integer> QNP_ENERGY_STORAGE;
        public ForgeConfigSpec.ConfigValue<Integer> LIGHTNING_ROD_CHARGE;
        public ForgeConfigSpec.ConfigValue<Integer> QNP_ENERGY_PER_BLOCK;

        public EnergyStorageConfig(ForgeConfigSpec.Builder builder) {
            builder.push("energy_storage");
            this.LIGHTNING_ROD_CHARGE = builder.define("ligtning_rod_charge", (Object)1000000);
            this.REGISTER_ENERGY_BLOCK = builder.comment("Allow block registration: " + String.join((CharSequence)", ", BatteryBlocks.all().keySet())).define("energy_block_registration", BatteryBlocks.initialRegistered(), o -> o instanceof ArrayList);
            this.ENERGY_BLOCK_STORAGE = builder.comment("Storage: " + String.join((CharSequence)", ", BatteryBlocks.all().keySet())).define("energy_block_storage", BatteryBlocks.initialPower(), o -> o instanceof ArrayList);
            this.LITHIUM_ION_BATTERY_STORAGE = builder.define("lithium_ion_battery_storage", (Object)1000000);
            this.QNP_ENERGY_STORAGE = builder.define("qnp_energy_storage", (Object)2000000);
            this.QNP_ENERGY_PER_BLOCK = builder.define("qnp_energy_per_block", (Object)200);
            builder.pop();
        }

        public int getCapacityFor(String code) {
            if (code.equals("lithium_ion_cell")) {
                return (Integer)this.LITHIUM_ION_BATTERY_STORAGE.get();
            }
            return BatteryBlocks.all().get(code).config().getStorage();
        }
    }

    public static class StorageBlocksConfig {
        public ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_BARREL;
        public ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_CONTAINER;
        public ForgeConfigSpec.ConfigValue<List<Integer>> BARREL_CAPACITY;

        public StorageBlocksConfig(ForgeConfigSpec.Builder builder) {
            builder.push("storage_blocks").comment("Blocks to store items, fluids, etc...");
            this.REGISTER_CONTAINER = builder.comment("Allow container registration: " + String.join((CharSequence)", ", BarrelBlocks.all().keySet())).define("container_block_registration", ContainerBlocks.initialRegistered(), o -> o instanceof ArrayList);
            this.REGISTER_BARREL = builder.comment("Allow barrel registration: " + String.join((CharSequence)", ", BarrelBlocks.all().keySet())).define("barrel_block_registration", BarrelBlocks.initialRegistered(), o -> o instanceof ArrayList);
            this.BARREL_CAPACITY = builder.comment("Barrel capacity in Buckets: " + String.join((CharSequence)", ", BarrelBlocks.all().keySet())).define("barrel_capacity", BarrelBlocks.initialCapacity(), o -> o instanceof ArrayList);
            builder.pop();
        }
    }
}

