/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes;

import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.datagen.recipes.NCRecipes;
import igentuman.nc.datagen.recipes.recipes.AbstractRecipeProvider;
import igentuman.nc.setup.registration.FissionFuel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FuelRecipes
extends NCRecipes {
    public FuelRecipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public static void generate(Consumer<FinishedRecipe> consumer) {
        for (String name : Materials.isotopes()) {
            for (String type : new String[]{"_ox", "_ni", "_za"}) {
                String key = name + type;
                SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FissionFuel.NC_ISOTOPES.get(key).get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FissionFuel.NC_ISOTOPES.get(name).get()), (float)1.0f, (int)100).m_126132_("item", (CriterionTriggerInstance)FuelRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)FissionFuel.NC_ISOTOPES.get(name).get()}).m_45077_()})).m_176500_(consumer, "nuclearcraft_" + name + type + "_sml");
            }
        }
        for (String name : FuelManager.all().keySet()) {
            for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : new String[]{"ox", "ni", "za"}) {
                    List<String> key = List.of("fuel", name, subType, type);
                    SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FissionFuel.NC_FUEL.get(key).get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FissionFuel.NC_FUEL.get(List.of("fuel", name, subType, "")).get()), (float)1.0f, (int)100).m_126132_("item", (CriterionTriggerInstance)FuelRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)FissionFuel.NC_FUEL.get(List.of("fuel", name, subType, "")).get()}).m_45077_()})).m_176500_(consumer, "nuclearcraft_fuel_" + name + subType + type + "_sml");
                    key = List.of("depleted", name, subType, type);
                    SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FissionFuel.NC_DEPLETED_FUEL.get(key).get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FissionFuel.NC_DEPLETED_FUEL.get(List.of("depleted", name, subType, "")).get()), (float)1.0f, (int)100).m_126132_("item", (CriterionTriggerInstance)FuelRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)FissionFuel.NC_DEPLETED_FUEL.get(List.of("depleted", name, subType, "")).get()}).m_45077_()})).m_176500_(consumer, "nuclearcraft_depleted_" + name + subType + type + "_sml");
                }
                FuelRecipes.fuelPelletRecipe(consumer, name, subType, "", FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[0], FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[1]);
                FuelRecipes.fuelPelletRecipe(consumer, name, subType, "ox", FuelManager.all().get((Object)name).get((Object)subType).getOxide().isotopes[0], FuelManager.all().get((Object)name).get((Object)subType).getOxide().isotopes[1]);
                FuelRecipes.fuelPelletRecipe(consumer, name, subType, "ni", FuelManager.all().get((Object)name).get((Object)subType).getNitride().isotopes[0], FuelManager.all().get((Object)name).get((Object)subType).getNitride().isotopes[1]);
                FuelRecipes.fuelPelletRecipe(consumer, name, subType, "za", FuelManager.all().get((Object)name).get((Object)subType).getZirconiumAlloy().isotopes[0], FuelManager.all().get((Object)name).get((Object)subType).getZirconiumAlloy().isotopes[1]);
            }
        }
    }

    private static void fuelPelletRecipe(Consumer<FinishedRecipe> consumer, String name, String subType, String type, int isotope1, int isotope2) {
        int isotope1Cnt = 1;
        int isotope2Cnt = 8;
        if (subType.substring(0, 1).equalsIgnoreCase("h")) {
            isotope1Cnt = 3;
            isotope2Cnt = 6;
        }
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FissionFuel.NC_FUEL.get(List.of("fuel", name, subType, type)).get()), (int)3).m_126145_("nuclearcraft_ingots").m_126211_((ItemLike)AbstractRecipeProvider.getIsotope(name, String.valueOf(isotope1), type), isotope1Cnt).m_126211_((ItemLike)AbstractRecipeProvider.getIsotope(name, String.valueOf(isotope2), type), isotope2Cnt).m_126132_("has_ore", (CriterionTriggerInstance)FuelRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)FissionFuel.NC_FUEL.get(List.of("fuel", name, subType, type)).get()}).m_45077_()})).m_176500_(consumer, "nuclearcraft_fuel_" + name + subType + type + "_cr");
    }
}

