/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.processors;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.client.gui.processor.NCProcessorScreen;
import igentuman.nc.container.NCProcessorContainer;
import igentuman.nc.content.processors.ProcessorPrefab;
import igentuman.nc.content.processors.config.ProcessorSlots;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.serializers.NcRecipeSerializer;
import igentuman.nc.recipes.type.NcRecipe;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ProcessorBuilder<M extends NCProcessorContainer, U extends Screen> {
    public ProcessorPrefab processor;

    private ProcessorBuilder() {
    }

    public static ProcessorBuilder make(String name) {
        ProcessorBuilder builder = new ProcessorBuilder();
        builder.processor = new ProcessorPrefab(name);
        return builder;
    }

    public static ProcessorBuilder make(String name, int inFluids, int inItems, int outFluids, int outItems) {
        ProcessorBuilder builder = new ProcessorBuilder();
        builder.processor = new ProcessorPrefab(name, inFluids, inItems, outFluids, outItems);
        builder.container(NCProcessorContainer.class);
        if (FMLEnvironment.dist.isClient()) {
            builder.screen(NCProcessorScreen::new);
        }
        return builder;
    }

    public ProcessorBuilder<M, U> container(Class container) {
        this.processor.setContainer(container);
        return this;
    }

    public ProcessorBuilder blockEntity(BlockEntityType.BlockEntitySupplier<? extends NCProcessorBE> be) {
        this.processor.setBlockEntity(be);
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ProcessorBuilder screen(MenuScreens.ScreenConstructor<M, U> screenConstructor) {
        this.processor.setScreenConstructor(screenConstructor);
        return this;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public ProcessorBuilder<M, U> screen(Object screenConstructor) {
        return this;
    }

    public ProcessorPrefab<?, ?> build() {
        return this.processor;
    }

    public ProcessorBuilder<?, ?> slotsConfig(ProcessorSlots config) {
        this.processor.slotsConfig = config;
        return this;
    }

    public ProcessorBuilder<?, ?> progressBar(int i) {
        this.processor.progressBar = i;
        return this;
    }

    public ProcessorBuilder<?, ?> recipeSerializer(Supplier<RecipeSerializer<? extends AbstractRecipe>> sup) {
        this.processor.recipeSerializerSupplier = sup;
        return this;
    }

    public ProcessorBuilder<?, ?> recipe(NcRecipeSerializer.IFactory<? extends NcRecipe> factory) {
        this.processor.recipeSerializerSupplier = () -> new NcRecipeSerializer(factory);
        return this;
    }

    public ProcessorBuilder<?, ?> upgrades(boolean energy, boolean speed) {
        this.processor.supportEnergyUpgrade = energy;
        this.processor.supportSpeedUpgrade = speed;
        return this;
    }

    public ProcessorBuilder<?, ?> withCatalyst() {
        this.processor.supportsCatalyst = true;
        return this;
    }

    public ProcessorBuilder<?, ?> setHiddenSlots(Integer ... i) {
        Integer[] integerArray = i;
        int n = integerArray.length;
        for (int j = 0; j < n; ++j) {
            int id = integerArray[j];
            this.processor.hiddenSlots.add(id);
        }
        return this;
    }

    public ProcessorBuilder<?, ?> power(int i) {
        this.processor.power = i;
        return this;
    }
}

