/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.oc2;

import igentuman.nc.block.entity.fusion.FusionCoreBE;
import java.util.Collection;
import java.util.Collections;
import li.cil.oc2r.api.bus.device.Device;
import li.cil.oc2r.api.bus.device.object.Callback;
import li.cil.oc2r.api.bus.device.object.NamedDevice;
import li.cil.oc2r.api.bus.device.object.ObjectDevice;
import li.cil.oc2r.api.bus.device.rpc.RPCDevice;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;

public class NCFusionReactorDevice {
    public static final Capability<Device> DEVICE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Device>(){});

    public static RPCDevice createDevice(FusionCoreBE<?> blockEntity) {
        return new ObjectDevice((Object)new NCFusionReactorDeviceRecord(blockEntity));
    }

    public record NCFusionReactorDeviceRecord(FusionCoreBE<?> reactor) implements NamedDevice
    {
        @Callback
        public String getName() {
            return this.reactor.getName();
        }

        @Callback
        public boolean hasRecipe() {
            return this.reactor.hasRecipe();
        }

        @Callback
        public double getMaxHeatCapacity() {
            return this.reactor.getMaxHeat();
        }

        @Callback
        public void enableReactor() {
            this.reactor.disableForceShutdown();
        }

        @Callback
        public void disableReactor() {
            this.reactor.forceShutdown();
        }

        @Callback
        public int getEnergyPerTick() {
            return this.reactor.energyPerTick;
        }

        @Callback
        public int setRFAmplification(int amplification) {
            this.reactor.rfAmplificationRatio = Math.min(100, Math.max(amplification, 1));
            return this.reactor.rfAmplificationRatio;
        }

        @Callback
        public int getEnergyStored() {
            return this.reactor.energyStorage.getEnergyStored();
        }

        @Callback
        public double getPlasmaStability() {
            return this.reactor.getControlPartsEfficiency();
        }

        @Callback
        public int getHeatStored() {
            return (int)this.reactor.reactorHeat;
        }

        @Callback
        public void voidFuel() {
            this.reactor.voidFuel();
        }

        @NotNull
        public Collection<String> getDeviceTypeNames() {
            return Collections.singletonList(this.getName());
        }
    }
}

