/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.particle;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.client.particle.ShaderLoader;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlackHoleShaderManager {
    private static final ShaderTracker tracker = new ShaderTracker();

    public BlackHoleShaderManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        event.registerShader(ShaderLoader.getBlackHoleShader(), tracker::setInstance);
    }

    @SubscribeEvent
    public void onRenderWorld(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        double playerX = mc.f_91074_.m_20185_();
        double playerY = mc.f_91074_.m_20186_();
        double playerZ = mc.f_91074_.m_20189_();
        double blackHoleX = 110.0;
        double blackHoleY = -60.0;
        double blackHoleZ = 102.0;
        ShaderInstance shader = ShaderLoader.getBlackHoleShader();
        double distance = Math.sqrt(Math.pow(playerX - blackHoleX, 2.0) + Math.pow(playerY - blackHoleY, 2.0) + Math.pow(playerZ - blackHoleZ, 2.0));
        Uniform radiusUniform = shader.m_173348_("BlackholeRadius");
        Uniform distortionUniform = shader.m_173348_("DistortionAmount");
        Uniform time = shader.m_173348_("Time");
        if (radiusUniform != null) {
            radiusUniform.m_5985_(1.3f);
        }
        if (distortionUniform != null) {
            distortionUniform.m_5985_(0.5f);
        }
        if (time != null) {
            time.m_5985_((float)(mc.f_91073_.m_46467_() / 20L));
        }
        shader.m_173363_();
        if (distance < 15.0) {
            RenderSystem.setShader(() -> shader);
        } else {
            RenderSystem.setShader(GameRenderer::m_172808_);
        }
    }

    static class ShaderTracker
    implements Supplier<ShaderInstance> {
        private ShaderInstance instance;

        private ShaderTracker() {
        }

        private void setInstance(ShaderInstance instance) {
            this.instance = instance;
        }

        @Override
        public ShaderInstance get() {
            return this.instance;
        }
    }
}

