/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.fission;

import igentuman.nc.block.MultiblockBlock;
import igentuman.nc.handler.event.client.InputEvents;
import igentuman.nc.multiblock.fission.FissionBlocks;
import igentuman.nc.multiblock.fission.HeatSinkDef;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class HeatSinkBlock
extends MultiblockBlock {
    public double heat = 0.0;
    public String type = "";
    public HeatSinkDef def;
    public Component placementRule;

    public HeatSinkBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_());
    }

    public HeatSinkBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
        this.initParams();
    }

    public HeatSinkBlock(BlockBehaviour.Properties reactorBlocksProperties, HeatSinkDef heatSinkDef) {
        super(reactorBlocksProperties);
        this.type = heatSinkDef.name;
        this.def = heatSinkDef;
        this.heat = this.def.getHeat();
    }

    public Component getPlacementRule() {
        if (this.placementRule == null) {
            ArrayList<String> lines = new ArrayList<String>();
            int i = 0;
            if (this.def.getValidator() instanceof HeatSinkDef.Validator) {
                for (String[] condition : this.def.getValidator().blockLines().keySet()) {
                    if (i > 0) {
                        lines.add(Component.m_237115_((String)"heat_sink.and").getString());
                    }
                    String blocksLine = String.join((CharSequence)(" " + Component.m_237115_((String)"heat_sink.or").getString() + " "), this.getBlockNames(condition[2]));
                    switch (condition[0]) {
                        case ">": {
                            lines.add(Component.m_237110_((String)("heat_sink.atleast" + (condition[1].equals("1") ? "" : "s")), (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "-": {
                            lines.add(Component.m_237110_((String)"heat_sink.between", (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "=": {
                            lines.add(Component.m_237110_((String)("heat_sink.exact" + (condition[1].equals("1") ? "" : "s")), (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "<": {
                            lines.add(Component.m_237110_((String)"heat_sink.less_than", (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "^": {
                            lines.add(Component.m_237110_((String)"heat_sink.in_corner", (Object[])new Object[]{condition[1], blocksLine}).getString());
                        }
                    }
                    ++i;
                }
                this.placementRule = Component.m_237110_((String)"heat_sink.placement.rule", (Object[])new Object[]{String.join((CharSequence)" ", lines)});
            } else {
                this.placementRule = Component.m_237115_((String)"heat_sink.placement.error");
            }
        }
        return this.placementRule;
    }

    private List<String> getBlockNames(String rawLine) {
        String[] blocks;
        ArrayList<String> names = new ArrayList<String>();
        String[] conditionParts = rawLine.split("=|-|>|<|\\^");
        for (String code : blocks = conditionParts[0].split("\\|")) {
            Object id = code;
            if (!((String)id).contains(":")) {
                id = "nuclearcraft:" + (String)id;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)id));
                names.add(block.m_49954_().getString());
                continue;
            }
            names.add(TextUtils.convertToName(((String)id).split(":")[1]));
        }
        return names;
    }

    private void initParams() {
        Item item = Item.m_41439_((Block)this);
        if (item.toString().isEmpty()) {
            return;
        }
        if (item.toString().contains("empty")) {
            return;
        }
        this.type = item.toString().replace("_heat_sink", "");
        this.def = FissionBlocks.heatsinks.get(this.type);
        this.heat = this.def.getHeat();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Block block;
        if (!player.m_21120_(hand).m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_() && (block = level.m_8055_(pos).m_60734_()) instanceof HeatSinkBlock) {
            int id = level.f_46441_.m_188503_(10);
            if (this.isValid(level, pos)) {
                player.m_213846_((Component)Component.m_237115_((String)("message.heat_sink.valid" + id)));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)("message.heat_sink.invalid" + id)));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        if (this.m_5456_().toString().contains("empty")) {
            return;
        }
        this.initParams();
        list.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"heat_sink.heat.descr", (Object[])new Object[]{TextUtils.numberFormat(this.heat)}), ChatFormatting.GOLD));
        if (InputEvents.DESCRIPTIONS_SHOW) {
            list.add((Component)TextUtils.applyFormat(this.getPlacementRule(), ChatFormatting.AQUA));
            if (this.isActive()) {
                list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"tooltip.active_heatsink"), ChatFormatting.YELLOW));
            }
        } else {
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"tooltip.toggle_description_keys"), ChatFormatting.GRAY));
        }
    }

    public boolean isValid(Level level, BlockPos pos) {
        return this.def.getValidator().isValid(level, pos);
    }

    public boolean isActive() {
        return this.def.name.contains("active");
    }
}

