/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.energy;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.content.energy.RTGs;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DecayGeneratorBE
extends NCEnergy {
    public Block leadBlock;
    public int decayDuration = 36000;
    private int[] ticks = new int[6];
    private List<Block> allowedBlocks = new ArrayList<Block>();
    protected int radiationTimer = 40;

    public DecayGeneratorBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, DecayGeneratorBE.getName(pBlockState));
        this.energyStorage.setMaxCapacity(2000);
    }

    public static String getName(BlockState pBlockState) {
        return pBlockState.m_60734_().m_5456_().toString();
    }

    @Override
    public String getName() {
        return this.m_58900_().m_60734_().m_5456_().toString();
    }

    private List<Block> getAllowedBlocks() {
        if (this.allowedBlocks.isEmpty()) {
            this.allowedBlocks = TagUtil.getBlocksByTagKey(NCBlocks.DECAY_GEN_BLOCK.f_203868_().toString());
        }
        return this.allowedBlocks;
    }

    private Block getLeadBlock() {
        if (this.leadBlock == null) {
            this.leadBlock = TagUtil.getSingleBlockByTagKey("forge:storage_blocks/lead");
        }
        return this.leadBlock;
    }

    private int getEnergyFromConnectedBlocks() {
        double energy = 0.0;
        for (Direction side : Direction.values()) {
            Block connectedBlock = this.m_58904_().m_8055_(this.m_58899_().m_121945_(side)).m_60734_();
            if (!this.getAllowedBlocks().contains(connectedBlock)) {
                this.ticks[side.ordinal()] = 0;
                continue;
            }
            energy += Math.log(ItemRadiation.byItem(connectedBlock.m_5456_()) * 5000000.0) * 10.0;
            int n = side.ordinal();
            this.ticks[n] = this.ticks[n] + 1;
            if (this.ticks[side.ordinal()] <= this.decayDuration) continue;
            this.ticks[side.ordinal()] = 0;
            this.decayBlock(this.m_58899_().m_121945_(side));
        }
        return (int)((double)((int)energy) * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get());
    }

    private void decayBlock(BlockPos relative) {
        this.m_58904_().m_7731_(relative, this.getLeadBlock().m_49966_(), 3);
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped) {
            return;
        }
        super.tickServer();
        this.energyStorage.setEnergy(this.getEnergyFromConnectedBlocks());
        this.sendOutPower();
        --this.radiationTimer;
        if (this.radiationTimer <= 0) {
            this.radiationTimer = 40;
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), (double)RTGs.all().get("uranium_rtg").config().getRadiation() / 5.0E8, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
    }

    @Override
    protected int getEnergyMaxStorage() {
        return (Integer)CommonConfig.ENERGY_GENERATION.DECAY_GENERATOR.get();
    }

    @Override
    protected int getEnergyTransferPerTick() {
        return this.energyStorage.getEnergyStored();
    }
}

