/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity;

import igentuman.nc.block.ISizeToggable;
import igentuman.nc.client.sound.SoundHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.util.NCBlockPos;
import igentuman.nc.util.annotation.NBTField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class NuclearCraftBE
extends BlockEntity {
    protected final String name;
    protected NCBlockPos bePos;
    protected boolean changed;
    protected SoundInstance currentSound;
    protected int playSoundCooldown = 0;
    protected UUID playerUID = null;
    public HashMap<Integer, ISizeToggable.SideMode> sideConfig = new HashMap();
    private final List<Field> booleanFields;
    private final List<Field> intFields;
    private final List<Field> intArrayFields;
    private final List<Field> doubleFields;
    private final List<Field> stringFields;
    private final List<Field> stringArrayFields;
    private final List<Field> floatFields;
    private final List<Field> byteFields;
    private final List<Field> longFields;
    private final List<Field> blockPosFields;
    private final List<Field> directionFields;

    public NuclearCraftBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.name = NuclearCraftBE.getName(pBlockState);
        this.directionFields = this.initFields(Direction.class);
        this.booleanFields = this.initFields(Boolean.TYPE);
        this.intFields = this.initFields(Integer.TYPE);
        this.intArrayFields = this.initFields(int[].class);
        this.doubleFields = this.initFields(Double.TYPE);
        this.stringFields = this.initFields(String.class);
        this.stringArrayFields = this.initFields(String[].class);
        this.blockPosFields = this.initFields(BlockPos.class);
        this.floatFields = this.initFields(Float.TYPE);
        this.byteFields = this.initFields(Byte.TYPE);
        this.longFields = this.initFields(Long.TYPE);
    }

    public static String getName(BlockState pBlockState) {
        return pBlockState.m_60734_().m_5456_().toString();
    }

    protected void trackChanges(boolean was, boolean now) {
        this.changed = was != now || this.changed;
    }

    protected void trackChanges(boolean was) {
        this.changed = was || this.changed;
    }

    public void saveTagData(CompoundTag tag) {
        try {
            for (Field f : this.blockPosFields) {
                if (f.get((Object)this) == null) continue;
                tag.m_128356_(f.getName(), ((BlockPos)f.get((Object)this)).m_121878_());
            }
            for (Field f : this.directionFields) {
                tag.m_128359_(f.getName(), ((Direction)f.get((Object)this)).m_122433_());
            }
            for (Field f : this.booleanFields) {
                tag.m_128379_(f.getName(), f.getBoolean((Object)this));
            }
            for (Field f : this.intFields) {
                tag.m_128405_(f.getName(), f.getInt((Object)this));
            }
            for (Field f : this.stringFields) {
                tag.m_128359_(f.getName(), (String)f.get((Object)this));
            }
            for (Field f : this.doubleFields) {
                tag.m_128347_(f.getName(), f.getDouble((Object)this));
            }
            for (Field f : this.floatFields) {
                tag.m_128350_(f.getName(), f.getFloat((Object)this));
            }
            for (Field f : this.byteFields) {
                tag.m_128344_(f.getName(), f.getByte((Object)this));
            }
            for (Field f : this.longFields) {
                tag.m_128356_(f.getName(), f.getLong((Object)this));
            }
            for (Field f : this.intArrayFields) {
                tag.m_128385_(f.getName(), (int[])f.get((Object)this));
            }
            for (Field f : this.stringArrayFields) {
                String[] stringArray = (String[])f.get((Object)this);
                ListTag tagList = new ListTag();
                for (String string : stringArray) {
                    tagList.add((Object)StringTag.m_129297_((String)string));
                }
                tag.m_128365_(f.getName(), (Tag)tagList);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (Objects.requireNonNull(this.m_58904_()).m_5776_()) {
            this.stopSound();
        }
    }

    protected void stopSound() {
        if (this.currentSound == null) {
            return;
        }
        SoundHandler.stopTileSound(this.m_58899_());
        this.currentSound = null;
        this.playSoundCooldown = 0;
    }

    public void readTagData(CompoundTag tag) {
        try {
            for (Field f : this.directionFields) {
                f.set((Object)this, Direction.m_122402_((String)tag.m_128461_(f.getName())));
            }
            for (Field f : this.blockPosFields) {
                f.set((Object)this, BlockPos.m_122022_((long)tag.m_128454_(f.getName())));
            }
            for (Field f : this.booleanFields) {
                f.setBoolean((Object)this, tag.m_128471_(f.getName()));
            }
            for (Field f : this.intFields) {
                f.setInt((Object)this, tag.m_128451_(f.getName()));
            }
            for (Field f : this.stringFields) {
                f.set((Object)this, tag.m_128461_(f.getName()));
            }
            for (Field f : this.doubleFields) {
                f.setDouble((Object)this, tag.m_128459_(f.getName()));
            }
            for (Field f : this.floatFields) {
                f.setFloat((Object)this, tag.m_128457_(f.getName()));
            }
            for (Field f : this.byteFields) {
                f.setByte((Object)this, tag.m_128445_(f.getName()));
            }
            for (Field f : this.longFields) {
                f.setLong((Object)this, tag.m_128454_(f.getName()));
            }
            for (Field f : this.intArrayFields) {
                f.set((Object)this, tag.m_128465_(f.getName()));
            }
            for (Field f : this.intArrayFields) {
                ListTag tagList = tag.m_128437_(f.getName(), 8);
                String[] stringArray = new String[tagList.size()];
                for (int i = 0; i < tagList.size(); ++i) {
                    stringArray[i] = tagList.m_128778_(i);
                }
                f.set((Object)this, stringArray);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private List<Field> initFields(Class<?> fieldClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ((Object)((Object)this)).getClass().getFields()) {
            if (!field.isAnnotationPresent(NBTField.class) || !field.getType().equals(fieldClass)) continue;
            fields.add(field);
        }
        return fields;
    }

    public ItemCapabilityHandler getItemInventory() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void handleSliderUpdate(int buttonId, int ratio) {
    }

    public void loadClientData(CompoundTag tag) {
    }

    protected void saveClientData(CompoundTag tag) {
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveClientData(tag);
        if (this.playerUID != null) {
            tag.m_128362_("playerUID", this.playerUID);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.loadClientData(tag);
            if (tag.m_128441_("playerUID")) {
                this.playerUID = tag.m_128342_("playerUID");
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
    }

    public void setPlayer(ServerPlayer player) {
        this.playerUID = player.m_20148_();
    }
}

