/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import thetadev.constructionwand.ConstructionWand;

public class PacketQueryUndo {
    public boolean undoPressed;

    public PacketQueryUndo(boolean undoPressed) {
        this.undoPressed = undoPressed;
    }

    public static void encode(PacketQueryUndo msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.undoPressed);
    }

    public static PacketQueryUndo decode(FriendlyByteBuf buffer) {
        return new PacketQueryUndo(buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketQueryUndo msg, Supplier<NetworkEvent.Context> ctx) {
            if (!ctx.get().getDirection().getReceptionSide().isServer()) {
                return;
            }
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return;
            }
            ConstructionWand.instance.undoHistory.updateClient((Player)player, msg.undoPressed);
        }
    }
}

