/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.screens.base;

import com.teamresourceful.resourcefullib.client.screens.AbstractContainerCursorScreen;
import earth.terrarium.adastra.client.components.base.TickableWidget;
import earth.terrarium.adastra.client.components.machines.ConfigurationWidget;
import earth.terrarium.adastra.client.components.machines.EnergyBarWidget;
import earth.terrarium.adastra.client.components.machines.FluidBarWidget;
import earth.terrarium.adastra.client.components.machines.OptionsBarWidget;
import earth.terrarium.adastra.client.components.machines.SidedConfigWidget;
import earth.terrarium.adastra.client.components.machines.SlotWidget;
import earth.terrarium.adastra.client.screens.base.AbstractContainerScreenExtension;
import earth.terrarium.adastra.client.screens.base.ConfigurationScreen;
import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.menus.base.BaseConfigurableContainerMenu;
import earth.terrarium.adastra.common.menus.base.BaseContainerMenu;
import earth.terrarium.adastra.common.menus.base.MachineMenu;
import earth.terrarium.adastra.common.menus.configuration.EnergyConfiguration;
import earth.terrarium.adastra.common.menus.configuration.FluidConfiguration;
import earth.terrarium.adastra.common.menus.configuration.MenuConfiguration;
import earth.terrarium.adastra.common.menus.configuration.SlotConfiguration;
import earth.terrarium.adastra.common.menus.slots.ImageSlot;
import earth.terrarium.adastra.common.menus.slots.InventorySlot;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.adastra.mixins.common.SlotAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public abstract class MachineScreen<T extends BaseContainerMenu<U>, U extends ContainerMachineBlockEntity>
extends AbstractContainerCursorScreen<T>
implements ConfigurationScreen,
AbstractContainerScreenExtension {
    public static final ResourceLocation IRON_SLOT = new ResourceLocation("ad_astra", "textures/gui/container/slots/iron.png");
    public static final ResourceLocation STEEL_SLOT = new ResourceLocation("ad_astra", "textures/gui/container/slots/steel.png");
    private final ResourceLocation texture;
    private final ResourceLocation slotTexture;
    private final Rect2i inventoryRect;
    protected final U entity;
    protected SidedConfigWidget sideConfigWidget;
    protected OptionsBarWidget optionsBarWidget;

    public MachineScreen(T menu, Inventory inventory, Component component, ResourceLocation texture, ResourceLocation slotTexture, int width, int height) {
        super(menu, inventory, component);
        this.texture = texture;
        this.slotTexture = slotTexture;
        this.f_97726_ = width;
        this.f_97727_ = height;
        this.entity = (ContainerMachineBlockEntity)((BaseContainerMenu)((Object)menu)).getEntity();
        List<Slot> inventorySlots = ((BaseContainerMenu)this.f_97732_).f_38839_.stream().filter(slot -> slot instanceof InventorySlot).toList();
        int minXInventorySlot = inventorySlots.stream().mapToInt(slot -> slot.f_40220_).min().orElse(0);
        int maxXInventorySlot = inventorySlots.stream().mapToInt(slot -> slot.f_40220_).max().orElse(0);
        int minYInventorySlot = inventorySlots.stream().mapToInt(slot -> slot.f_40221_).min().orElse(0);
        int maxYInventorySlot = inventorySlots.stream().mapToInt(slot -> slot.f_40221_).max().orElse(0);
        this.inventoryRect = new Rect2i(minXInventorySlot - 1, minYInventorySlot - 1, maxXInventorySlot - minXInventorySlot + 18, maxYInventorySlot - minYInventorySlot + 18);
        int n = this.inventoryRect.m_110086_() - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.f_97731_ = n - 9;
    }

    protected void m_7856_() {
        super.m_7856_();
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof BaseConfigurableContainerMenu) {
            BaseConfigurableContainerMenu configurableMenu = (BaseConfigurableContainerMenu)abstractContainerMenu;
            for (MenuConfiguration configuration : configurableMenu.getConfigurations()) {
                ConfigurationWidget element = switch (configuration.type()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ConfigurationType.SLOT -> (SlotWidget)this.m_142416_((GuiEventListener)new SlotWidget((SlotConfiguration)configuration));
                    case ConfigurationType.ENERGY -> (EnergyBarWidget)this.m_142416_((GuiEventListener)new EnergyBarWidget((EnergyConfiguration)configuration));
                    case ConfigurationType.FLUID -> (FluidBarWidget)this.m_142416_((GuiEventListener)new FluidBarWidget(this.entity.m_58899_(), (FluidConfiguration)configuration));
                };
                element.m_264152_(this.f_97735_ + configuration.x(), this.f_97736_ + configuration.y());
            }
        }
        this.sideConfigWidget = (SidedConfigWidget)this.m_142416_((GuiEventListener)new SidedConfigWidget(this.f_97735_ + this.inventoryRect.m_110085_(), this.f_97736_ + this.inventoryRect.m_110086_(), this.inventoryRect.m_110090_(), this.inventoryRect.m_110091_(), (BaseContainerMenu)this.f_97732_));
        this.optionsBarWidget = (OptionsBarWidget)this.m_142416_((GuiEventListener)this.createOptionsBar().build(this.f_97735_ + this.f_97726_, this.f_97736_ - 2));
        this.moveBatterySlot();
    }

    public OptionsBarWidget.Builder createOptionsBar() {
        MachineMenu machineMenu;
        OptionsBarWidget.Builder builder = OptionsBarWidget.builder().addSettingsButton(this.sideConfigWidget::toggle).addRedstoneButton((ContainerMachineBlockEntity)this.entity);
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof MachineMenu && (machineMenu = (MachineMenu)abstractContainerMenu).getBatterySlot() != null) {
            builder.addBattery();
        }
        return builder;
    }

    protected void moveBatterySlot() {
        MachineMenu machineMenu;
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof MachineMenu && (machineMenu = (MachineMenu)abstractContainerMenu).getBatterySlot() != null) {
            SlotAccessor accessor = (SlotAccessor)machineMenu.getBatterySlot();
            accessor.setX(this.optionsBarWidget.m_252754_() + this.optionsBarWidget.m_5711_() - 6 - this.f_97735_ + 1 - 18);
            accessor.setY(this.optionsBarWidget.m_252907_() + 6 - this.f_97736_ + 1);
        }
    }

    protected void m_181908_() {
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof TickableWidget)) continue;
            TickableWidget tickable = (TickableWidget)child;
            tickable.tick();
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280163_(this.texture, left, top, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
    }

    @Override
    public void adastra$renderPreSlot(GuiGraphics graphics, Slot slot) {
        ResourceLocation texture = null;
        if (slot.m_6659_() && slot instanceof InventorySlot) {
            texture = this.slotTexture;
        } else if (slot instanceof ImageSlot) {
            ImageSlot imageSlot = (ImageSlot)slot;
            texture = imageSlot.getSlotTexture();
        }
        if (texture != null) {
            graphics.m_280163_(texture, slot.f_40220_ - 1, slot.f_40221_ - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 2762283, false);
        Component label = this.canConfigure() ? this.sideConfigWidget.getMessage() : this.f_169604_;
        graphics.m_280614_(this.f_96547_, label, this.f_97730_, this.f_97731_, 2762283, false);
    }

    public void drawHorizontalProgressBar(GuiGraphics graphics, ResourceLocation texture, int mouseX, int mouseY, int xOffset, int yOffset, int width, int height, int progress, int maxProgress, boolean reverse) {
        GuiUtils.drawHorizontalProgressBar(graphics, texture, mouseX, mouseY, this.f_97735_ + xOffset, this.f_97736_ + yOffset, width, height, progress, maxProgress, reverse, TooltipUtils.getProgressComponent(progress, maxProgress), TooltipUtils.getEtaComponent(progress, maxProgress, reverse));
    }

    public void drawVerticalProgressBar(GuiGraphics graphics, ResourceLocation texture, int mouseX, int mouseY, int xOffset, int yOffset, int width, int height, int progress, int maxProgress, boolean reverse) {
        GuiUtils.drawVerticalProgressBar(graphics, texture, mouseX, mouseY, this.f_97735_ + xOffset, this.f_97736_ + yOffset, width, height, progress, maxProgress, TooltipUtils.getProgressComponent(progress, maxProgress), TooltipUtils.getEtaComponent(progress, maxProgress, reverse));
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_7522_(null);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public int leftPos() {
        return this.f_97735_;
    }

    public int topPos() {
        return this.f_97736_;
    }

    public void testClickArea(GuiGraphics graphics, Rect2i clickArea) {
        graphics.m_280509_(this.f_97735_ + clickArea.m_110085_(), this.f_97736_ + clickArea.m_110086_(), this.f_97735_ + clickArea.m_110085_() + clickArea.m_110090_(), this.f_97736_ + clickArea.m_110086_() + clickArea.m_110091_(), 0x40FFFF00);
    }

    public void m_7379_() {
        if (this.canConfigure()) {
            this.sideConfigWidget.toggle();
        } else {
            super.m_7379_();
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        if (this.optionsBarWidget.m_5953_(mouseX, mouseY)) {
            return false;
        }
        return super.m_7467_(mouseX, mouseY, guiLeft, guiTop, mouseButton);
    }

    @Override
    public SidedConfigWidget getSideConfigWidget() {
        return this.sideConfigWidget;
    }
}

