/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.adastra.client.ClientPlatformUtils;
import earth.terrarium.adastra.common.blockentities.machines.GravityNormalizerBlockEntity;
import earth.terrarium.adastra.common.blocks.base.SidedMachineBlock;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class GravityNormalizerBlockEntityRenderer
implements BlockEntityRenderer<GravityNormalizerBlockEntity> {
    public static final ResourceLocation TOP = new ResourceLocation("ad_astra", "block/gravity_normalizer_top");
    public static final ResourceLocation TOE = new ResourceLocation("ad_astra", "block/gravity_normalizer_toe");
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);

    public void render(GravityNormalizerBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        AttachFace face = (AttachFace)entity.m_58900_().m_61143_(SidedMachineBlock.FACE);
        Direction direction = (Direction)entity.m_58900_().m_61143_((Property)SidedMachineBlock.FACING);
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            if (face == AttachFace.CEILING) {
                pose.m_252880_(0.0f, 1.0f, 1.0f);
                pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            } else if (face == AttachFace.FLOOR) {
                pose.m_252781_(Axis.f_252529_.m_252977_(0.0f));
            } else {
                if (direction == Direction.NORTH) {
                    pose.m_252880_(0.0f, 0.0f, 1.0f);
                } else if (direction == Direction.SOUTH) {
                    pose.m_252880_(1.0f, 0.0f, 0.0f);
                } else if (direction == Direction.WEST) {
                    pose.m_252880_(1.0f, 0.0f, 1.0f);
                }
                this.rotateBlock(direction, (PoseStack)pose);
                pose.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            float animation = Mth.m_14179_((float)partialTick, (float)entity.lastAnimation(), (float)entity.animation());
            GravityNormalizerBlockEntityRenderer.render(entity.m_58900_(), animation, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    private static void render(BlockState state, float animation, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BakedModel blockModel = ClientPlatformUtils.getModel(Minecraft.m_91087_().m_91304_(), TOP);
        BakedModel toeModel = ClientPlatformUtils.getModel(Minecraft.m_91087_().m_91304_(), TOE);
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            pose.m_85836_();
            pose.m_85837_(0.5, 0.7, 0.5);
            pose.m_252781_(Axis.f_252529_.m_252977_(animation));
            pose.m_252781_(Axis.f_252436_.m_252977_(animation));
            pose.m_252781_(Axis.f_252403_.m_252977_(animation));
            float yRot = animation / 1.2f;
            pose.m_252781_(Axis.f_252436_.m_252977_(yRot));
            pose.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            pose.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            pose.m_252781_(Axis.f_252436_.m_252977_(yRot));
            pose.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            pose.m_252781_(Axis.f_252436_.m_252977_(yRot));
            pose.m_85837_(-0.5, -0.7, -0.5);
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(pose.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), state, blockModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
            pose.m_85849_();
            for (int i = 0; i < 4; ++i) {
                poseStack.m_85836_();
                pose.m_85837_(0.5, 0.0, 0.5);
                pose.m_252781_(Axis.f_252436_.m_252977_((float)(90 * i)));
                pose.m_85837_(-0.5, 0.0, -0.5);
                pose.m_85837_(0.27, 0.27, 0.27);
                pose.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)(animation / 50.0f + (float)i)) * 10.0f));
                pose.m_85837_(-0.27, -0.27, -0.27);
                Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(pose.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), state, toeModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
                poseStack.m_85849_();
            }
        }
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            }
        }
    }

    public static class ItemRenderer
    extends BlockEntityWithoutLevelRenderer {
        public ItemRenderer() {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
            BlockState state = ((Block)BuiltInRegistries.f_256975_.m_7745_(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()))).m_49966_();
            Minecraft minecraft = Minecraft.m_91087_();
            float yRot = (float)Util.m_137550_() / 5.0f;
            try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
                BakedModel model = minecraft.m_91289_().m_110910_(state);
                minecraft.m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), state, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
                GravityNormalizerBlockEntityRenderer.render(state, yRot, poseStack, buffer, packedLight, packedOverlay);
            }
        }
    }
}

