/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.mixin;

import com.google.common.collect.Streams;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import se.mickelus.tetra.aspect.TetraEnchantmentHelper;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(at={@At(value="RETURN")}, method={"enchant(Lnet/minecraft/world/item/enchantment/Enchantment;I)V"})
    private void addEnchantment(Enchantment enchantment, int level, CallbackInfo callback) {
        Item item = this.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemStack itemStack = this.getInstance();
            TetraEnchantmentHelper.mapEnchantments(itemStack);
            item2.assemble(itemStack, null, 0.0f);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"is(Lnet/minecraft/tags/TagKey;)Z"}, cancellable=true)
    private void isWithModularTags(TagKey<Item> pTag, CallbackInfoReturnable<Boolean> callback) {
        Item item;
        if (!((Boolean)callback.getReturnValue()).booleanValue() && (item = this.m_41720_()) instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            Set<TagKey<Item>> tags = item2.getPropertiesCached((ItemStack)this.getInstance()).tags;
            if (tags != null) {
                callback.setReturnValue((Object)tags.contains(pTag));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getTags()Ljava/util/stream/Stream;"}, cancellable=true)
    private void getTagsWithModularTags(CallbackInfoReturnable<Stream<TagKey<Item>>> callback) {
        Item item = this.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            Set<TagKey<Item>> tags = item2.getPropertiesCached((ItemStack)this.getInstance()).tags;
            if (tags != null) {
                callback.setReturnValue((Object)Streams.concat((Stream[])new Stream[]{(Stream)callback.getReturnValue(), tags.stream()}));
            }
        }
    }

    @Shadow
    public Item m_41720_() {
        throw new IllegalStateException("Mixin failed to shadow getItem()");
    }

    private ItemStack getInstance() {
        return (ItemStack)this;
    }
}

