/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.data.StatRegistry;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.StatGetterAdd;
import se.mickelus.tetra.gui.stats.getter.StatGetterAnd;
import se.mickelus.tetra.gui.stats.getter.StatGetterAttribute;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.StatGetterEnchantmentLevel;
import se.mickelus.tetra.gui.stats.getter.StatGetterMultiply;
import se.mickelus.tetra.gui.stats.getter.StatGetterOr;

public class StatGetterDeserializers {
    public static IStatGetter andGetter(JsonElement json) {
        AndData data = (AndData)StatRegistry.gson.fromJson(json, AndData.class);
        return new StatGetterAnd(data.stats);
    }

    public static IStatGetter orGetter(JsonElement json) {
        OrData data = (OrData)StatRegistry.gson.fromJson(json, OrData.class);
        return new StatGetterOr(data.stats);
    }

    public static IStatGetter sumGetter(JsonElement json) {
        SumData data = (SumData)StatRegistry.gson.fromJson(json, SumData.class);
        return new StatGetterAdd(data.offset != null ? data.offset : 0.0, data.stats);
    }

    public static IStatGetter multiplyGetter(JsonElement json) {
        MultiplyData data = (MultiplyData)StatRegistry.gson.fromJson(json, MultiplyData.class);
        return new StatGetterMultiply(data.factor != null ? data.factor : 1.0, data.stats);
    }

    public static IStatGetter attributeGetter(JsonElement json) {
        AttributeData data = (AttributeData)StatRegistry.gson.fromJson(json, AttributeData.class);
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(data.attribute));
        if (attribute == null) {
            throw new JsonParseException("Failed to parse attribute stat getter, unknown attribute: " + data.attribute);
        }
        return new StatGetterAttribute(attribute, data.ignoreBase != null ? data.ignoreBase : false, data.ignoreBonuses != null ? data.ignoreBonuses : false);
    }

    public static IStatGetter effectEfficiencyGetter(JsonElement json) {
        EffectEfficiencyData data = (EffectEfficiencyData)StatRegistry.gson.fromJson(json, EffectEfficiencyData.class);
        return new StatGetterEffectEfficiency(ItemEffect.get(data.effect));
    }

    public static IStatGetter effectLevelGetter(JsonElement json) {
        EffectLevelData data = (EffectLevelData)StatRegistry.gson.fromJson(json, EffectLevelData.class);
        return new StatGetterEffectLevel(ItemEffect.get(data.effect));
    }

    public static IStatGetter enchantmentGetter(JsonElement json) {
        EnchantmentData data = (EnchantmentData)StatRegistry.gson.fromJson(json, EnchantmentData.class);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(data.enchantment));
        if (enchantment == null) {
            throw new JsonParseException("Failed to parse enchantment stat getter, unknown enchantment: " + data.enchantment);
        }
        return new StatGetterEnchantmentLevel(enchantment);
    }

    record AndData(IStatGetter[] stats) {
    }

    record OrData(IStatGetter[] stats) {
    }

    record SumData(IStatGetter[] stats, Double offset) {
    }

    record MultiplyData(IStatGetter[] stats, Double factor) {
    }

    record AttributeData(String attribute, @Nullable Boolean ignoreBase, @Nullable Boolean ignoreBonuses) {
    }

    record EffectEfficiencyData(String effect) {
    }

    record EffectLevelData(String effect) {
    }

    record EnchantmentData(String enchantment) {
    }
}

