/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.bar;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.gui.GuiAlignment;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.blocks.workbench.gui.GuiTool;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatIndicator;
import se.mickelus.tetra.gui.stats.bar.StrikingStatIndicatorGui;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterAdd;
import se.mickelus.tetra.gui.stats.getter.StatGetterAttribute;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.StatGetterEnchantmentLevel;
import se.mickelus.tetra.gui.stats.getter.StatGetterStriking;
import se.mickelus.tetra.gui.stats.getter.StatGetterToolCompoundEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterToolEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterToolLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterNone;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterSweepingFocus;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterTool;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class GuiStatBarTool
extends GuiStatBar {
    private static final int efficiencyMax = 50;
    private final GuiTool icon;
    private final IStatGetter levelGetter;
    private final boolean efficiencyVisibility;

    public GuiStatBarTool(int x, int y, int width, ToolAction toolAction) {
        this(x, y, width, toolAction, false, true);
    }

    public GuiStatBarTool(int x, int y, int width, ToolAction toolAction, boolean efficiencyVisibility, boolean includeSpeedModifier) {
        super(x, y, width, null, 0.0, 50.0, false, includeSpeedModifier ? new StatGetterToolCompoundEfficiency(new StatGetterToolEfficiency(toolAction), new StatGetterAttribute(Attributes.f_22283_), new StatGetterEnchantmentLevel(Enchantments.f_44984_, 1.0)) : new StatGetterAdd(new StatGetterToolEfficiency(toolAction), new StatGetterEnchantmentLevel(Enchantments.f_44984_, 1.0)), LabelGetterBasic.decimalLabel, new TooltipGetterTool(toolAction, includeSpeedModifier));
        this.efficiencyVisibility = efficiencyVisibility;
        this.bar.setWidth(width - 16);
        this.bar.setX(16);
        this.levelGetter = new StatGetterToolLevel(toolAction);
        this.icon = new GuiTool(-3, -3, toolAction);
        this.addChild(this.icon);
        StatGetterEffectLevel extractionGetter = new StatGetterEffectLevel(ItemEffect.extraction, 4.5);
        StatGetterEffectLevel unboundExtractionGetter = new StatGetterEffectLevel(ItemEffect.unboundExtraction, 1.0);
        StatGetterEnchantmentLevel enchantmentGetter = new StatGetterEnchantmentLevel(Enchantments.f_44984_, 1.0);
        StatGetterStriking actionGetter = new StatGetterStriking(toolAction);
        StatGetterEffectLevel sweepingGetter = new StatGetterEffectLevel(ItemEffect.sweepingStrike, 1.0);
        StatGetterEffectLevel truesweepGetter = new StatGetterEffectLevel(ItemEffect.truesweep, 1.0);
        StatGetterEffectLevel planarSweepGetter = new StatGetterEffectLevel(ItemEffect.planarSweep, 1.0);
        StatGetterEffectEfficiency focusGetter = new StatGetterEffectEfficiency(ItemEffect.sweepingFocus, 1.0);
        this.setIndicators(new StrikingStatIndicatorGui(toolAction), new GuiStatIndicator(0, 0, "tetra.stats.tool.truesweepingStrike", 4, truesweepGetter, new TooltipGetterNone("tetra.stats.tool.truesweepingStrike.tooltip")).withShowRequirements(actionGetter, sweepingGetter), new GuiStatIndicator(0, 0, "tetra.stats.tool.planarSweep", 21, planarSweepGetter, new TooltipGetterNone("tetra.stats.tool.planarSweep.tooltip")).withShowRequirements(actionGetter, sweepingGetter), new GuiStatIndicator(0, 0, "tetra.stats.tool.sweepingFocus", 22, focusGetter, new TooltipGetterSweepingFocus(focusGetter)).withShowRequirements(actionGetter, sweepingGetter), new GuiStatIndicator(0, 0, "tetra.stats.tool.extraction", 7, extractionGetter, new TooltipGetterInteger("tetra.stats.tool.extraction.tooltip", extractionGetter)), new GuiStatIndicator(0, 0, "tetra.stats.tool.unboundExtraction", 20, unboundExtractionGetter, new TooltipGetterInteger("tetra.stats.tool.unboundExtraction.tooltip", unboundExtractionGetter)), new GuiStatIndicator(0, 0, "tetra.stats.tool.efficiency", 17, enchantmentGetter, new TooltipGetterInteger("tetra.stats.tool.efficiency.tooltip", enchantmentGetter)));
    }

    @Override
    public void update(Player player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        super.update(player, currentStack, previewStack, slot, improvement);
        int level = (int)this.levelGetter.getValue(player, currentStack);
        int color = 0xFFFFFF;
        if (!previewStack.m_41619_()) {
            int previewLevel = (int)this.levelGetter.getValue(player, previewStack);
            color = this.getDiffColor(level, previewLevel);
            level = previewLevel;
        } else if (slot != null) {
            int previewLevel = level - this.getSlotLevel(player, currentStack, slot, improvement);
            color = this.getDiffColor(previewLevel, level);
        }
        this.icon.update(level, color);
    }

    @Override
    protected void realign() {
        super.realign();
        if (GuiAlignment.left.equals((Object)this.alignment)) {
            this.bar.setX(16);
            this.icon.setX(-3);
        } else {
            this.bar.setX(0);
            this.icon.setX(0);
        }
        this.icon.setAttachment(this.alignment.toAttachment());
        int offset = this.icon.getWidth();
        this.indicatorGroup.setX(GuiAlignment.right.equals((Object)this.alignment) ? -offset : offset);
    }

    @Override
    public boolean shouldShow(Player player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.levelGetter.getValue(player, currentStack) > 0.0 || this.levelGetter.getValue(player, previewStack) > 0.0 || this.efficiencyVisibility && (this.statGetter.getValue(player, currentStack) > 0.0 || this.statGetter.getValue(player, previewStack) > 0.0);
    }

    protected int getDiffColor(int currentValue, int previewValue) {
        if (previewValue > currentValue) {
            return 0x55FF55;
        }
        if (previewValue < currentValue) {
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }

    protected int getSlotLevel(Player player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> improvement != null ? this.levelGetter.getValue(player, itemStack, slot, improvement) : this.levelGetter.getValue(player, itemStack, slot)).orElse(-1.0).intValue();
    }
}

