/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data.provider.number;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import se.mickelus.mutil.util.JsonOptional;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.provider.number.ExpressionNumberProvider;
import se.mickelus.tetra.effect.data.provider.number.FixedNumberProvider;

public interface NumberProvider {
    public float getValue(ItemEffectContext var1);

    default public int getIntegerValue(ItemEffectContext context) {
        return Math.round(this.getValue(context));
    }

    public static void register(String identifier, Function<JsonElement, NumberProvider> deserializer) {
        Deserializer.deserializers.put(identifier, deserializer);
    }

    public static void register(String identifier, Class<? extends NumberProvider> clazz) {
        Deserializer.deserializers.put(identifier, json -> (NumberProvider)DataManager.gson.fromJson(json, clazz));
    }

    public static class Deserializer
    implements JsonDeserializer<NumberProvider> {
        static final Map<String, Function<JsonElement, NumberProvider>> deserializers = new HashMap<String, Function<JsonElement, NumberProvider>>();

        public NumberProvider deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject;
            String key;
            if (jsonElement.isJsonPrimitive()) {
                JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
                if (primitive.isString()) {
                    return ExpressionNumberProvider.parseExpression(primitive.getAsString());
                }
                if (primitive.isNumber()) {
                    return new FixedNumberProvider(primitive.getAsFloat());
                }
            }
            if (deserializers.containsKey(key = (String)JsonOptional.field((JsonObject)(jsonObject = jsonElement.getAsJsonObject()), (String)"type").map(JsonElement::getAsString).orElse(null))) {
                return deserializers.get(key).apply(jsonElement);
            }
            throw new JsonParseException("No deserializer found for NumberProvider type: " + key);
        }
    }
}

