/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.mutable.MutableBoolean;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class EffectHelper {
    private static final Cache<UUID, Float> cooledAttackStrengthCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private static final Cache<UUID, Boolean> sprintingCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static void setCooledAttackStrength(Player player, float strength) {
        cooledAttackStrengthCache.put((Object)player.m_20148_(), (Object)Float.valueOf(strength));
    }

    public static float getCooledAttackStrength(Player player) {
        try {
            return ((Float)cooledAttackStrengthCache.get((Object)player.m_20148_(), () -> Float.valueOf(0.0f))).floatValue();
        }
        catch (ExecutionException e) {
            return 0.0f;
        }
    }

    public static void setSprinting(LivingEntity player, boolean isSprinting) {
        sprintingCache.put((Object)player.m_20148_(), (Object)isSprinting);
    }

    public static boolean getSprinting(LivingEntity player) {
        try {
            return (Boolean)sprintingCache.get((Object)player.m_20148_(), () -> false);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public static int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        return item.getEffectLevel(itemStack, effect);
    }

    public static float getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        return item.getEffectEfficiency(itemStack, effect);
    }

    public static boolean breakBlock(Level world, Player breakingPlayer, ItemStack toolStack, BlockPos pos, BlockState blockState, boolean harvest, boolean tryReplant) {
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            ServerPlayer serverPlayer = (ServerPlayer)breakingPlayer;
            GameType gameType = serverPlayer.f_8941_.m_9290_();
            int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)serverPlayer, (BlockPos)pos);
            BlockEntity tileEntity = world.m_7702_(pos);
            if (exp != -1) {
                boolean canRemove;
                boolean bl = canRemove = !toolStack.onBlockStartBreak(pos, breakingPlayer) && !breakingPlayer.m_36187_(world, pos, gameType) && (!harvest || blockState.canHarvestBlock((BlockGetter)world, pos, breakingPlayer)) && blockState.m_60734_().onDestroyedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.m_6425_(pos));
                if (canRemove) {
                    blockState.m_60734_().m_6786_((LevelAccessor)world, pos, blockState);
                    if (tryReplant) {
                        EffectHelper.breakAndReplant(serverWorld, pos, blockState, breakingPlayer, toolStack, harvest);
                    } else if (harvest) {
                        blockState.m_60734_().m_6240_(world, breakingPlayer, pos, blockState, tileEntity, toolStack);
                    }
                    if (harvest && exp > 0) {
                        blockState.m_60734_().m_49805_(serverWorld, pos, exp);
                    }
                    if (harvest) {
                        blockState.m_222967_(serverWorld, pos, toolStack, false);
                    }
                }
                return canRemove;
            }
            return false;
        }
        return blockState.m_60734_().onDestroyedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.m_6425_(pos));
    }

    public static boolean tryReplant(ItemStack itemStack, ToolAction toolAction) {
        return toolAction == ToolActions.HOE_DIG && EnchantmentHelper.m_272262_((ItemStack)itemStack);
    }

    private static boolean breakAndReplant(ServerLevel serverLevel, BlockPos pos, BlockState blockState, Player entity, ItemStack itemStack, boolean doDrops) {
        BlockState blockState2;
        Block block = blockState.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            blockState2 = crop.m_49966_();
        } else {
            blockState2 = Blocks.f_50016_.m_49966_();
        }
        BlockState newBlock = blockState2;
        MutableBoolean foundSeed = new MutableBoolean(false);
        Item seedItem = blockState.m_60734_().m_5456_();
        Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)serverLevel.m_7702_(pos), (Entity)entity, (ItemStack)itemStack).forEach(droppedStack -> {
            if (droppedStack.m_41720_() == seedItem && !foundSeed.getValue().booleanValue()) {
                droppedStack.m_41774_(1);
                foundSeed.setValue(true);
            }
            if (doDrops && !droppedStack.m_41619_()) {
                Block.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)droppedStack);
            }
        });
        serverLevel.m_46597_(pos, newBlock);
        return foundSeed.getValue();
    }

    public static void sendEventToPlayer(ServerPlayer player, int type, BlockPos pos, int data) {
        player.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(type, pos, data, false));
    }

    public static void applyEnchantmentHitEffects(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        int fireAspectLevel;
        EnchantmentHelper.m_44831_((ItemStack)itemStack).forEach((enchantment, level) -> enchantment.m_7677_(attacker, (Entity)target, level.intValue()));
        if (attacker != null) {
            for (ItemStack equipment : attacker.m_20158_()) {
                EnchantmentHelper.m_44831_((ItemStack)equipment).forEach((enchantment, level) -> enchantment.m_7677_(attacker, (Entity)target, level.intValue()));
            }
        }
        if ((fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)itemStack)) > 0) {
            target.m_20254_(fireAspectLevel * 4);
        }
    }

    public static float getModifiedEfficiency(Player player, ItemStack itemStack, float base, @Nullable BlockState blockState, @Nullable BlockPos pos) {
        float result = base;
        if (result > 1.0f) {
            int efficiencyLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)itemStack);
            result += (float)(efficiencyLevel * efficiencyLevel + 1);
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            result *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.m_21023_(MobEffects.f_19599_)) {
            switch (player.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0: {
                    result *= 0.3f;
                    break;
                }
                case 1: {
                    result *= 0.09f;
                    break;
                }
                case 2: {
                    result *= 0.0027f;
                    break;
                }
                default: {
                    result *= 8.1E-4f;
                }
            }
        }
        if (player.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            result /= 5.0f;
        }
        if (!player.m_20096_()) {
            result /= 5.0f;
        }
        if (blockState != null) {
            result = ForgeEventFactory.getBreakSpeed((Player)player, (BlockState)blockState, (float)result, (BlockPos)pos);
        }
        return result;
    }
}

