/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SchematicConversionMaps {
    private static final Object2IntOpenHashMap<String> OLD_BLOCK_NAME_TO_SHIFTED_BLOCK_ID = (Object2IntOpenHashMap)DataFixUtils.make((Object)new Object2IntOpenHashMap(), map -> map.defaultReturnValue(-1));
    private static final Int2ObjectOpenHashMap<String> ID_META_TO_UPDATED_NAME = new Int2ObjectOpenHashMap();
    private static final Object2IntOpenHashMap<BlockState> BLOCKSTATE_TO_ID_META = (Object2IntOpenHashMap)DataFixUtils.make((Object)new Object2IntOpenHashMap(), map -> map.defaultReturnValue(-1));
    private static final Int2ObjectOpenHashMap<BlockState> ID_META_TO_BLOCKSTATE = new Int2ObjectOpenHashMap();
    private static final HashMap<String, String> OLD_NAME_TO_NEW_NAME = new HashMap();
    private static final HashMap<String, String> NEW_NAME_TO_OLD_NAME = new HashMap();
    private static final HashMap<CompoundTag, CompoundTag> OLD_STATE_TO_NEW_STATE = new HashMap();
    private static final HashMap<CompoundTag, CompoundTag> NEW_STATE_TO_OLD_STATE = new HashMap();
    private static final ArrayList<ConversionData> CACHED_DATA = new ArrayList();
    private static boolean initialized;

    public static void addEntry(int idMeta, String newStateString, String ... oldStateStrings) {
        CACHED_DATA.add(new ConversionData(idMeta, newStateString, oldStateStrings));
    }

    public static void computeMaps() {
        if (initialized) {
            return;
        }
        SchematicConversionMaps.clearMaps();
        SchematicConversionMaps.addOverrides();
        for (ConversionData data : CACHED_DATA) {
            try {
                CompoundTag newStateTag;
                CompoundTag oldStateTag;
                if (data.oldStateStrings.length > 0 && (oldStateTag = SchematicConversionMaps.getStateTagFromString(data.oldStateStrings[0])) != null) {
                    String name = oldStateTag.m_128461_("Name");
                    OLD_BLOCK_NAME_TO_SHIFTED_BLOCK_ID.putIfAbsent((Object)name, data.idMeta & 0xFFF0);
                }
                if ((newStateTag = SchematicConversionMaps.getStateTagFromString(data.newStateString)) == null) continue;
                SchematicConversionMaps.addIdMetaToBlockState(data.idMeta, newStateTag, data.oldStateStrings);
            }
            catch (Exception e) {
                Litematica.logger.warn("addEntry(): Exception while adding blockstate conversion map entry for ID '{}' (fixed state: '{}')", (Object)data.idMeta, (Object)data.newStateString, (Object)e);
            }
        }
        initialized = true;
    }

    @Nullable
    public static BlockState get_1_13_2_StateForIdMeta(int idMeta) {
        return (BlockState)ID_META_TO_BLOCKSTATE.get(idMeta);
    }

    public static CompoundTag get_1_13_2_StateTagFor_1_12_Tag(CompoundTag oldStateTag) {
        CompoundTag tag = OLD_STATE_TO_NEW_STATE.get(oldStateTag);
        return tag != null ? tag : oldStateTag;
    }

    public static CompoundTag get_1_12_StateTagFor_1_13_2_Tag(CompoundTag newStateTag) {
        CompoundTag tag = NEW_STATE_TO_OLD_STATE.get(newStateTag);
        return tag != null ? tag : newStateTag;
    }

    public static int getOldNameToShiftedBlockId(String oldBlockname) {
        return OLD_BLOCK_NAME_TO_SHIFTED_BLOCK_ID.getInt((Object)oldBlockname);
    }

    private static void addOverrides() {
        BlockState air = Blocks.f_50016_.m_49966_();
        BLOCKSTATE_TO_ID_META.put((Object)air, 0);
        ID_META_TO_BLOCKSTATE.put(0, (Object)air);
        int idOldLog = 284;
        int idNewLog = 2604;
        ID_META_TO_BLOCKSTATE.put(idOldLog | 0, (Object)((BlockState)Blocks.f_50011_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y)));
        ID_META_TO_BLOCKSTATE.put(idOldLog | 1, (Object)((BlockState)Blocks.f_50012_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y)));
        ID_META_TO_BLOCKSTATE.put(idOldLog | 2, (Object)((BlockState)Blocks.f_50013_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y)));
        ID_META_TO_BLOCKSTATE.put(idOldLog | 3, (Object)((BlockState)Blocks.f_50014_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y)));
        ID_META_TO_BLOCKSTATE.put(idNewLog | 0, (Object)((BlockState)Blocks.f_50015_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y)));
        ID_META_TO_BLOCKSTATE.put(idNewLog | 1, (Object)((BlockState)Blocks.f_50043_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y)));
        ID_META_TO_UPDATED_NAME.put(1648, (Object)"minecraft:melon");
        ID_META_TO_UPDATED_NAME.put(2304, (Object)"minecraft:skeleton_skull");
        ID_META_TO_UPDATED_NAME.put(2305, (Object)"minecraft:skeleton_skull");
        ID_META_TO_UPDATED_NAME.put(2306, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(2307, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(2308, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(2309, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(2312, (Object)"minecraft:skeleton_skull");
        ID_META_TO_UPDATED_NAME.put(2313, (Object)"minecraft:skeleton_skull");
        ID_META_TO_UPDATED_NAME.put(2314, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(2315, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(2316, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(2317, (Object)"minecraft:skeleton_wall_skull");
        ID_META_TO_UPDATED_NAME.put(3664, (Object)"minecraft:shulker_box");
        ID_META_TO_UPDATED_NAME.put(3665, (Object)"minecraft:shulker_box");
        ID_META_TO_UPDATED_NAME.put(3666, (Object)"minecraft:shulker_box");
        ID_META_TO_UPDATED_NAME.put(3667, (Object)"minecraft:shulker_box");
        ID_META_TO_UPDATED_NAME.put(3668, (Object)"minecraft:shulker_box");
        ID_META_TO_UPDATED_NAME.put(3669, (Object)"minecraft:shulker_box");
    }

    private static void clearMaps() {
        OLD_BLOCK_NAME_TO_SHIFTED_BLOCK_ID.clear();
        ID_META_TO_UPDATED_NAME.clear();
        BLOCKSTATE_TO_ID_META.clear();
        ID_META_TO_BLOCKSTATE.clear();
        OLD_NAME_TO_NEW_NAME.clear();
        NEW_NAME_TO_OLD_NAME.clear();
        OLD_STATE_TO_NEW_STATE.clear();
        NEW_STATE_TO_OLD_STATE.clear();
    }

    private static void addIdMetaToBlockState(int idMeta, CompoundTag newStateTag, String ... oldStateStrings) {
        try {
            String newName = newStateTag.m_128461_("Name");
            String overriddenName = (String)ID_META_TO_UPDATED_NAME.get(idMeta);
            if (overriddenName != null) {
                newName = overriddenName;
                newStateTag.m_128359_("Name", newName);
            }
            HolderLookup.RegistryLookup lookup = BuiltInRegistries.f_256975_.m_255303_();
            BlockState state = NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)newStateTag);
            ID_META_TO_BLOCKSTATE.putIfAbsent(idMeta, (Object)state);
            BLOCKSTATE_TO_ID_META.putIfAbsent((Object)state, idMeta);
            if (oldStateStrings.length > 0) {
                CompoundTag oldStateTag = SchematicConversionMaps.getStateTagFromString(oldStateStrings[0]);
                String oldName = oldStateTag.m_128461_("Name");
                if (overriddenName == null) {
                    newName = SchematicConversionMaps.updateBlockName(newName);
                    newStateTag.m_128359_("Name", newName);
                }
                if (!oldName.equals(newName)) {
                    OLD_NAME_TO_NEW_NAME.putIfAbsent(oldName, newName);
                    NEW_NAME_TO_OLD_NAME.putIfAbsent(newName, oldName);
                }
                SchematicConversionMaps.addOldStateToNewState(newStateTag, oldStateStrings);
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("addIdMetaToBlockState(): Exception while adding blockstate conversion map entry for ID '{}'", (Object)idMeta, (Object)e);
        }
    }

    private static void addOldStateToNewState(CompoundTag newStateTagIn, String ... oldStateStrings) {
        try {
            String oldBlockName;
            String newBlockName;
            CompoundTag oldStateTag;
            if (oldStateStrings.length == 1) {
                CompoundTag oldStateTag2 = SchematicConversionMaps.getStateTagFromString(oldStateStrings[0]);
                if (oldStateTag2 != null) {
                    OLD_STATE_TO_NEW_STATE.putIfAbsent(oldStateTag2, newStateTagIn);
                    NEW_STATE_TO_OLD_STATE.putIfAbsent(newStateTagIn, oldStateTag2);
                }
            } else if (oldStateStrings.length > 1 && (oldStateTag = SchematicConversionMaps.getStateTagFromString(oldStateStrings[0])) != null && newStateTagIn.m_128431_().equals(oldStateTag.m_128431_()) && (newBlockName = OLD_NAME_TO_NEW_NAME.get(oldBlockName = oldStateTag.m_128461_("Name"))) != null && !newBlockName.equals(oldBlockName)) {
                for (String oldStateString : oldStateStrings) {
                    oldStateTag = SchematicConversionMaps.getStateTagFromString(oldStateString);
                    if (oldStateTag == null) continue;
                    CompoundTag newTag = oldStateTag.m_6426_();
                    newTag.m_128359_("Name", newBlockName);
                    OLD_STATE_TO_NEW_STATE.putIfAbsent(oldStateTag, newTag);
                    NEW_STATE_TO_OLD_STATE.putIfAbsent(newTag, oldStateTag);
                }
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("addOldStateToNewState(): Exception while adding new blockstate to old blockstate conversion map entry for '{}'", (Object)newStateTagIn, (Object)e);
        }
    }

    public static CompoundTag getStateTagFromString(String str) {
        try {
            return TagParser.m_129359_((String)str.replace('\'', '\"'));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String updateBlockName(String oldName) {
        StringTag tagStr = StringTag.m_129297_((String)oldName);
        return ((Tag)Minecraft.m_91087_().m_91295_().update(References.f_16787_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tagStr), 1139, LitematicaSchematic.MINECRAFT_DATA_VERSION).getValue()).m_7916_();
    }

    private static class ConversionData {
        private final int idMeta;
        private final String newStateString;
        private final String[] oldStateStrings;

        private ConversionData(int idMeta, String newStateString, String[] oldStateStrings) {
            this.idMeta = idMeta;
            this.newStateString = newStateString;
            this.oldStateStrings = oldStateStrings;
        }
    }
}

