/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.mixin.IMixinFenceGateBlock;
import fi.dy.masa.litematica.mixin.IMixinRedstoneWireBlock;
import fi.dy.masa.litematica.mixin.IMixinStairsBlock;
import fi.dy.masa.litematica.mixin.IMixinVineBlock;
import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.malilib.util.PositionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;

public class SchematicConversionFixers {
    private static final BooleanProperty[] HORIZONTAL_CONNECTING_BLOCK_PROPS = new BooleanProperty[]{null, null, CrossCollisionBlock.f_52309_, CrossCollisionBlock.f_52311_, CrossCollisionBlock.f_52312_, CrossCollisionBlock.f_52310_};
    private static final BlockState REDSTONE_WIRE_DOT = Blocks.f_50088_.m_49966_();
    private static final BlockState REDSTONE_WIRE_CROSS = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50088_.m_49966_().m_61124_((Property)RedStoneWireBlock.f_55496_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55497_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55498_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55499_, (Comparable)RedstoneSide.SIDE);
    public static final IStateFixer FIXER_BANNER = (reader, state, pos) -> {
        DyeColor colorFromData;
        DyeColor colorOrig;
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && (colorOrig = ((AbstractBannerBlock)state.m_60734_()).m_48674_()) != (colorFromData = DyeColor.m_41053_((int)(15 - tag.m_128451_("Base"))))) {
            Integer rotation = (Integer)state.m_61143_((Property)BannerBlock.f_49007_);
            switch (colorFromData) {
                case WHITE: {
                    state = Blocks.f_50414_.m_49966_();
                    break;
                }
                case ORANGE: {
                    state = Blocks.f_50415_.m_49966_();
                    break;
                }
                case MAGENTA: {
                    state = Blocks.f_50416_.m_49966_();
                    break;
                }
                case LIGHT_BLUE: {
                    state = Blocks.f_50417_.m_49966_();
                    break;
                }
                case YELLOW: {
                    state = Blocks.f_50418_.m_49966_();
                    break;
                }
                case LIME: {
                    state = Blocks.f_50419_.m_49966_();
                    break;
                }
                case PINK: {
                    state = Blocks.f_50420_.m_49966_();
                    break;
                }
                case GRAY: {
                    state = Blocks.f_50421_.m_49966_();
                    break;
                }
                case LIGHT_GRAY: {
                    state = Blocks.f_50422_.m_49966_();
                    break;
                }
                case CYAN: {
                    state = Blocks.f_50423_.m_49966_();
                    break;
                }
                case PURPLE: {
                    state = Blocks.f_50424_.m_49966_();
                    break;
                }
                case BLUE: {
                    state = Blocks.f_50425_.m_49966_();
                    break;
                }
                case BROWN: {
                    state = Blocks.f_50426_.m_49966_();
                    break;
                }
                case GREEN: {
                    state = Blocks.f_50427_.m_49966_();
                    break;
                }
                case RED: {
                    state = Blocks.f_50428_.m_49966_();
                    break;
                }
                case BLACK: {
                    state = Blocks.f_50429_.m_49966_();
                }
            }
            state = (BlockState)state.m_61124_((Property)BannerBlock.f_49007_, (Comparable)rotation);
        }
        return state;
    };
    public static final IStateFixer FIXER_BANNER_WALL = (reader, state, pos) -> {
        DyeColor colorFromData;
        DyeColor colorOrig;
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && (colorOrig = ((AbstractBannerBlock)state.m_60734_()).m_48674_()) != (colorFromData = DyeColor.m_41053_((int)(15 - tag.m_128451_("Base"))))) {
            Direction facing = (Direction)state.m_61143_((Property)WallBannerBlock.f_57916_);
            switch (colorFromData) {
                case WHITE: {
                    state = Blocks.f_50430_.m_49966_();
                    break;
                }
                case ORANGE: {
                    state = Blocks.f_50431_.m_49966_();
                    break;
                }
                case MAGENTA: {
                    state = Blocks.f_50432_.m_49966_();
                    break;
                }
                case LIGHT_BLUE: {
                    state = Blocks.f_50433_.m_49966_();
                    break;
                }
                case YELLOW: {
                    state = Blocks.f_50434_.m_49966_();
                    break;
                }
                case LIME: {
                    state = Blocks.f_50435_.m_49966_();
                    break;
                }
                case PINK: {
                    state = Blocks.f_50436_.m_49966_();
                    break;
                }
                case GRAY: {
                    state = Blocks.f_50437_.m_49966_();
                    break;
                }
                case LIGHT_GRAY: {
                    state = Blocks.f_50438_.m_49966_();
                    break;
                }
                case CYAN: {
                    state = Blocks.f_50439_.m_49966_();
                    break;
                }
                case PURPLE: {
                    state = Blocks.f_50388_.m_49966_();
                    break;
                }
                case BLUE: {
                    state = Blocks.f_50389_.m_49966_();
                    break;
                }
                case BROWN: {
                    state = Blocks.f_50390_.m_49966_();
                    break;
                }
                case GREEN: {
                    state = Blocks.f_50391_.m_49966_();
                    break;
                }
                case RED: {
                    state = Blocks.f_50392_.m_49966_();
                    break;
                }
                case BLACK: {
                    state = Blocks.f_50393_.m_49966_();
                }
            }
            state = (BlockState)state.m_61124_((Property)WallBannerBlock.f_57916_, (Comparable)facing);
        }
        return state;
    };
    public static final IStateFixer FIXER_BED = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.m_128425_("color", 3)) {
            int colorId = tag.m_128451_("color");
            Direction facing = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            BedPart part = (BedPart)state.m_61143_((Property)BedBlock.f_49440_);
            Boolean occupied = (Boolean)state.m_61143_((Property)BedBlock.f_49441_);
            switch (colorId) {
                case 0: {
                    state = Blocks.f_50066_.m_49966_();
                    break;
                }
                case 1: {
                    state = Blocks.f_50067_.m_49966_();
                    break;
                }
                case 2: {
                    state = Blocks.f_50068_.m_49966_();
                    break;
                }
                case 3: {
                    state = Blocks.f_50017_.m_49966_();
                    break;
                }
                case 4: {
                    state = Blocks.f_50018_.m_49966_();
                    break;
                }
                case 5: {
                    state = Blocks.f_50019_.m_49966_();
                    break;
                }
                case 6: {
                    state = Blocks.f_50020_.m_49966_();
                    break;
                }
                case 7: {
                    state = Blocks.f_50021_.m_49966_();
                    break;
                }
                case 8: {
                    state = Blocks.f_50022_.m_49966_();
                    break;
                }
                case 9: {
                    state = Blocks.f_50023_.m_49966_();
                    break;
                }
                case 10: {
                    state = Blocks.f_50024_.m_49966_();
                    break;
                }
                case 11: {
                    state = Blocks.f_50025_.m_49966_();
                    break;
                }
                case 12: {
                    state = Blocks.f_50026_.m_49966_();
                    break;
                }
                case 13: {
                    state = Blocks.f_50027_.m_49966_();
                    break;
                }
                case 14: {
                    state = Blocks.f_50028_.m_49966_();
                    break;
                }
                case 15: {
                    state = Blocks.f_50029_.m_49966_();
                    break;
                }
                default: {
                    return state;
                }
            }
            state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)BedBlock.f_54117_, (Comparable)facing)).m_61124_((Property)BedBlock.f_49440_, (Comparable)part)).m_61124_((Property)BedBlock.f_49441_, (Comparable)occupied);
        }
        return state;
    };
    public static final IStateFixer FIXER_CHRORUS_PLANT = (reader, state, pos) -> ((ChorusPlantBlock)state.m_60734_()).m_51710_((BlockGetter)reader, pos);
    public static final IStateFixer FIXER_DIRT_SNOWY = (reader, state, pos) -> {
        Block block = reader.m_8055_(pos.m_7494_()).m_60734_();
        return (BlockState)state.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(block == Blocks.f_50127_ || block == Blocks.f_50125_));
    };
    public static final IStateFixer FIXER_DOOR = (reader, state, pos) -> {
        if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            BlockState stateLower = reader.m_8055_(pos.m_7495_());
            if (stateLower.m_60734_() == state.m_60734_()) {
                state = (BlockState)state.m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)stateLower.m_61143_((Property)DoorBlock.f_52726_)));
                state = (BlockState)state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)stateLower.m_61143_((Property)DoorBlock.f_52727_)));
            }
        } else {
            BlockState stateUpper = reader.m_8055_(pos.m_7494_());
            if (stateUpper.m_60734_() == state.m_60734_()) {
                state = (BlockState)state.m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)stateUpper.m_61143_((Property)DoorBlock.f_52728_)));
                state = (BlockState)state.m_61124_((Property)DoorBlock.f_52729_, (Comparable)((Boolean)stateUpper.m_61143_((Property)DoorBlock.f_52729_)));
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_DOUBLE_PLANT = (reader, state, pos) -> {
        BlockState stateLower;
        if (state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER && (stateLower = reader.m_8055_(pos.m_7495_())).m_60734_() instanceof DoublePlantBlock) {
            state = (BlockState)stateLower.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
        }
        return state;
    };
    public static final IStateFixer FIXER_FENCE = (reader, state, pos) -> {
        FenceBlock fence = (FenceBlock)state.m_60734_();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.m_121945_(side);
            BlockState stateAdj = reader.m_8055_(posAdj);
            Direction sideOpposite = side.m_122424_();
            boolean flag = stateAdj.m_60783_((BlockGetter)reader, posAdj, sideOpposite);
            state = (BlockState)state.m_61124_((Property)HORIZONTAL_CONNECTING_BLOCK_PROPS[side.m_122411_()], (Comparable)Boolean.valueOf(fence.m_53329_(stateAdj, flag, sideOpposite)));
        }
        return state;
    };
    public static final IStateFixer FIXER_FENCE_GATE = (reader, state, pos) -> {
        FenceGateBlock gate = (FenceGateBlock)state.m_60734_();
        Direction facing = (Direction)state.m_61143_((Property)FenceGateBlock.f_54117_);
        boolean inWall = false;
        inWall = facing.m_122434_() == Direction.Axis.X ? ((IMixinFenceGateBlock)gate).invokeIsWall(reader.m_8055_(pos.m_121945_(Direction.NORTH))) || ((IMixinFenceGateBlock)gate).invokeIsWall(reader.m_8055_(pos.m_121945_(Direction.SOUTH))) : ((IMixinFenceGateBlock)gate).invokeIsWall(reader.m_8055_(pos.m_121945_(Direction.WEST))) || ((IMixinFenceGateBlock)gate).invokeIsWall(reader.m_8055_(pos.m_121945_(Direction.EAST)));
        return (BlockState)state.m_61124_((Property)FenceGateBlock.f_53343_, (Comparable)Boolean.valueOf(inWall));
    };
    public static final IStateFixer FIXER_FIRE = (reader, state, pos) -> BaseFireBlock.m_49245_((BlockGetter)reader, (BlockPos)pos);
    public static final IStateFixer FIXER_FLOWER_POT = (reader, state, pos) -> {
        String itemName;
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && (itemName = tag.m_128461_("Item")).length() > 0) {
            int meta = tag.m_128451_("Data");
            switch (itemName) {
                case "minecraft:sapling": {
                    if (meta == 0) {
                        return Blocks.f_50277_.m_49966_();
                    }
                    if (meta == 1) {
                        return Blocks.f_50278_.m_49966_();
                    }
                    if (meta == 2) {
                        return Blocks.f_50279_.m_49966_();
                    }
                    if (meta == 3) {
                        return Blocks.f_50280_.m_49966_();
                    }
                    if (meta == 4) {
                        return Blocks.f_50229_.m_49966_();
                    }
                    if (meta != 5) break;
                    return Blocks.f_50230_.m_49966_();
                }
                case "minecraft:tallgrass": {
                    if (meta == 0) {
                        return Blocks.f_50247_.m_49966_();
                    }
                    if (meta != 2) break;
                    return Blocks.f_50231_.m_49966_();
                }
                case "minecraft:red_flower": {
                    if (meta == 0) {
                        return Blocks.f_50233_.m_49966_();
                    }
                    if (meta == 1) {
                        return Blocks.f_50234_.m_49966_();
                    }
                    if (meta == 2) {
                        return Blocks.f_50235_.m_49966_();
                    }
                    if (meta == 3) {
                        return Blocks.f_50236_.m_49966_();
                    }
                    if (meta == 4) {
                        return Blocks.f_50237_.m_49966_();
                    }
                    if (meta == 5) {
                        return Blocks.f_50238_.m_49966_();
                    }
                    if (meta == 6) {
                        return Blocks.f_50239_.m_49966_();
                    }
                    if (meta == 7) {
                        return Blocks.f_50240_.m_49966_();
                    }
                    if (meta != 8) break;
                    return Blocks.f_50241_.m_49966_();
                }
                case "minecraft:yellow_flower": {
                    return Blocks.f_50232_.m_49966_();
                }
                case "minecraft:brown_mushroom": {
                    return Blocks.f_50246_.m_49966_();
                }
                case "minecraft:red_mushroom": {
                    return Blocks.f_50245_.m_49966_();
                }
                case "minecraft:deadbush": {
                    return Blocks.f_50247_.m_49966_();
                }
                case "minecraft:cactus": {
                    return Blocks.f_50248_.m_49966_();
                }
                default: {
                    return state;
                }
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_NOTE_BLOCK = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null) {
            state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)NoteBlock.f_55012_, (Comparable)Boolean.valueOf(tag.m_128471_("powered")))).m_61124_((Property)NoteBlock.f_55013_, (Comparable)Integer.valueOf(Mth.m_14045_((int)tag.m_128445_("note"), (int)0, (int)24)))).m_61124_((Property)NoteBlock.f_55011_, (Comparable)reader.m_8055_(pos.m_7495_()).m_280603_());
        }
        return state;
    };
    public static final IStateFixer FIXER_PANE = (reader, state, pos) -> {
        IronBarsBlock pane = (IronBarsBlock)state.m_60734_();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.m_121945_(side);
            BlockState stateAdj = reader.m_8055_(posAdj);
            Direction sideOpposite = side.m_122424_();
            boolean flag = stateAdj.m_60783_((BlockGetter)reader, posAdj, sideOpposite);
            state = (BlockState)state.m_61124_((Property)HORIZONTAL_CONNECTING_BLOCK_PROPS[side.m_122411_()], (Comparable)Boolean.valueOf(pane.m_54217_(stateAdj, flag)));
        }
        return state;
    };
    public static final IStateFixer FIXER_REDSTONE_REPEATER = (reader, state, pos) -> (BlockState)state.m_61124_((Property)RepeaterBlock.f_55797_, (Comparable)Boolean.valueOf(SchematicConversionFixers.getIsRepeaterPoweredOnSide(reader, pos, state)));
    public static final IStateFixer FIXER_REDSTONE_WIRE = (reader, state, pos) -> {
        RedStoneWireBlock wire = (RedStoneWireBlock)state.m_60734_();
        if ((state = ((IMixinRedstoneWireBlock)wire).litematicaGetPlacementState(reader, state, pos)).m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(0)) == REDSTONE_WIRE_DOT) {
            state = (BlockState)REDSTONE_WIRE_CROSS.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)((Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_)));
        }
        return state;
    };
    public static final IStateFixer FIXER_SIGN = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.m_128425_("Text1", 8)) {
            ListTag textList = new ListTag();
            textList.add((Object)tag.m_128423_("Text1"));
            textList.add((Object)tag.m_128423_("Text2"));
            textList.add((Object)tag.m_128423_("Text3"));
            textList.add((Object)tag.m_128423_("Text4"));
            CompoundTag frontTextTag = new CompoundTag();
            frontTextTag.m_128365_("messages", (Tag)textList);
            frontTextTag.m_128359_("color", tag.m_128461_("Color"));
            frontTextTag.m_128344_("has_glowing_text", tag.m_128445_("GlowingText"));
            tag.m_128365_("front_text", (Tag)frontTextTag);
            tag.m_128473_("Color");
            tag.m_128473_("GlowingText");
            tag.m_128473_("Text1");
            tag.m_128473_("Text2");
            tag.m_128473_("Text3");
            tag.m_128473_("Text4");
        }
        return state;
    };
    public static final IStateFixer FIXER_SKULL = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null) {
            int id = Mth.m_14045_((int)tag.m_128445_("SkullType"), (int)0, (int)5);
            if (id == 2) {
                id = 3;
            } else if (id == 3) {
                id = 2;
            }
            SkullBlock.Type typeOrig = ((AbstractSkullBlock)state.m_60734_()).m_48754_();
            SkullBlock.Types typeFromData = SkullBlock.Types.values()[id];
            if (typeOrig != typeFromData) {
                if (typeFromData == SkullBlock.Types.SKELETON) {
                    state = Blocks.f_50310_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.WITHER_SKELETON) {
                    state = Blocks.f_50312_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.PLAYER) {
                    state = Blocks.f_50316_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.ZOMBIE) {
                    state = Blocks.f_50314_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.CREEPER) {
                    state = Blocks.f_50318_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.DRAGON) {
                    state = Blocks.f_50320_.m_49966_();
                }
            }
            state = (BlockState)state.m_61124_((Property)BannerBlock.f_49007_, (Comparable)Integer.valueOf(Mth.m_14045_((int)tag.m_128445_("Rot"), (int)0, (int)15)));
        }
        return state;
    };
    public static final IStateFixer FIXER_SKULL_WALL = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null) {
            int id = Mth.m_14045_((int)tag.m_128445_("SkullType"), (int)0, (int)5);
            if (id == 2) {
                id = 3;
            } else if (id == 3) {
                id = 2;
            }
            SkullBlock.Type typeOrig = ((AbstractSkullBlock)state.m_60734_()).m_48754_();
            SkullBlock.Types typeFromData = SkullBlock.Types.values()[id];
            if (typeOrig != typeFromData) {
                Direction facing = (Direction)state.m_61143_((Property)WallSkullBlock.f_58097_);
                if (typeFromData == SkullBlock.Types.SKELETON) {
                    state = Blocks.f_50311_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.WITHER_SKELETON) {
                    state = Blocks.f_50313_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.PLAYER) {
                    state = Blocks.f_50317_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.ZOMBIE) {
                    state = Blocks.f_50315_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.CREEPER) {
                    state = Blocks.f_50319_.m_49966_();
                } else if (typeFromData == SkullBlock.Types.DRAGON) {
                    state = Blocks.f_50321_.m_49966_();
                }
                state = (BlockState)state.m_61124_((Property)WallSkullBlock.f_58097_, (Comparable)facing);
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_STAIRS = (reader, state, pos) -> (BlockState)state.m_61124_((Property)StairBlock.f_56843_, (Comparable)IMixinStairsBlock.invokeGetStairShape(state, reader, pos));
    public static final IStateFixer FIXER_STEM = (reader, state, pos) -> {
        StemBlock stem = (StemBlock)state.m_60734_();
        StemGrownBlock crop = stem.m_57056_();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.m_121945_(side);
            BlockState stateAdj = reader.m_8055_(posAdj);
            Block blockAdj = stateAdj.m_60734_();
            if (blockAdj != crop && (stem != Blocks.f_50189_ || blockAdj != Blocks.f_50143_)) continue;
            return (BlockState)crop.m_7810_().m_49966_().m_61124_((Property)AttachedStemBlock.f_48830_, (Comparable)side);
        }
        return state;
    };
    public static final IStateFixer FIXER_TRIPWIRE = (reader, state, pos) -> {
        TripWireBlock wire = (TripWireBlock)state.m_60734_();
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)TripWireBlock.f_57593_, (Comparable)Boolean.valueOf(wire.m_57641_(reader.m_8055_(pos.m_122012_()), Direction.NORTH)))).m_61124_((Property)TripWireBlock.f_57595_, (Comparable)Boolean.valueOf(wire.m_57641_(reader.m_8055_(pos.m_122019_()), Direction.SOUTH)))).m_61124_((Property)TripWireBlock.f_57596_, (Comparable)Boolean.valueOf(wire.m_57641_(reader.m_8055_(pos.m_122024_()), Direction.WEST)))).m_61124_((Property)TripWireBlock.f_57594_, (Comparable)Boolean.valueOf(wire.m_57641_(reader.m_8055_(pos.m_122029_()), Direction.EAST)));
    };
    public static final IStateFixer FIXER_VINE = (reader, state, pos) -> {
        VineBlock vine = (VineBlock)state.m_60734_();
        return (BlockState)state.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(((IMixinVineBlock)vine).invokeShouldConnectUp(reader, pos.m_7494_(), Direction.UP)));
    };

    private static boolean getIsRepeaterPoweredOnSide(BlockGetter reader, BlockPos pos, BlockState stateRepeater) {
        Direction facing = (Direction)stateRepeater.m_61143_((Property)RepeaterBlock.f_54117_);
        Direction sideLeft = facing.m_122428_();
        Direction sideRight = facing.m_122427_();
        return SchematicConversionFixers.getRepeaterPowerOnSide(reader, pos.m_121945_(sideLeft), sideLeft) > 0 || SchematicConversionFixers.getRepeaterPowerOnSide(reader, pos.m_121945_(sideRight), sideRight) > 0;
    }

    private static int getRepeaterPowerOnSide(BlockGetter reader, BlockPos pos, Direction side) {
        BlockState state = reader.m_8055_(pos);
        Block block = state.m_60734_();
        if (DiodeBlock.m_52586_((BlockState)state)) {
            if (block == Blocks.f_50330_) {
                return 15;
            }
            return block == Blocks.f_50088_ ? ((Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() : state.m_60775_(reader, pos, side);
        }
        return 0;
    }

    public static interface IStateFixer {
        public BlockState fixState(IBlockReaderWithData var1, BlockState var2, BlockPos var3);
    }
}

