/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.Queues;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkMultiPhase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerMode;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TaskFillArea
extends TaskProcessChunkMultiPhase {
    protected final Queue<String> queuedCommands = Queues.newArrayDeque();
    protected final BlockState fillState;
    @Nullable
    protected final BlockState replaceState;
    protected final String fillCommand;
    protected final String blockString;
    protected final int maxBoxVolume;
    protected final boolean removeEntities;

    public TaskFillArea(List<Box> boxes, BlockState fillState, @Nullable BlockState replaceState, boolean removeEntities) {
        this(boxes, fillState, replaceState, removeEntities, "litematica.gui.label.task_name.fill");
    }

    protected TaskFillArea(List<Box> boxes, BlockState fillState, @Nullable BlockState replaceState, boolean removeEntities, String nameOnHud) {
        super(nameOnHud);
        this.fillState = fillState;
        this.replaceState = replaceState;
        this.removeEntities = removeEntities;
        this.maxBoxVolume = Configs.Generic.COMMAND_FILL_MAX_VOLUME.getIntegerValue();
        this.maxCommandsPerTick = Configs.Generic.COMMAND_LIMIT.getIntegerValue();
        this.fillCommand = Configs.Generic.COMMAND_NAME_FILL.getStringValue();
        Object blockString = BlockStateParser.m_116769_((BlockState)fillState);
        if (replaceState != null) {
            blockString = (String)blockString + " replace " + BlockStateParser.m_116769_((BlockState)replaceState);
        }
        this.blockString = blockString;
        this.processBoxBlocksTask = this::sendQueuedCommands;
        if (Configs.Generic.COMMAND_FILL_NO_CHUNK_CLAMP.getBooleanValue()) {
            this.addNonChunkClampedBoxes(boxes);
        } else {
            this.addPerChunkBoxes(boxes);
        }
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.blockString != null;
    }

    @Override
    protected boolean canProcessChunk(ChunkPos pos) {
        return this.areSurroundingChunksLoaded(pos, this.clientWorld, 0);
    }

    @Override
    public void init() {
        super.init();
        if (this.useWorldEdit && this.isInWorld()) {
            this.sendCommand("/perf neighbors off");
        }
    }

    @Override
    public boolean execute() {
        return this.executeMultiPhase();
    }

    @Override
    protected void onNextChunkFetched(ChunkPos pos) {
        if (this.isClientWorld) {
            this.queueCommandsForBoxesInChunk(pos);
        } else {
            this.directFillBoxesInChunk(pos);
        }
    }

    protected void addNonChunkClampedBoxes(Collection<Box> allBoxes) {
        this.addNonChunkClampedBoxes(allBoxes, new LayerRange(null));
    }

    protected void addNonChunkClampedBoxes(Collection<Box> allBoxes, LayerRange range) {
        this.boxesInChunks.clear();
        this.pendingChunks.clear();
        if (range.getLayerMode() == LayerMode.ALL) {
            TaskFillArea.addBoxes(allBoxes, this::clampToWorldHeightAndAddBox);
        } else {
            TaskFillArea.getLayerRangeClampedBoxes(allBoxes, range, this::clampToWorldHeightAndAddBox);
        }
        this.pendingChunks.addAll(this.boxesInChunks.keySet());
        this.sortChunkList();
    }

    protected static void addBoxes(Collection<Box> boxes, BiConsumer<ChunkPos, IntBoundingBox> consumer) {
        for (Box box : boxes) {
            int boxMinX = Math.min(box.getPos1().m_123341_(), box.getPos2().m_123341_());
            int boxMinY = Math.min(box.getPos1().m_123342_(), box.getPos2().m_123342_());
            int boxMinZ = Math.min(box.getPos1().m_123343_(), box.getPos2().m_123343_());
            int boxMaxX = Math.max(box.getPos1().m_123341_(), box.getPos2().m_123341_());
            int boxMaxY = Math.max(box.getPos1().m_123342_(), box.getPos2().m_123342_());
            int boxMaxZ = Math.max(box.getPos1().m_123343_(), box.getPos2().m_123343_());
            consumer.accept(new ChunkPos(boxMinX >> 4, boxMinZ >> 4), new IntBoundingBox(boxMinX, boxMinY, boxMinZ, boxMaxX, boxMaxY, boxMaxZ));
        }
    }

    protected static void getLayerRangeClampedBoxes(Collection<Box> boxes, LayerRange range, BiConsumer<ChunkPos, IntBoundingBox> consumer) {
        block5: for (Box box : boxes) {
            int rangeMin = range.getLayerMin();
            int rangeMax = range.getLayerMax();
            int boxMinX = Math.min(box.getPos1().m_123341_(), box.getPos2().m_123341_());
            int boxMinY = Math.min(box.getPos1().m_123342_(), box.getPos2().m_123342_());
            int boxMinZ = Math.min(box.getPos1().m_123343_(), box.getPos2().m_123343_());
            int boxMaxX = Math.max(box.getPos1().m_123341_(), box.getPos2().m_123341_());
            int boxMaxY = Math.max(box.getPos1().m_123342_(), box.getPos2().m_123342_());
            int boxMaxZ = Math.max(box.getPos1().m_123343_(), box.getPos2().m_123343_());
            switch (range.getAxis()) {
                case X: {
                    if (rangeMax < boxMinX || rangeMin > boxMaxX) continue block5;
                    boxMinX = Math.max(boxMinX, rangeMin);
                    boxMaxX = Math.min(boxMaxX, rangeMax);
                    break;
                }
                case Y: {
                    if (rangeMax < boxMinY || rangeMin > boxMaxY) continue block5;
                    boxMinY = Math.max(boxMinY, rangeMin);
                    boxMaxY = Math.min(boxMaxY, rangeMax);
                    break;
                }
                case Z: {
                    if (rangeMax < boxMinZ || rangeMin > boxMaxZ) continue block5;
                    boxMinZ = Math.max(boxMinZ, rangeMin);
                    boxMaxZ = Math.min(boxMaxZ, rangeMax);
                }
            }
            consumer.accept(new ChunkPos(boxMinX >> 4, boxMinZ >> 4), new IntBoundingBox(boxMinX, boxMinY, boxMinZ, boxMaxX, boxMaxY, boxMaxZ));
        }
    }

    protected void queueCommandsForBoxesInChunk(ChunkPos pos) {
        for (IntBoundingBox box : this.getBoxesInChunk(pos)) {
            this.queueFillCommandsForBox(box, this.removeEntities);
        }
        this.phase = TaskProcessChunkMultiPhase.TaskPhase.PROCESS_BOX_BLOCKS;
    }

    protected void directFillBoxesInChunk(ChunkPos pos) {
        for (IntBoundingBox box : this.getBoxesInChunk(pos)) {
            this.fillBoxDirect(box, this.removeEntities);
        }
        this.finishProcessingChunk(pos);
    }

    protected void sendQueuedCommands() {
        while (this.sentCommandsThisTick < this.maxCommandsPerTick && !this.queuedCommands.isEmpty()) {
            this.sendCommand(this.queuedCommands.poll());
        }
        if (this.queuedCommands.isEmpty()) {
            this.finishProcessingChunk(this.currentChunkPos);
        }
    }

    protected void fillBoxDirect(IntBoundingBox box, boolean removeEntities) {
        if (removeEntities) {
            AABB aabb = new AABB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
            List entities = this.world.m_6249_((Entity)this.mc.f_91074_, aabb, EntityUtils.NOT_PLAYER);
            for (Entity entity : entities) {
                if (entity instanceof Player) continue;
                entity.m_146870_();
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, true);
        BlockState barrier = Blocks.f_50375_.m_49966_();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (int z = box.minZ; z <= box.maxZ; ++z) {
            for (int x = box.minX; x <= box.maxX; ++x) {
                for (int y = box.maxY; y >= box.minY; --y) {
                    posMutable.m_122178_(x, y, z);
                    BlockState oldState = this.world.m_8055_((BlockPos)posMutable);
                    if ((this.replaceState != null || oldState == this.fillState) && oldState != this.replaceState) continue;
                    BlockEntity te = this.world.m_7702_((BlockPos)posMutable);
                    if (te instanceof Container) {
                        ((Container)te).m_6211_();
                        this.world.m_7731_((BlockPos)posMutable, barrier, 50);
                    }
                    this.world.m_7731_((BlockPos)posMutable, this.fillState, 50);
                }
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, false);
    }

    protected void queueFillCommandsForBox(IntBoundingBox box, boolean removeEntities) {
        int totalVolume;
        AABB aabb;
        if (removeEntities && this.world.m_6249_((Entity)this.mc.f_91074_, aabb = new AABB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1)), EntityUtils.NOT_PLAYER).size() > 0) {
            String killCmd = String.format("kill @e[type=!player,x=%d,y=%d,z=%d,dx=%d,dy=%d,dz=%d]", box.minX, box.minY, box.minZ, box.maxX - box.minX + 1, box.maxY - box.minY + 1, box.maxZ - box.minZ + 1);
            this.queuedCommands.offer(killCmd);
        }
        if ((totalVolume = (box.maxX - box.minX + 1) * (box.maxY - box.minY + 1) * (box.maxZ - box.minZ + 1)) <= this.maxBoxVolume || this.useWorldEdit) {
            this.queueFillCommandForBox(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
        } else {
            int singleLayerVolume = (box.maxX - box.minX + 1) * (box.maxZ - box.minZ + 1);
            int singleBoxHeight = this.maxBoxVolume / singleLayerVolume;
            if (singleBoxHeight < 1) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Error: Calculated single box height was less than 1 block", (Object[])new Object[0]);
                return;
            }
            for (int y = box.minY; y <= box.maxY; y += singleBoxHeight) {
                int maxY = Math.min(y + singleBoxHeight - 1, box.maxY);
                this.queueFillCommandForBox(box.minX, y, box.minZ, box.maxX, maxY, box.maxZ);
            }
        }
    }

    protected void queueFillCommandForBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.useWorldEdit) {
            this.queuedCommands.offer(String.format("/pos1 %d,%d,%d", minX, minY, minZ));
            this.queuedCommands.offer(String.format("/pos2 %d,%d,%d", maxX, maxY, maxZ));
            this.queuedCommands.offer("/set " + this.blockString);
        } else {
            String fillCmd = String.format("%s %d %d %d %d %d %d %s", this.fillCommand, minX, minY, minZ, maxX, maxY, maxZ, this.blockString);
            this.queuedCommands.offer(fillCmd);
        }
    }

    @Override
    protected void onStop() {
        this.printCompletionMessage();
        this.sendTaskEndCommands();
        DataManager.removeChatListener(this.gameRuleListener);
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.onStop();
    }

    protected void printCompletionMessage() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.area_filled", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.area_fill_fail", (Object[])new Object[0]);
        }
    }
}

