/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui;

import fi.dy.masa.litematica.gui.GuiSchematicBrowserBase;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicBrowser;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetCheckBox;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;

public abstract class GuiSchematicSaveBase
extends GuiSchematicBrowserBase
implements ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> {
    protected GuiTextFieldGeneric textField;
    protected WidgetCheckBox checkboxIgnoreEntities;
    protected WidgetCheckBox checkboxVisibleOnly;
    protected final WidgetCheckBox checkboxSaveFromSchematicWorld;
    protected String lastText = "";
    protected String defaultText = "";
    @Nullable
    protected final LitematicaSchematic schematic;

    public GuiSchematicSaveBase(@Nullable LitematicaSchematic schematic) {
        super(10, 70);
        this.schematic = schematic;
        this.textField = new GuiTextFieldGeneric(10, 32, 160, 20, this.textRenderer);
        this.textField.m_94199_(256);
        this.textField.m_93692_(true);
        this.checkboxSaveFromSchematicWorld = new WidgetCheckBox(0, 0, (IGuiIcon)Icons.CHECKBOX_UNSELECTED, (IGuiIcon)Icons.CHECKBOX_SELECTED, "Save from schematic world", "If enabled, then the schematic is created by saving the\ncontents of the selection from the schematic world\ninstead of the normal vanilla world.\nThis allows you to combine or trim schematics without having\nto paste them to a temporary creative world.");
    }

    @Override
    public int getBrowserHeight() {
        return this.f_96544_ - 80;
    }

    public void initGui() {
        super.initGui();
        boolean focused = this.textField.m_93696_();
        String text = this.textField.m_94155_();
        int pos = this.textField.getCursorPosition();
        this.textField = new GuiTextFieldGeneric(10, 32, this.f_96543_ - 196, 20, this.textRenderer);
        this.textField.m_94144_(text);
        this.textField.setCursorPosition(pos);
        this.textField.m_93692_(focused);
        WidgetFileBrowserBase.DirectoryEntry entry = (WidgetFileBrowserBase.DirectoryEntry)((WidgetSchematicBrowser)this.getListWidget()).getLastSelectedEntry();
        if (this.lastText.isEmpty()) {
            if (entry != null && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.INVALID) {
                this.setTextFieldText(FileUtils.getNameWithoutExtension((String)entry.getName()));
            } else if (this.schematic != null) {
                this.setTextFieldText(this.schematic.getMetadata().getName());
            } else {
                this.setTextFieldText(this.defaultText);
            }
        }
        int x = this.textField.m_252754_() + this.textField.m_5711_() + 12;
        int y = 32;
        String str = StringUtils.translate((String)"litematica.gui.label.schematic_save.checkbox.ignore_entities", (Object[])new Object[0]);
        this.checkboxIgnoreEntities = new WidgetCheckBox(x, y + 24, (IGuiIcon)Icons.CHECKBOX_UNSELECTED, (IGuiIcon)Icons.CHECKBOX_SELECTED, str);
        this.addWidget((WidgetBase)this.checkboxIgnoreEntities);
        this.checkboxVisibleOnly = new WidgetCheckBox(12, y + 24, (IGuiIcon)Icons.CHECKBOX_UNSELECTED, (IGuiIcon)Icons.CHECKBOX_SELECTED, "Visible blocks only [experimental quick hax]");
        this.addWidget((WidgetBase)this.checkboxVisibleOnly);
        this.checkboxSaveFromSchematicWorld.setPosition(20 + this.checkboxVisibleOnly.getWidth(), y + 24);
        this.addWidget((WidgetBase)this.checkboxSaveFromSchematicWorld);
        x = this.createButton(x, y, ButtonType.SAVE);
    }

    protected void setTextFieldText(String text) {
        this.lastText = text;
        this.textField.m_94144_(text);
        this.textField.setCursorPositionEnd();
    }

    protected String getTextFieldText() {
        return this.textField.m_94155_();
    }

    protected abstract IButtonActionListener createButtonListener(ButtonType var1);

    private int createButton(int x, int y, ButtonType type) {
        String label = StringUtils.translate((String)type.getLabelKey(), (Object[])new Object[0]);
        int width = this.getStringWidth(label) + 10;
        ButtonGeneric button = type == ButtonType.SAVE ? new ButtonGeneric(x, y, width, 20, label, new String[]{"litematica.gui.label.schematic_save.hoverinfo.hold_shift_to_overwrite"}) : new ButtonGeneric(x, y, width, 20, label, new String[0]);
        this.addButton((ButtonBase)button, this.createButtonListener(type));
        return x + width + 4;
    }

    public void setString(String string) {
        this.setNextMessageType(Message.MessageType.ERROR);
        super.setString(string);
    }

    public void drawContents(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        super.drawContents(drawContext, mouseX, mouseY, partialTicks);
        this.textField.m_88315_(drawContext, mouseX, mouseY, partialTicks);
    }

    public void onSelectionChange(@Nullable WidgetFileBrowserBase.DirectoryEntry entry) {
        if (entry != null && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.INVALID) {
            this.setTextFieldText(FileUtils.getNameWithoutExtension((String)entry.getName()));
        }
    }

    @Override
    protected ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> getSelectionListener() {
        return this;
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.textField.m_6375_((double)mouseX, (double)mouseY, mouseButton)) {
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (this.textField.m_7933_(keyCode, scanCode, modifiers)) {
            ((WidgetSchematicBrowser)this.getListWidget()).clearSelection();
            return true;
        }
        if (keyCode == 258) {
            this.textField.m_93692_(!this.textField.m_93696_());
            return true;
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        if (this.textField.m_5534_(charIn, modifiers)) {
            ((WidgetSchematicBrowser)this.getListWidget()).clearSelection();
            return true;
        }
        return super.onCharTyped(charIn, modifiers);
    }

    public static enum ButtonType {
        SAVE("litematica.gui.button.save_schematic");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getLabelKey() {
            return this.labelKey;
        }
    }
}

