/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSlotPacket {
    private final byte selectType;
    private final List<?> slotsData;
    public static final byte UNSORTABLES = 0;
    public static final byte MEMORY = 1;

    public ServerboundSlotPacket(byte selectType, List<?> slotsData) {
        this.selectType = selectType;
        this.slotsData = slotsData;
    }

    public static ServerboundSlotPacket decode(FriendlyByteBuf buffer) {
        byte selectType = buffer.readByte();
        List<Object> slotsData = new ArrayList();
        if (selectType == 0) {
            slotsData = buffer.m_178338_().intStream().boxed().collect(Collectors.toList());
        }
        if (selectType == 1) {
            slotsData = NbtHelper.deserializeMemorySlots(buffer.m_130260_());
        }
        return new ServerboundSlotPacket(selectType, slotsData);
    }

    public static void encode(ServerboundSlotPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.selectType);
        List<Pair<Integer, Pair<ItemStack, Boolean>>> slotsData = message.slotsData;
        if (message.selectType == 0) {
            List<Pair<Integer, Pair<ItemStack, Boolean>>> unsortables = slotsData;
            buffer.m_178345_((IntList)new IntArrayList(unsortables.stream().mapToInt(Integer::intValue).toArray()));
        }
        if (message.selectType == 1) {
            buffer.m_130079_(NbtHelper.serializeMemorySlots(slotsData));
        }
    }

    public static void handle(ServerboundSlotPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt2512$temp = serverPlayer.f_36096_;
                if (patt2512$temp instanceof BackpackSettingsMenu) {
                    BackpackSettingsMenu menu = (BackpackSettingsMenu)patt2512$temp;
                    String syncKey = null;
                    if (message.selectType == 0) {
                        menu.getWrapper().setUnsortableSlots(message.slotsData);
                        syncKey = "UnsortableSlots";
                    }
                    if (message.selectType == 1) {
                        menu.getWrapper().setMemorySlots(message.slotsData);
                        syncKey = "MemorySlots";
                    }
                    if (syncKey != null) {
                        menu.getWrapper().sendDataToClients(syncKey);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

