/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class TanksUpgradeItem
extends UpgradeItem {
    public TanksUpgradeItem(Item.Properties pProperties) {
        super(pProperties, "tanks_upgrade");
    }

    public boolean m_245993_(FeatureFlagSet enabledFeatures) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.enableTanksUpgrade.get() != false && super.m_245993_(enabledFeatures);
    }

    public static boolean canBePutInBackpack(int backpackFluidStorageSize, ItemStack tanksUpgrade) {
        int[] fluidTanks = new int[]{0, 0};
        if (NbtHelper.has(tanksUpgrade, "Fluids")) {
            Fluids fluidTanks2 = (Fluids)NbtHelper.get(tanksUpgrade, "Fluids");
            fluidTanks[0] = fluidTanks2.leftFluidStack().getAmount();
            fluidTanks[1] = fluidTanks2.rightFluidStack().getAmount();
        }
        return backpackFluidStorageSize >= fluidTanks[0] && backpackFluidStorageSize >= fluidTanks[1];
    }

    public static FluidStack getLeftFluidStack(ItemStack tanksUpgrade) {
        if (NbtHelper.has(tanksUpgrade, "Fluids")) {
            Fluids fluidTanks2 = (Fluids)NbtHelper.get(tanksUpgrade, "Fluids");
            return fluidTanks2.leftFluidStack();
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack getRightFluidStack(ItemStack tanksUpgrade) {
        if (NbtHelper.has(tanksUpgrade, "Fluids")) {
            Fluids fluidTanks2 = (Fluids)NbtHelper.get(tanksUpgrade, "Fluids");
            return fluidTanks2.rightFluidStack();
        }
        return FluidStack.EMPTY;
    }

    public static RenderInfo writeToRenderData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("LeftTank", (Tag)new CompoundTag());
        tag.m_128365_("RightTank", (Tag)new CompoundTag());
        return new RenderInfo(tag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
        if (NbtHelper.has(stack, "Fluids")) {
            Fluids fluidTanks = (Fluids)NbtHelper.get(stack, "Fluids");
            FluidStack leftFluidStack = fluidTanks.leftFluidStack();
            FluidStack rightFluidStack = fluidTanks.rightFluidStack();
            if (!leftFluidStack.isEmpty()) {
                tooltipComponents.add((Component)Component.m_237113_((String)(leftFluidStack.getFluid().getFluidType().getDescription().getString() + ": " + leftFluidStack.getAmount() + "mB")).m_130940_(ChatFormatting.BLUE));
            }
            if (!rightFluidStack.isEmpty()) {
                tooltipComponents.add((Component)Component.m_237113_((String)(rightFluidStack.getFluid().getFluidType().getDescription().getString() + ": " + rightFluidStack.getAmount() + "mB")).m_130940_(ChatFormatting.BLUE));
            }
        }
    }
}

