/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class VoidFilterSettings {
    public static final int ALLOW_MODE = 0;
    public static final int OBJECT_CATEGORY = 1;
    public static final int IGNORE_MODE = 2;
    public static final int ALLOW = 0;
    public static final int BLOCK = 1;
    public static final int MATCH_CONTENTS = 2;
    public static final int ITEM = 0;
    public static final int MOD_ID = 1;
    public static final int IGNORE_COMPONENTS = 0;
    public static final int MATCH_COMPONENTS = 1;
    private List<ItemStack> filterItems;
    private List<Integer> filterSettings;
    private ItemStackHandler storage;

    public VoidFilterSettings(ItemStackHandler storage, List<ItemStack> items, List<Integer> filterSettings) {
        this.filterItems = items;
        this.filterSettings = filterSettings;
        this.storage = storage;
    }

    public List<Integer> getSettings() {
        return this.filterSettings;
    }

    public boolean canVoid(ItemStack stack) {
        if (this.filterSettings.get(0) == 0) {
            return this.filterItems.stream().anyMatch(filterStack -> this.compare((ItemStack)filterStack, stack));
        }
        if (this.filterSettings.get(0) == 1) {
            return this.filterItems.stream().noneMatch(filterStack -> this.compare((ItemStack)filterStack, stack));
        }
        if (this.filterSettings.get(0) == 2) {
            return this.streamStorageContents().anyMatch(filterStack -> this.compare((ItemStack)filterStack, stack));
        }
        return false;
    }

    public boolean compare(ItemStack stack, ItemStack other) {
        if (this.filterSettings.get(1) == 0) {
            return this.compareItemStack(stack, other);
        }
        return this.compareModId(stack, other);
    }

    public boolean compareItemStack(ItemStack stack, ItemStack other) {
        if (this.filterSettings.get(2) == 0) {
            return ItemStack.m_41656_((ItemStack)stack, (ItemStack)other);
        }
        return ItemStack.m_150942_((ItemStack)stack, (ItemStack)other);
    }

    public boolean compareModId(ItemStack stack, ItemStack other) {
        return stack.m_41720_().getCreatorModId(stack).equals(other.m_41720_().getCreatorModId(other));
    }

    public void updateFilter(List<ItemStack> items) {
        this.filterItems = items.stream().limit(((Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get()).intValue()).filter(stack -> !stack.m_41619_()).toList();
    }

    public void updateSettings(List<Integer> settings) {
        this.filterSettings = settings;
    }

    public Stream<ItemStack> streamStorageContents() {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            if (this.storage.getStackInSlot(i).m_41619_()) continue;
            arrayList.add(this.storage.getStackInSlot(i));
        }
        return arrayList.stream();
    }
}

