/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.IBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.UnsortablesWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.VisibilityWidget;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackSettingsScreen
extends AbstractContainerScreen<BackpackSettingsMenu>
implements MenuAccess<BackpackSettingsMenu>,
IBackpackScreen {
    public static final int TOP_BAR_OFFSET = 7;
    public int slotCount;
    boolean wider = false;
    public List<IButton> buttons = new ArrayList<IButton>();
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    private final BackpackWrapper wrapper;
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<Integer>();
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
    public boolean visibility;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)backpackSettingsMenu, inventory, component);
        this.wrapper = backpackSettingsMenu.getWrapper();
        this.recalculate();
        this.lastUnsortableSlots = new ArrayList<Integer>(this.wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<Integer>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.lastMemorySlots);
        this.visibility = NbtHelper.getOrDefault(this.wrapper.getBackpackStack(), "IsVisible", true);
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public Player getScreenPlayer() {
        return ((BackpackSettingsMenu)this.m_6262_()).player;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initButtons();
        this.initWidgets();
    }

    protected void renderSlotContents(GuiGraphics guiGraphics, ItemStack itemstack, Slot slot, @Nullable String countString) {
        GuiGraphics p_281607_ = guiGraphics;
        Slot p_282613_ = slot;
        String s = countString;
        int i = slot.f_40220_;
        int j = slot.f_40221_;
        int j1 = p_282613_.f_40220_ + p_282613_.f_40221_ * this.f_97726_;
    }

    public void recalculate() {
        boolean wideTexture;
        this.m_169413_();
        this.slotCount = this.getWrapper().getStorage().getSlots();
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.wider = wideTexture = this.slotCount > 81;
        int playerInventoryHeight = 96;
        this.f_97726_ = wideTexture ? 212 : 176;
        this.f_97727_ = 7 + this.calculateSlotHeight(wideTexture) + playerInventoryHeight;
        this.f_97731_ = this.f_97727_ - 93;
        this.f_97730_ = 8;
        if (wideTexture) {
            this.f_97730_ += 18;
        }
    }

    public void renderInventoryBackground(GuiGraphics guiGraphics, int x, int y, ResourceLocation texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.m_280218_(texture, x, y, 0, 0, xSize, 7 + halfSlotHeight);
        int playerInventoryHeight = 97;
        guiGraphics.m_280218_(texture, x, y + 7 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(GuiGraphics guiGraphics, int x, int y, int slotCount, int slotsInRow) {
        int lastSlotRow = slotCount % slotsInRow;
        int fullRows = slotCount / slotsInRow;
        guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y, 0, 0, slotsInRow * 18, fullRows * 18);
        if (lastSlotRow > 0) {
            guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
        }
    }

    public void renderScreen(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        this.renderInventoryBackground(guiGraphics, x, y, wideTexture ? BackpackScreen.BACKGROUND_11 : BackpackScreen.BACKGROUND_9, this.f_97726_, this.calculateSlotHeight(wideTexture));
        int slotsXOffset = 7;
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 7, this.slotCount, wideTexture ? 11 : 9);
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4), true);
        this.m_142416_(this.settingsWidget);
        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1));
        this.m_142416_(this.unsortablesWidget);
        this.memoryWidget = new MemoryWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1), false);
        this.m_142416_(this.memoryWidget);
        if (this.getWrapper().getScreenID() == 2) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1 + 24 + 1));
            this.m_142416_(this.visibilityWidget);
        }
    }

    public void initButtons() {
        this.buttons.clear();
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.m_6702_().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<GuiEventListener> widgets = this.m_6702_().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for (int i = 0; i < widgets.size(); ++i) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = (SettingsWidgetBase)widgets.get(i);
            if (i > 0) {
                previousWidget = (SettingsWidgetBase)widgets.get(i - 1);
            }
            if (previousWidget == null) continue;
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (this.unsortablesWidget.isTabOpened()) {
            if (!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
            }
        } else if (!this.lastUnsortableSlots.isEmpty()) {
            this.lastUnsortableSlots.forEach(i -> guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
        }
    }

    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (this.memoryWidget.isTabOpened()) {
            if (!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, 25, 73, 16, 16);
                    } else {
                        guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, 25, 91, 16, 16);
                    }
                    if (((BackpackSettingsMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                        ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                        guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                        guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                    }
                });
            }
        } else if (!this.lastMemorySlots.isEmpty()) {
            this.lastMemorySlots.forEach(pair -> {
                if (((BackpackSettingsMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                    ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                    guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
        if (this.selectSlots(slot, button)) {
            return;
        }
        super.m_6597_(slot, slotId, button, type);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        Slot slot = this.getSlotUnderMouse();
        if (this.selectSlots(slot, pButton)) {
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean selectSlots(Slot slot, int button) {
        if (slot != null && slot.f_40219_ >= 0 && slot.f_40219_ < this.wrapper.getStorage().getSlots()) {
            if (this.unsortablesWidget.isTabOpened()) {
                if (button == 0 && !this.unsortableSlots.contains(slot.f_40219_)) {
                    this.unsortableSlots.add(slot.f_40219_);
                    return true;
                }
                if (button == 1 && this.unsortableSlots.contains(slot.f_40219_)) {
                    this.unsortableSlots.remove((Object)slot.f_40219_);
                    return true;
                }
            }
            if (this.memoryWidget.isTabOpened()) {
                if (button == 0 && !this.memoryWidget.contains(slot.f_40219_, this.memorySlots)) {
                    if (slot.m_7993_().m_41619_()) {
                        return false;
                    }
                    this.memorySlots.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)slot.f_40219_, (Object)Pair.of((Object)slot.m_7993_(), (Object)this.memoryWidget.matchComponents)));
                    return true;
                }
                if (button == 1 && this.memoryWidget.contains(slot.f_40219_, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot.f_40219_);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void playUIClickSound() {
        ((BackpackSettingsMenu)this.f_97732_).getPlayerInventory().f_35978_.m_9236_().m_5594_(((BackpackSettingsMenu)this.f_97732_).getPlayerInventory().f_35978_, ((BackpackSettingsMenu)this.f_97732_).getPlayerInventory().f_35978_.m_20183_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.MASTER, 0.25f, 1.0f);
    }

    public void m_7379_() {
        this.sendDataToServer();
        super.m_7379_();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

