/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.model.BackpackModelData;
import com.tiviacz.travelersbackpack.client.renderer.BackpackRenderInfo;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.Locale;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;

public class BackpackBlockModel {
    public static final BackpackBlockModel BLOCK_MODEL = new BackpackBlockModel(BackpackModelData.createTravelersBackpack(false).m_171564_());
    public ModelPart mainBody;
    public ModelPart tankLeftTop;
    public ModelPart tankRightTop;
    public ModelPart sleepingBag;
    public ModelPart sleepingBagExtras;
    public ModelPart villagerNose;
    public ModelPart wolfNose;
    public ModelPart foxNose;
    public ModelPart ocelotNose;
    public ModelPart pigNose;
    public ModelPart leftHorn;
    public ModelPart rightHorn;

    public BackpackBlockModel(ModelPart rootPart) {
        this.mainBody = rootPart.m_171324_("main_body");
        this.tankLeftTop = rootPart.m_171324_("tankLeftTop");
        this.tankRightTop = rootPart.m_171324_("tankRightTop");
        this.sleepingBag = rootPart.m_171324_("sleepingBag");
        this.sleepingBagExtras = rootPart.m_171324_("sleepingBagExtras");
        this.villagerNose = rootPart.m_171324_("villagerNose");
        this.ocelotNose = rootPart.m_171324_("ocelotNose");
        this.pigNose = rootPart.m_171324_("pigNose");
        this.foxNose = rootPart.m_171324_("foxNose");
        this.wolfNose = rootPart.m_171324_("wolfNose");
        this.leftHorn = rootPart.m_171324_("leftHorn");
        this.rightHorn = rootPart.m_171324_("rightHorn");
    }

    public void render(BackpackBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BackpackWrapper wrapper = blockEntity.getWrapper();
        Item item = wrapper.getBackpackStack().m_41720_();
        if (!(item instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem item2 = (TravelersBackpackItem)item;
        ResourceLocation loc = item2.getBackpackTexture();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        boolean mainBodyRendered = false;
        if (item2 == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && NbtHelper.has(wrapper.getBackpackStack(), "Color")) {
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            Triple<Float, Float, Float> rgb = RenderHelper.intToRGB(BackpackDyeRecipe.getColor(wrapper.getBackpackStack()));
            this.mainBody.m_104306_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            mainBodyRendered = true;
        }
        if (wrapper.tanksVisible()) {
            this.tankLeftTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (!blockEntity.isSleepingBagDeployed()) {
            this.sleepingBagExtras.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(wrapper.getSleepingBagColor());
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBag.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = item2.getBackpackTexture();
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        }
        if (item2 == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
            this.foxNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
            this.ocelotNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
            this.wolfNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || item2 == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
            this.villagerNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.PIG_TRAVELERS_BACKPACK.get() || item2 == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
            this.pigNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
            vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
            this.leftHorn.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.rightHorn.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        }
        if (item2 == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || item2 == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
            vertexConsumer = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)item2.getBackpackTexture()));
        }
        if (!mainBodyRendered) {
            this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (wrapper.getUpgradeManager().tanksUpgrade.isPresent()) {
            RenderHelper.renderFluidInTank(wrapper.getUpgradeManager().tanksUpgrade.get().getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
            RenderHelper.renderFluidInTank(wrapper.getUpgradeManager().tanksUpgrade.get().getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
        }
    }

    public void renderByItem(ItemStack backpack, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        boolean renderDefault;
        TravelersBackpackItem item = (TravelersBackpackItem)backpack.m_41720_();
        ResourceLocation loc = item.getBackpackTexture();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        boolean bl = renderDefault = !NbtHelper.has(backpack, "RenderInfo");
        if (renderDefault) {
            this.tankLeftTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.sleepingBagExtras.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(DyeColor.RED.m_41060_());
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBag.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            if (item == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK.get() || item == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
                this.leftHorn.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.rightHorn.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            }
            if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || item == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.m_6299_(RenderType.m_110467_((ResourceLocation)item.getBackpackTexture()));
            }
            this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        } else {
            BackpackRenderInfo renderInfo = new BackpackRenderInfo(backpack, (RenderInfo)NbtHelper.get(backpack, "RenderInfo"));
            boolean backpackRendered = false;
            if (!renderInfo.isEmpty()) {
                this.tankLeftTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.tankRightTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                if (!renderInfo.getLeftTank().isEmpty()) {
                    RenderHelper.renderFluidInTank(renderInfo.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
                }
                if (!renderInfo.getRightTank().isEmpty()) {
                    RenderHelper.renderFluidInTank(renderInfo.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
                }
            }
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBagExtras.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(renderInfo.getSleepingBagColor());
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBag.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            if (renderInfo.isDyed()) {
                loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
                Triple<Float, Float, Float> rgb = RenderHelper.intToRGB(BackpackDyeRecipe.getColor(renderInfo.getBackpack()));
                this.mainBody.m_104306_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
                loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
                this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                backpackRendered = true;
            }
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            if (item == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK.get() || item == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
                this.leftHorn.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.rightHorn.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            }
            if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || item == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.m_6299_(RenderType.m_110467_((ResourceLocation)item.getBackpackTexture()));
            }
            if (!backpackRendered) {
                this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public static ResourceLocation getSleepingBagTexture(int color) {
        return new ResourceLocation("travelersbackpack", "textures/model/bags/" + DyeColor.m_41053_((int)color).m_41065_().toLowerCase(Locale.ENGLISH) + "_sleeping_bag.png");
    }
}

