/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.fog;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogDrawMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogFalloff;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiHeightFogMixMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiHeightFogMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.render.fog.FogSettings;
import com.seibel.distanthorizons.core.render.glObject.shader.Shader;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import java.util.Objects;

public class LodFogConfig {
    private static final IOptifineAccessor OPTIFINE = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
    public static final boolean DEBUG_DUMP_GENERATED_CODE = false;
    public final FogSettings farFogSetting;
    public final FogSettings heightFogSetting;
    public final EDhApiHeightFogMixMode heightFogMixMode;
    public final EDhApiHeightFogMode heightFogMode;
    public final float heightFogHeight;
    public final int earthCurveRatio = Config.Client.Advanced.Graphics.AdvancedGraphics.earthCurveRatio.get();
    public final boolean noiseEnable = Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseEnabled.get();
    public final int noiseSteps = Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseSteps.get();
    public final float noiseIntensity = Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseIntensity.get().floatValue();
    public final int noiseDropoff = Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseDropoff.get();

    public static LodFogConfig generateFogConfig() {
        EDhApiFogDrawMode fogMode = Config.Client.Advanced.Graphics.Fog.drawMode.get();
        if (fogMode == EDhApiFogDrawMode.USE_OPTIFINE_SETTING && OPTIFINE != null) {
            fogMode = OPTIFINE.getFogDrawMode();
        }
        return new LodFogConfig(fogMode);
    }

    private LodFogConfig(EDhApiFogDrawMode fogDrawMode) {
        if (fogDrawMode != EDhApiFogDrawMode.FOG_DISABLED) {
            this.farFogSetting = new FogSettings(Config.Client.Advanced.Graphics.Fog.AdvancedFog.farFogStart.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.farFogEnd.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.farFogMin.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.farFogMax.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.farFogDensity.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.farFogFalloff.get());
            this.heightFogMixMode = Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogMixMode.get();
            if (this.heightFogMixMode == EDhApiHeightFogMixMode.IGNORE_HEIGHT || this.heightFogMixMode == EDhApiHeightFogMixMode.BASIC) {
                this.heightFogSetting = null;
                this.heightFogMode = null;
                this.heightFogHeight = 0.0f;
            } else {
                this.heightFogSetting = new FogSettings(Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogDensity.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogEnd.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogMin.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogMax.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogDensity.get(), Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogFalloff.get());
                this.heightFogMode = Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogMode.get();
                this.heightFogHeight = this.heightFogMode.basedOnCamera ? 0.0f : Config.Client.Advanced.Graphics.Fog.AdvancedFog.HeightFog.heightFogBaseHeight.get().floatValue();
            }
        } else {
            this.farFogSetting = null;
            this.heightFogMixMode = null;
            this.heightFogMode = null;
            this.heightFogSetting = null;
            this.heightFogHeight = 0.0f;
        }
    }

    public StringBuilder loadAndProcessFragShader(String path, boolean absoluteFilePath) {
        StringBuilder stringBuilder = this.makeRuntimeDefine();
        this.generateRuntimeShaderCode(Shader.loadFile(path, absoluteFilePath, stringBuilder));
        return stringBuilder;
    }

    private void generateRuntimeShaderCode(StringBuilder str) {
        str.append("// =======RUNTIME GENERATED CODE SECTION======== //\n");
        str.append("float getNearFogThickness(float dist) \n{ \n\treturn linearFog(dist, uNearFogStart, uNearFogLength, 0.0, 1.0); \n} \n");
        if (this.farFogSetting == null) {
            str.append("\nfloat getFarFogThickness(float dist) { return 0.0; } \nfloat getHeightFogThickness(float dist) { return 0.0; } \nfloat calculateFarFogDepth(float horizontal, float dist, float uNearFogStart) { return 0.0; } \nfloat calculateHeightFogDepth(float vertical, float realY) { return 0.0; } \nfloat mixFogThickness(float near, float far, float height) \n{ \n    return 0.0; \n} \n\n");
        } else {
            str.append("float getFarFogThickness(float dist) \n{ \n" + LodFogConfig.getFarFogMethod(this.farFogSetting.fogType) + "\n} \n");
            str.append("float getHeightFogThickness(float dist) \n{ \n" + (this.heightFogSetting != null ? LodFogConfig.getHeightFogMethod(this.heightFogSetting.fogType) : "\treturn 0.0;") + "\n} \n");
            str.append("float calculateHeightFogDepth(float vertical, float realY) \n{ \n" + (this.heightFogSetting != null ? LodFogConfig.getHeightDepthMethod(this.heightFogMode, this.heightFogHeight) : "\treturn 0.0;") + "\n} \n");
            str.append("float calculateFarFogDepth(float horizontal, float dist, float uNearFogStart) \n{ \n\treturn " + (this.heightFogMixMode == EDhApiHeightFogMixMode.BASIC ? "(dist - uNearFogStart)/(1.0 - uNearFogStart);" : "(horizontal - uNearFogStart)/(1.0 - uNearFogStart);") + "} \n");
            str.append("float mixFogThickness(float near, float far, float height) \n{ \n" + LodFogConfig.getMixFogLine(this.heightFogMixMode) + "\n} \n");
        }
    }

    private StringBuilder makeRuntimeDefine() {
        StringBuilder str = new StringBuilder();
        str.append("// =======RUNTIME GENERATED DEFINE SECTION======== //\n");
        str.append("#version 150 core\n");
        FogSettings activeFarFogSetting = this.farFogSetting != null ? this.farFogSetting : FogSettings.EMPTY;
        FogSettings activeHeightFogSetting = this.heightFogSetting != null ? this.heightFogSetting : FogSettings.EMPTY;
        str.append("\n#define farFogStart " + activeFarFogSetting.start + "\n#define farFogLength " + (activeFarFogSetting.end - activeFarFogSetting.start) + "\n#define farFogMin " + activeFarFogSetting.min + "\n#define farFogRange " + (activeFarFogSetting.max - activeFarFogSetting.min) + "\n#define farFogDensity " + activeFarFogSetting.density + "\n\n#define heightFogStart " + activeHeightFogSetting.start + "\n#define heightFogLength " + (activeHeightFogSetting.end - activeHeightFogSetting.start) + "\n#define heightFogMin " + activeHeightFogSetting.min + "\n#define heightFogRange " + (activeHeightFogSetting.max - activeHeightFogSetting.min) + "\n#define heightFogDensity " + activeHeightFogSetting.density + "\n\n");
        str.append("// =======RUNTIME END======== //\n");
        return str;
    }

    private static String getFarFogMethod(EDhApiFogFalloff fogType) {
        switch (fogType) {
            case LINEAR: {
                return "return linearFog(dist, farFogStart, farFogLength, farFogMin, farFogRange);\n";
            }
            case EXPONENTIAL: {
                return "return exponentialFog(dist, farFogStart, farFogLength, farFogMin, farFogRange, farFogDensity);\n";
            }
            case EXPONENTIAL_SQUARED: {
                return "return exponentialSquaredFog(dist, farFogStart, farFogLength, farFogMin, farFogRange, farFogDensity);\n";
            }
        }
        throw new IllegalArgumentException("FogType [" + (Object)((Object)fogType) + "] not implemented for [getFarFogMethod].");
    }

    private static String getHeightDepthMethod(EDhApiHeightFogMode heightMode, float heightFogHeight) {
        String str = "";
        if (!heightMode.basedOnCamera) {
            str = "\tvertical = realY - (" + heightFogHeight + ");\n";
        }
        str = heightMode.below && heightMode.above ? str + "\treturn abs(vertical);\n" : (heightMode.below ? str + "\treturn -vertical;\n" : (heightMode.above ? str + "\treturn vertical;\n" : str + "\treturn 0;\n"));
        return str;
    }

    private static String getHeightFogMethod(EDhApiFogFalloff fogType) {
        switch (fogType) {
            case LINEAR: {
                return "\treturn linearFog(dist, heightFogStart, heightFogLength, heightFogMin, heightFogRange);\n";
            }
            case EXPONENTIAL: {
                return "\treturn exponentialFog(dist, heightFogStart, heightFogLength, heightFogMin, heightFogRange, heightFogDensity);\n";
            }
            case EXPONENTIAL_SQUARED: {
                return "\treturn exponentialSquaredFog(dist, heightFogStart, heightFogLength, heightFogMin, heightFogRange, heightFogDensity);\n";
            }
        }
        throw new IllegalArgumentException("FogType [" + (Object)((Object)fogType) + "] not implemented for [getHeightFogMethod].");
    }

    private static String getMixFogLine(EDhApiHeightFogMixMode heightFogMode) {
        String str = "\treturn ";
        switch (heightFogMode) {
            case BASIC: 
            case IGNORE_HEIGHT: {
                str = str + "near * far;\n";
                break;
            }
            case ADDITION: {
                str = str + "near * (far + height);\n";
                break;
            }
            case MAX: {
                str = str + "near * max(far, height);\n";
                break;
            }
            case INVERSE_MULTIPLY: {
                str = str + "near * (1.0 - (1.0-far)*(1.0-height));\n";
                break;
            }
            case MULTIPLY: {
                str = str + "near * far * height;\n";
                break;
            }
            case LIMITED_ADDITION: {
                str = str + "near * (far + max(far, height));\n";
                break;
            }
            case MULTIPLY_ADDITION: {
                str = str + "near * (far + far*height);\n";
                break;
            }
            case INVERSE_MULTIPLY_ADDITION: {
                str = str + "near * (far + 1.0 - (1.0-far)*(1.0-height));\n";
                break;
            }
            case AVERAGE: {
                str = str + "near * (far*0.5 + height*0.5);\n";
                break;
            }
            default: {
                throw new IllegalArgumentException("FogType [" + (Object)((Object)heightFogMode) + "] not implemented for [getMixFogMethod].");
            }
        }
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LodFogConfig that = (LodFogConfig)o;
        return Float.compare(that.heightFogHeight, this.heightFogHeight) == 0 && Objects.equals(this.farFogSetting, that.farFogSetting) && Objects.equals(this.heightFogSetting, that.heightFogSetting) && this.heightFogMixMode == that.heightFogMixMode && this.heightFogMode == that.heightFogMode && this.earthCurveRatio == that.earthCurveRatio && this.noiseEnable == that.noiseEnable && this.noiseSteps == that.noiseSteps && this.noiseIntensity == that.noiseIntensity && this.noiseDropoff == that.noiseDropoff;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.farFogSetting, this.heightFogSetting, this.heightFogMixMode, this.heightFogMode, Float.valueOf(this.heightFogHeight), this.earthCurveRatio, this.noiseEnable, this.noiseSteps, Float.valueOf(this.noiseIntensity), this.noiseDropoff});
    }
}

