/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.TimerUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DelayedFullDataSourceSaveCache {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final Timer DELAY_UPDATE_TIMER = TimerUtil.CreateTimer("Delayed Full Datasource Save Timer");
    public final ConcurrentHashMap<Long, FullDataSourceV2> dataSourceByPosition = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, TimerTask> saveTimerTasksBySectionPos = new ConcurrentHashMap();
    private final ISaveDataSourceFunc onSaveTimeoutFunc;
    private final int saveDelayInMs;

    public DelayedFullDataSourceSaveCache(@NotNull ISaveDataSourceFunc onSaveTimeoutFunc, int saveDelayInMs) {
        this.onSaveTimeoutFunc = onSaveTimeoutFunc;
        this.saveDelayInMs = saveDelayInMs;
    }

    public void queueDataSourceForUpdateAndSave(FullDataSourceV2 inputDataSource) {
        final long dataSourcePos = inputDataSource.getPos();
        this.dataSourceByPosition.compute(dataSourcePos, (inputPos, temporaryDataSource) -> {
            if (temporaryDataSource == null) {
                temporaryDataSource = FullDataSourceV2.createEmpty(inputPos);
            }
            temporaryDataSource.update(inputDataSource);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    DelayedFullDataSourceSaveCache.this.saveTimerTasksBySectionPos.remove(dataSourcePos);
                    try {
                        FullDataSourceV2 dataSourceToSave = DelayedFullDataSourceSaveCache.this.dataSourceByPosition.remove(dataSourcePos);
                        if (dataSourceToSave != null) {
                            DelayedFullDataSourceSaveCache.this.onSaveTimeoutFunc.save(dataSourceToSave);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to save updated data for section [" + dataSourcePos + "], error: [" + e.getMessage() + "]", (Throwable)e);
                    }
                }
            };
            try {
                DELAY_UPDATE_TIMER.schedule(timerTask, this.saveDelayInMs);
            }
            catch (IllegalStateException ignore) {
                LOGGER.warn("Attempted to queue an already canceled task. Pos: [" + dataSourcePos + "], task already queued for pos: [" + this.saveTimerTasksBySectionPos.containsKey(dataSourcePos) + "]");
            }
            TimerTask oldTask = this.saveTimerTasksBySectionPos.put(dataSourcePos, timerTask);
            if (oldTask != null) {
                oldTask.cancel();
            }
            return temporaryDataSource;
        });
    }

    public int getUnsavedCount() {
        return this.dataSourceByPosition.size();
    }

    @FunctionalInterface
    public static interface ISaveDataSourceFunc {
        public void save(FullDataSourceV2 var1);
    }
}

