/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.zigythebird.playeranimatorapi.API.PlayerAnimAPI;
import com.zigythebird.playeranimatorapi.commands.CommandState;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayPlayerAnimationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playPlayerAnimation").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"animationID", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> PlayPlayerAnimationCommand.execute((CommandContext<CommandSourceStack>)context, CommandState.Minimal))).then(Commands.m_82129_((String)"fadeLength", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"priority", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"easeID", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"firstPersonEnabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayPlayerAnimationCommand.execute((CommandContext<CommandSourceStack>)context, CommandState.Advanced))).then(Commands.m_82129_((String)"playerParts", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"modifiers", (ArgumentType)StringArgumentType.string()).executes(context -> PlayPlayerAnimationCommand.execute((CommandContext<CommandSourceStack>)context, CommandState.Complete)))))))))));
    }

    private static int execute(CommandContext<CommandSourceStack> command, CommandState state) {
        block10: {
            try {
                switch (state) {
                    case Minimal: {
                        for (ServerPlayer player : EntityArgument.m_91477_(command, (String)"player")) {
                            PlayerAnimAPI.playPlayerAnim((ServerLevel)player.m_9236_(), (Player)player, ResourceLocationArgument.m_107011_(command, (String)"animationID"));
                        }
                        break;
                    }
                    case Advanced: {
                        for (ServerPlayer player : EntityArgument.m_91477_(command, (String)"player")) {
                            PlayerAnimationData data = new PlayerAnimationData(player.m_20148_(), ResourceLocationArgument.m_107011_(command, (String)"animationID"), null, null, IntegerArgumentType.getInteger(command, (String)"fadeLength"), IntegerArgumentType.getInteger(command, (String)"easeID"), IntegerArgumentType.getInteger(command, (String)"priority"), BoolArgumentType.getBool(command, (String)"firstPersonEnabled"));
                            PlayerAnimAPI.playPlayerAnim(((CommandSourceStack)command.getSource()).m_81372_(), (Player)player, data);
                        }
                        break;
                    }
                    case Complete: {
                        for (ServerPlayer player : EntityArgument.m_91477_(command, (String)"player")) {
                            PlayerAnimationData data = new PlayerAnimationData(player.m_20148_(), ResourceLocationArgument.m_107011_(command, (String)"animationID"), PlayerParts.fromBigInteger(PlayPlayerAnimationCommand.playerPartsIntFromString(StringArgumentType.getString(command, (String)"playerParts"))), PlayPlayerAnimationCommand.modifierList(StringArgumentType.getString(command, (String)"modifiers")), IntegerArgumentType.getInteger(command, (String)"fadeLength"), IntegerArgumentType.getInteger(command, (String)"easeID"), IntegerArgumentType.getInteger(command, (String)"priority"), BoolArgumentType.getBool(command, (String)"firstPersonEnabled"));
                            PlayerAnimAPI.playPlayerAnim(((CommandSourceStack)command.getSource()).m_81372_(), (Player)player, data);
                        }
                        break;
                    }
                }
            }
            catch (CommandSyntaxException e) {
                ServerPlayer player = ((CommandSourceStack)command.getSource()).m_230896_();
                if (player == null) break block10;
                player.m_213846_((Component)Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED));
            }
        }
        return 1;
    }

    public static List<CommonModifier> modifierList(String input) {
        ArrayList<CommonModifier> list = new ArrayList<CommonModifier>();
        for (String str : input.split(";")) {
            list.add(new CommonModifier(new ResourceLocation(str), null));
        }
        return list;
    }

    public static BigInteger playerPartsIntFromString(String string) {
        try {
            return new BigInteger(string, 36);
        }
        catch (NumberFormatException e) {
            return new BigInteger("axq5j8k4e1uiyz27", 36);
        }
    }
}

