/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.HydraLairComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.ProgressionStructure;
import twilightforest.world.components.structures.util.StructureHints;

public class HydraLairStructure
extends ProgressionStructure {
    public static final Codec<HydraLairStructure> CODEC = RecordCodecBuilder.create(instance -> HydraLairStructure.progressionCodec(instance).apply((Applicative)instance, HydraLairStructure::new));

    public HydraLairStructure(AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(advancementLockConfig, hintConfig, decorationConfig, structureSettings);
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return new HydraLairComponent(0, x - 7, y, z - 7);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.HYDRA_LAIR.get();
    }

    public static HydraLairStructure buildHydraLairConfig(BootstapContext<Structure> context) {
        return new HydraLairStructure(new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_labyrinth"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("hydralair", 4), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(2, false, false, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_HYDRA_LAIR_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE));
    }
}

