/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import twilightforest.block.GiantBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.giant_pick.GiantPickMineCapability;
import twilightforest.item.GiantPickItem;

@Mod.EventBusSubscriber(modid="twilightforest")
public class GiantToolGroupingModifier
extends LootModifier {
    public static Map<Block, Item> CONVERSIONS = new HashMap<Block, Item>();
    public static final Codec<GiantToolGroupingModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GiantToolGroupingModifier::new));

    public GiantToolGroupingModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object = context.m_165124_(LootContextParams.f_81455_);
        if (object instanceof Player) {
            Player player = (Player)object;
            BlockState state = (BlockState)context.m_165124_(LootContextParams.f_81461_);
            if (CONVERSIONS.containsKey(state.m_60734_())) {
                LazyOptional lazyOptional = player.getCapability(CapabilityList.GIANT_PICK_MINE);
                int blockConversion = lazyOptional.map(GiantPickMineCapability::getGiantBlockConversion).orElse(0);
                lazyOptional.ifPresent(giantPickMineCapability -> giantPickMineCapability.setGiantBlockConversion(blockConversion - 1));
                if (blockConversion == 64) {
                    return ObjectArrayList.of((Object[])new ItemStack[]{new ItemStack((ItemLike)CONVERSIONS.get(state.m_60734_()))});
                }
                return new ObjectArrayList();
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        Optional optionalCapability;
        ServerPlayer player;
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && GiantToolGroupingModifier.canHarvestWithGiantPick((Player)(player = (ServerPlayer)player2), state) && (optionalCapability = player.getCapability(CapabilityList.GIANT_PICK_MINE).resolve()).isPresent() && GiantToolGroupingModifier.shouldBreakGiantBlock((Player)player, (GiantPickMineCapability)optionalCapability.get())) {
            GiantPickMineCapability capability = (GiantPickMineCapability)optionalCapability.get();
            capability.setBreaking(true);
            boolean allTheSame = CONVERSIONS.containsKey(state.m_60734_());
            for (BlockPos offsetPos : GiantBlock.getVolume(pos)) {
                if (!allTheSame || player.m_9236_().m_8055_(offsetPos).m_60713_(state.m_60734_())) continue;
                allTheSame = false;
            }
            capability.setGiantBlockConversion(allTheSame ? 64 : 0);
            event.setCanceled(true);
            player.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            player.f_8941_.m_9280_(pos);
            for (BlockPos offsetPos : GiantBlock.getVolume(pos)) {
                if (offsetPos.equals((Object)pos) || !player.m_9236_().m_8055_(offsetPos).m_60713_(state.m_60734_())) continue;
                BlockPos newPos = new BlockPos((Vec3i)offsetPos);
                player.m_9236_().m_46796_(2001, newPos, Block.m_49956_((BlockState)player.m_9236_().m_8055_(newPos)));
                player.f_8941_.m_9280_(newPos);
            }
            capability.setBreaking(false);
        }
    }

    private static boolean canHarvestWithGiantPick(Player player, BlockState state) {
        return player.m_21205_().m_41720_() instanceof GiantPickItem && ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
    }

    private static boolean shouldBreakGiantBlock(Player player, GiantPickMineCapability capability) {
        return capability.getMining() == player.m_9236_().m_46467_() && !capability.getBreaking();
    }
}

