/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.fml.ModList;
import twilightforest.init.TFLoot;

public class ModExistsCondition
implements LootItemCondition {
    private final boolean exists;
    private final String modID;

    public ModExistsCondition(String modID) {
        this.exists = ModList.get().isLoaded(modID);
        this.modID = modID;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)TFLoot.MOD_EXISTS.get();
    }

    public boolean test(LootContext context) {
        return this.exists;
    }

    public static LootItemCondition.Builder builder(String modid) {
        return () -> new ModExistsCondition(modid);
    }

    public static class ConditionSerializer
    implements Serializer<ModExistsCondition> {
        public void serialize(JsonObject json, ModExistsCondition value, JsonSerializationContext context) {
            json.addProperty("mod_id", value.modID);
        }

        public ModExistsCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return new ModExistsCondition(GsonHelper.m_13906_((JsonObject)json, (String)"mod_id"));
        }
    }
}

