/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.entity.ChainBlock;
import twilightforest.entity.CharmEffect;
import twilightforest.entity.CubeOfAnnihilation;
import twilightforest.entity.MagicPainting;
import twilightforest.entity.ProtectionBox;
import twilightforest.entity.RovingCube;
import twilightforest.entity.SlideBlock;
import twilightforest.entity.TFEntityNames;
import twilightforest.entity.TwilightBoat;
import twilightforest.entity.TwilightChestBoat;
import twilightforest.entity.boss.AlphaYeti;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraMortar;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.boss.Minoshroom;
import twilightforest.entity.boss.Naga;
import twilightforest.entity.boss.PlateauBoss;
import twilightforest.entity.boss.SnowQueen;
import twilightforest.entity.boss.UrGhast;
import twilightforest.entity.monster.Adherent;
import twilightforest.entity.monster.ArmoredGiant;
import twilightforest.entity.monster.BlockChainGoblin;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.entity.monster.CarminiteGolem;
import twilightforest.entity.monster.DeathTome;
import twilightforest.entity.monster.FireBeetle;
import twilightforest.entity.monster.GiantMiner;
import twilightforest.entity.monster.HarbingerCube;
import twilightforest.entity.monster.HedgeSpider;
import twilightforest.entity.monster.HelmetCrab;
import twilightforest.entity.monster.HostileWolf;
import twilightforest.entity.monster.IceCrystal;
import twilightforest.entity.monster.KingSpider;
import twilightforest.entity.monster.Kobold;
import twilightforest.entity.monster.LichMinion;
import twilightforest.entity.monster.LowerGoblinKnight;
import twilightforest.entity.monster.LoyalZombie;
import twilightforest.entity.monster.MazeSlime;
import twilightforest.entity.monster.Minotaur;
import twilightforest.entity.monster.MistWolf;
import twilightforest.entity.monster.MosquitoSwarm;
import twilightforest.entity.monster.PinchBeetle;
import twilightforest.entity.monster.Redcap;
import twilightforest.entity.monster.RedcapSapper;
import twilightforest.entity.monster.RisingZombie;
import twilightforest.entity.monster.SkeletonDruid;
import twilightforest.entity.monster.SlimeBeetle;
import twilightforest.entity.monster.SnowGuardian;
import twilightforest.entity.monster.StableIceCore;
import twilightforest.entity.monster.SwarmSpider;
import twilightforest.entity.monster.TowerBroodling;
import twilightforest.entity.monster.TowerwoodBorer;
import twilightforest.entity.monster.Troll;
import twilightforest.entity.monster.UnstableIceCore;
import twilightforest.entity.monster.UpperGoblinKnight;
import twilightforest.entity.monster.WinterWolf;
import twilightforest.entity.monster.Wraith;
import twilightforest.entity.monster.Yeti;
import twilightforest.entity.passive.Bighorn;
import twilightforest.entity.passive.Boar;
import twilightforest.entity.passive.Deer;
import twilightforest.entity.passive.DwarfRabbit;
import twilightforest.entity.passive.Penguin;
import twilightforest.entity.passive.QuestRam;
import twilightforest.entity.passive.Raven;
import twilightforest.entity.passive.Squirrel;
import twilightforest.entity.passive.TinyBird;
import twilightforest.entity.projectile.FallingIce;
import twilightforest.entity.projectile.IceArrow;
import twilightforest.entity.projectile.IceBomb;
import twilightforest.entity.projectile.IceSnowball;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.entity.projectile.MoonwormShot;
import twilightforest.entity.projectile.NatureBolt;
import twilightforest.entity.projectile.SeekerArrow;
import twilightforest.entity.projectile.SlimeProjectile;
import twilightforest.entity.projectile.ThrownBlock;
import twilightforest.entity.projectile.ThrownWep;
import twilightforest.entity.projectile.TomeBolt;
import twilightforest.entity.projectile.TwilightWandBolt;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TFEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"twilightforest");
    public static final DeferredRegister<Item> SPAWN_EGGS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"twilightforest");
    public static final RegistryObject<EntityType<Adherent>> ADHERENT = TFEntities.make(TFEntityNames.ADHERENT, Adherent::new, MobCategory.MONSTER, 0.8f, 2.2f, 655360, 139);
    public static final RegistryObject<EntityType<AlphaYeti>> ALPHA_YETI = TFEntities.make(TFEntityNames.ALPHA_YETI, AlphaYeti::new, MobCategory.MONSTER, 3.8f, 5.0f, 0xCDCDCD, 2705518);
    public static final RegistryObject<EntityType<ArmoredGiant>> ARMORED_GIANT = TFEntities.make(TFEntityNames.ARMORED_GIANT, ArmoredGiant::new, MobCategory.MONSTER, 2.4f, 7.2f, 2331537, 0x9A9A9A);
    public static final RegistryObject<EntityType<Bighorn>> BIGHORN_SHEEP = TFEntities.make(TFEntityNames.BIGHORN_SHEEP, Bighorn::new, MobCategory.CREATURE, 0.9f, 1.3f, 14405295, 14141297);
    public static final RegistryObject<EntityType<BlockChainGoblin>> BLOCKCHAIN_GOBLIN = TFEntities.make(TFEntityNames.BLOCKCHAIN_GOBLIN, BlockChainGoblin::new, MobCategory.MONSTER, 0.9f, 1.4f, 13887420, 0x1F3FFF);
    public static final RegistryObject<EntityType<Boar>> BOAR = TFEntities.make(TFEntityNames.BOAR, Boar::new, MobCategory.CREATURE, 0.9f, 0.9f, 8611131, 16773066);
    public static final RegistryObject<EntityType<TwilightBoat>> BOAT = TFEntities.buildNoEgg(TFEntityNames.BOAT, TFEntities.makeCastedBuilder(TwilightBoat.class, TwilightBoat::new, 1.375f, 0.5625f, 10, 3), false);
    public static final RegistryObject<EntityType<TowerBroodling>> CARMINITE_BROODLING = TFEntities.make(TFEntityNames.CARMINITE_BROODLING, TowerBroodling::new, MobCategory.MONSTER, 0.7f, 0.5f, 3423252, 12250626);
    public static final RegistryObject<EntityType<CarminiteGhastguard>> CARMINITE_GHASTGUARD = TFEntities.make(TFEntityNames.CARMINITE_GHASTGUARD, CarminiteGhastguard::new, MobCategory.MONSTER, 4.0f, 6.0f, 0xBCBCBC, 0xB77878);
    public static final RegistryObject<EntityType<CarminiteGhastling>> CARMINITE_GHASTLING = TFEntities.make(TFEntityNames.CARMINITE_GHASTLING, CarminiteGhastling::new, MobCategory.MONSTER, 1.1f, 1.5f, 0xBCBCBC, 10961731);
    public static final RegistryObject<EntityType<CarminiteGolem>> CARMINITE_GOLEM = TFEntities.make(TFEntityNames.CARMINITE_GOLEM, CarminiteGolem::new, MobCategory.MONSTER, 1.4f, 2.9f, 7028000, 14867930);
    public static final RegistryObject<EntityType<ChainBlock>> CHAIN_BLOCK = TFEntities.buildNoEgg(TFEntityNames.CHAIN_BLOCK, TFEntities.makeCastedBuilder(ChainBlock.class, ChainBlock::new, 0.6f, 0.6f, 80, 1), true);
    public static final RegistryObject<EntityType<CharmEffect>> CHARM_EFFECT = TFEntities.make(TFEntityNames.CHARM_EFFECT, CharmEffect::new, MobCategory.MISC, 0.25f, 0.25f, 0, 0);
    public static final RegistryObject<EntityType<TwilightChestBoat>> CHEST_BOAT = TFEntities.buildNoEgg(TFEntityNames.CHEST_BOAT, TFEntities.makeCastedBuilder(TwilightChestBoat.class, TwilightChestBoat::new, 1.375f, 0.5625f, 10, 3), false);
    public static final RegistryObject<EntityType<CubeOfAnnihilation>> CUBE_OF_ANNIHILATION = TFEntities.buildNoEgg(TFEntityNames.CUBE_OF_ANNIHILATION, TFEntities.makeCastedBuilder(CubeOfAnnihilation.class, CubeOfAnnihilation::new, 1.0f, 1.0f, 80, 1), true);
    public static final RegistryObject<EntityType<DeathTome>> DEATH_TOME = TFEntities.make(TFEntityNames.DEATH_TOME, DeathTome::new, MobCategory.MONSTER, 0.6f, 1.1f, 7818786, 14405054);
    public static final RegistryObject<EntityType<Deer>> DEER = TFEntities.make(TFEntityNames.DEER, Deer::new, MobCategory.CREATURE, 0.7f, 1.8f, 8080686, 4924445);
    public static final RegistryObject<EntityType<DwarfRabbit>> DWARF_RABBIT = TFEntities.make(TFEntityNames.DWARF_RABBIT, DwarfRabbit::new, MobCategory.CREATURE, 0.4f, 0.4f, 0xFEFEEE, 0xCCAA99);
    public static final RegistryObject<EntityType<FallingIce>> FALLING_ICE = TFEntities.make(TFEntityNames.FALLING_ICE, FallingIce::new, MobCategory.MISC, 1.0f, 1.0f, true, 0, 0);
    public static final RegistryObject<EntityType<FireBeetle>> FIRE_BEETLE = TFEntities.make(TFEntityNames.FIRE_BEETLE, FireBeetle::new, MobCategory.MONSTER, 1.1f, 0.5f, true, 1903360, 13332261);
    public static final RegistryObject<EntityType<GiantMiner>> GIANT_MINER = TFEntities.make(TFEntityNames.GIANT_MINER, GiantMiner::new, MobCategory.MONSTER, 2.4f, 7.2f, 2169682, 0x9A9A9A);
    public static final RegistryObject<EntityType<HarbingerCube>> HARBINGER_CUBE = TFEntities.make(TFEntityNames.HARBINGER_CUBE, HarbingerCube::new, MobCategory.MONSTER, 1.9f, 2.4f, true, 10, 0x8B0000);
    public static final RegistryObject<EntityType<HedgeSpider>> HEDGE_SPIDER = TFEntities.make(TFEntityNames.HEDGE_SPIDER, HedgeSpider::new, MobCategory.MONSTER, 1.4f, 0.9f, 2318099, 5645907);
    public static final RegistryObject<EntityType<HelmetCrab>> HELMET_CRAB = TFEntities.make(TFEntityNames.HELMET_CRAB, HelmetCrab::new, MobCategory.MONSTER, 0.8f, 1.1f, 16486475, 13887420);
    public static final RegistryObject<EntityType<HostileWolf>> HOSTILE_WOLF = TFEntities.make(TFEntityNames.HOSTILE_WOLF, HostileWolf::new, MobCategory.MONSTER, 0.6f, 0.85f, 0xD7D3D3, 11214356);
    public static final RegistryObject<EntityType<Hydra>> HYDRA = TFEntities.make(TFEntityNames.HYDRA, Hydra::new, MobCategory.MONSTER, 16.0f, 12.0f, true, 1321280, 2719851);
    public static final RegistryObject<EntityType<HydraMortar>> HYDRA_MORTAR = TFEntities.buildNoEgg(TFEntityNames.HYDRA_MORTAR, TFEntities.makeCastedBuilder(HydraMortar.class, HydraMortar::new, 0.75f, 0.75f, 150, 3), true);
    public static final RegistryObject<EntityType<IceArrow>> ICE_ARROW = TFEntities.buildNoEgg(TFEntityNames.ICE_ARROW, TFEntities.makeCastedBuilder(IceArrow.class, IceArrow::new, 0.5f, 0.5f, 150, 1), false);
    public static final RegistryObject<EntityType<IceBomb>> THROWN_ICE = TFEntities.buildNoEgg(TFEntityNames.THROWN_ICE, TFEntities.makeCastedBuilder(IceBomb.class, IceBomb::new, 1.0f, 1.0f, 80, 2), true);
    public static final RegistryObject<EntityType<IceCrystal>> ICE_CRYSTAL = TFEntities.make(TFEntityNames.ICE_CRYSTAL, IceCrystal::new, MobCategory.MONSTER, 0.6f, 1.8f, 14477822, 11389691);
    public static final RegistryObject<EntityType<IceSnowball>> ICE_SNOWBALL = TFEntities.buildNoEgg(TFEntityNames.ICE_SNOWBALL, TFEntities.makeCastedBuilder(IceSnowball.class, IceSnowball::new, 0.25f, 0.25f, 150, 3), false);
    public static final RegistryObject<EntityType<KingSpider>> KING_SPIDER = TFEntities.make(TFEntityNames.KING_SPIDER, KingSpider::new, MobCategory.MONSTER, 1.6f, 1.6f, 2890254, 16760855);
    public static final RegistryObject<EntityType<KnightPhantom>> KNIGHT_PHANTOM = TFEntities.make(TFEntityNames.KNIGHT_PHANTOM, KnightPhantom::new, MobCategory.MONSTER, 1.25f, 2.5f, 10905403, 13887420);
    public static final RegistryObject<EntityType<Kobold>> KOBOLD = TFEntities.make(TFEntityNames.KOBOLD, Kobold::new, MobCategory.MONSTER, 0.8f, 1.1f, 3612822, 9002267);
    public static final RegistryObject<EntityType<Lich>> LICH = TFEntities.make(TFEntityNames.LICH, Lich::new, MobCategory.MONSTER, 1.1f, 2.1f, 11314313, 3540082);
    public static final RegistryObject<EntityType<LichBolt>> LICH_BOLT = TFEntities.buildNoEgg(TFEntityNames.LICH_BOLT, TFEntities.makeCastedBuilder(LichBolt.class, LichBolt::new, 0.25f, 0.25f, 150, 2), false);
    public static final RegistryObject<EntityType<LichBomb>> LICH_BOMB = TFEntities.buildNoEgg(TFEntityNames.LICH_BOMB, TFEntities.makeCastedBuilder(LichBomb.class, LichBomb::new, 0.25f, 0.25f, 150, 3), false);
    public static final RegistryObject<EntityType<LichMinion>> LICH_MINION = TFEntities.make(TFEntityNames.LICH_MINION, LichMinion::new, MobCategory.MONSTER, 0.6f, 1.95f, 0, 0);
    public static final RegistryObject<EntityType<LowerGoblinKnight>> LOWER_GOBLIN_KNIGHT = TFEntities.make(TFEntityNames.LOWER_GOBLIN_KNIGHT, LowerGoblinKnight::new, MobCategory.MONSTER, 0.7f, 1.1f, 0x566055, 13887420);
    public static final RegistryObject<EntityType<LoyalZombie>> LOYAL_ZOMBIE = TFEntities.make(TFEntityNames.LOYAL_ZOMBIE, LoyalZombie::new, MobCategory.MONSTER, 0.6f, 1.8f, 0, 0);
    public static final RegistryObject<EntityType<MazeSlime>> MAZE_SLIME = TFEntities.make(TFEntityNames.MAZE_SLIME, MazeSlime::new, MobCategory.MONSTER, 2.04f, 2.04f, 0xA3A3A3, 2767639);
    public static final RegistryObject<EntityType<Minoshroom>> MINOSHROOM = TFEntities.make(TFEntityNames.MINOSHROOM, Minoshroom::new, MobCategory.MONSTER, 1.49f, 2.5f, 11014162, 11173222);
    public static final RegistryObject<EntityType<Minotaur>> MINOTAUR = TFEntities.make(TFEntityNames.MINOTAUR, Minotaur::new, MobCategory.MONSTER, 0.6f, 2.1f, 4141092, 11173222);
    public static final RegistryObject<EntityType<MistWolf>> MIST_WOLF = TFEntities.make(TFEntityNames.MIST_WOLF, MistWolf::new, MobCategory.MONSTER, 1.4f, 1.9f, 3806225, 14862474);
    public static final RegistryObject<EntityType<MoonwormShot>> MOONWORM_SHOT = TFEntities.buildNoEgg(TFEntityNames.MOONWORM_SHOT, TFEntities.makeCastedBuilder(MoonwormShot.class, MoonwormShot::new, 0.25f, 0.25f, 150, 3), false);
    public static final RegistryObject<EntityType<MosquitoSwarm>> MOSQUITO_SWARM = TFEntities.make(TFEntityNames.MOSQUITO_SWARM, MosquitoSwarm::new, MobCategory.MONSTER, 0.7f, 1.9f, 526596, 2961185);
    public static final RegistryObject<EntityType<Naga>> NAGA = TFEntities.make(TFEntityNames.NAGA, Naga::new, MobCategory.MONSTER, 2.0f, 3.0f, true, 10801942, 1783819);
    public static final RegistryObject<EntityType<NatureBolt>> NATURE_BOLT = TFEntities.buildNoEgg(TFEntityNames.NATURE_BOLT, TFEntities.makeCastedBuilder(NatureBolt.class, NatureBolt::new, 0.25f, 0.25f, 150, 5), false);
    public static final RegistryObject<EntityType<MagicPainting>> MAGIC_PAINTING = TFEntities.buildNoEgg(TFEntityNames.MAGIC_PAINTING, TFEntities.makeCastedBuilder(MagicPainting.class, MagicPainting::new, 0.5f, 0.5f, 10, Integer.MAX_VALUE), false);
    public static final RegistryObject<EntityType<Penguin>> PENGUIN = TFEntities.make(TFEntityNames.PENGUIN, Penguin::new, MobCategory.CREATURE, 0.5f, 0.9f, 1185051, 16379346);
    public static final RegistryObject<EntityType<PinchBeetle>> PINCH_BEETLE = TFEntities.make(TFEntityNames.PINCH_BEETLE, PinchBeetle::new, MobCategory.MONSTER, 1.2f, 0.5f, 12358439, 2364937);
    public static final RegistryObject<EntityType<PlateauBoss>> PLATEAU_BOSS = TFEntities.make(TFEntityNames.PLATEAU_BOSS, PlateauBoss::new, MobCategory.MONSTER, 1.0f, 1.0f, true, 0, 0);
    public static final RegistryObject<EntityType<ProtectionBox>> PROTECTION_BOX = TFEntities.buildNoEgg(TFEntityNames.PROTECTION_BOX, TFEntities.makeCastedBuilder(ProtectionBox.class, ProtectionBox::new, 0.0f, 0.0f, 80, 3).m_20716_().m_20698_(), true);
    public static final RegistryObject<EntityType<QuestRam>> QUEST_RAM = TFEntities.make(TFEntityNames.QUEST_RAM, QuestRam::new, MobCategory.CREATURE, 1.25f, 2.9f, 0xFEFEEE, 0x33AADD);
    public static final RegistryObject<EntityType<Raven>> RAVEN = TFEntities.make(TFEntityNames.RAVEN, Raven::new, MobCategory.CREATURE, 0.3f, 0.5f, 17, 0x222233);
    public static final RegistryObject<EntityType<Redcap>> REDCAP = TFEntities.make(TFEntityNames.REDCAP, Redcap::new, MobCategory.MONSTER, 0.9f, 1.4f, 3881580, 11214356);
    public static final RegistryObject<EntityType<RedcapSapper>> REDCAP_SAPPER = TFEntities.make(TFEntityNames.REDCAP_SAPPER, RedcapSapper::new, MobCategory.MONSTER, 0.9f, 1.4f, 5725473, 11214356);
    public static final RegistryObject<EntityType<RisingZombie>> RISING_ZOMBIE = TFEntities.make(TFEntityNames.RISING_ZOMBIE, RisingZombie::new, MobCategory.MONSTER, 0.6f, 1.95f, 0, 0);
    public static final RegistryObject<EntityType<RovingCube>> ROVING_CUBE = TFEntities.make(TFEntityNames.ROVING_CUBE, RovingCube::new, MobCategory.MONSTER, 1.2f, 2.1f, 0, 0);
    public static final RegistryObject<EntityType<SeekerArrow>> SEEKER_ARROW = TFEntities.buildNoEgg(TFEntityNames.SEEKER_ARROW, TFEntities.makeCastedBuilder(SeekerArrow.class, SeekerArrow::new, 0.5f, 0.5f, 150, 1), false);
    public static final RegistryObject<EntityType<SkeletonDruid>> SKELETON_DRUID = TFEntities.make(TFEntityNames.SKELETON_DRUID, SkeletonDruid::new, MobCategory.MONSTER, 0.6f, 1.99f, 0xA3A3A3, 2767639);
    public static final RegistryObject<EntityType<SlideBlock>> SLIDER = TFEntities.buildNoEgg(TFEntityNames.SLIDER, TFEntities.makeCastedBuilder(SlideBlock.class, SlideBlock::new, 0.98f, 0.98f, 80, 1), false);
    public static final RegistryObject<EntityType<SlimeBeetle>> SLIME_BEETLE = TFEntities.make(TFEntityNames.SLIME_BEETLE, SlimeBeetle::new, MobCategory.MONSTER, 0.9f, 0.5f, 792070, 6334284);
    public static final RegistryObject<EntityType<SlimeProjectile>> SLIME_BLOB = TFEntities.buildNoEgg(TFEntityNames.SLIME_BLOB, TFEntities.makeCastedBuilder(SlimeProjectile.class, SlimeProjectile::new, 0.25f, 0.25f, 150, 3), false);
    public static final RegistryObject<EntityType<SnowGuardian>> SNOW_GUARDIAN = TFEntities.make(TFEntityNames.SNOW_GUARDIAN, SnowGuardian::new, MobCategory.MONSTER, 0.6f, 1.8f, 13887420, 0xFEFEFE);
    public static final RegistryObject<EntityType<SnowQueen>> SNOW_QUEEN = TFEntities.make(TFEntityNames.SNOW_QUEEN, SnowQueen::new, MobCategory.MONSTER, 0.7f, 2.2f, 11645652, 8847470);
    public static final RegistryObject<EntityType<Squirrel>> SQUIRREL = TFEntities.make(TFEntityNames.SQUIRREL, Squirrel::new, MobCategory.CREATURE, 0.3f, 0.5f, 9457426, 0xEEEEEE);
    public static final RegistryObject<EntityType<StableIceCore>> STABLE_ICE_CORE = TFEntities.make(TFEntityNames.STABLE_ICE_CORE, StableIceCore::new, MobCategory.MONSTER, 0.8f, 1.8f, 10600435, 7340280);
    public static final RegistryObject<EntityType<SwarmSpider>> SWARM_SPIDER = TFEntities.make(TFEntityNames.SWARM_SPIDER, SwarmSpider::new, MobCategory.MONSTER, 0.8f, 0.4f, 3277358, 1516830);
    public static final RegistryObject<EntityType<ThrownBlock>> THROWN_BLOCK = TFEntities.buildNoEgg(TFEntityNames.THROWN_BLOCK, TFEntities.makeCastedBuilder(ThrownBlock.class, ThrownBlock::new, 1.0f, 1.0f, 80, 2), true);
    public static final RegistryObject<EntityType<ThrownWep>> THROWN_WEP = TFEntities.make(TFEntityNames.THROWN_WEP, ThrownWep::new, MobCategory.MISC, 0.5f, 0.5f, 0, 0);
    public static final RegistryObject<EntityType<TinyBird>> TINY_BIRD = TFEntities.make(TFEntityNames.TINY_BIRD, TinyBird::new, MobCategory.CREATURE, 0.3f, 0.3f, 0x33AADD, 0x1188EE);
    public static final RegistryObject<EntityType<TomeBolt>> TOME_BOLT = TFEntities.buildNoEgg(TFEntityNames.TOME_BOLT, TFEntities.makeCastedBuilder(TomeBolt.class, TomeBolt::new, 0.25f, 0.25f, 150, 5), false);
    public static final RegistryObject<EntityType<TowerwoodBorer>> TOWERWOOD_BORER = TFEntities.make(TFEntityNames.TOWERWOOD_BORER, TowerwoodBorer::new, MobCategory.MONSTER, 0.4f, 0.3f, 6105889, 11313210);
    public static final RegistryObject<EntityType<Troll>> TROLL = TFEntities.make(TFEntityNames.TROLL, Troll::new, MobCategory.MONSTER, 1.4f, 2.4f, 10398095, 11572366);
    public static final RegistryObject<EntityType<TwilightWandBolt>> WAND_BOLT = TFEntities.buildNoEgg(TFEntityNames.WAND_BOLT, TFEntities.makeCastedBuilder(TwilightWandBolt.class, TwilightWandBolt::new, 0.25f, 0.25f, 150, 5), false);
    public static final RegistryObject<EntityType<UnstableIceCore>> UNSTABLE_ICE_CORE = TFEntities.make(TFEntityNames.UNSTABLE_ICE_CORE, UnstableIceCore::new, MobCategory.MONSTER, 0.8f, 1.8f, 10136821, 10162085);
    public static final RegistryObject<EntityType<UpperGoblinKnight>> UPPER_GOBLIN_KNIGHT = TFEntities.make(TFEntityNames.UPPER_GOBLIN_KNIGHT, UpperGoblinKnight::new, MobCategory.MONSTER, 1.1f, 1.3f, 0, 0);
    public static final RegistryObject<EntityType<UrGhast>> UR_GHAST = TFEntities.make(TFEntityNames.UR_GHAST, UrGhast::new, MobCategory.MONSTER, 14.0f, 18.0f, true, 0xBCBCBC, 0xB77878);
    public static final RegistryObject<EntityType<WinterWolf>> WINTER_WOLF = TFEntities.make(TFEntityNames.WINTER_WOLF, WinterWolf::new, MobCategory.MONSTER, 1.4f, 1.9f, 14672869, 11713738);
    public static final RegistryObject<EntityType<Wraith>> WRAITH = TFEntities.make(TFEntityNames.WRAITH, Wraith::new, MobCategory.MONSTER, 0.6f, 1.8f, true, 0x505050, 0x838383);
    public static final RegistryObject<EntityType<Yeti>> YETI = TFEntities.make(TFEntityNames.YETI, Yeti::new, MobCategory.MONSTER, 1.4f, 2.4f, 0xDEDEDE, 4617659);

    private static <E extends Entity> RegistryObject<EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, int primary, int secondary) {
        return TFEntities.make(id, factory, classification, width, height, false, primary, secondary);
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, boolean fireproof, int primary, int secondary) {
        return TFEntities.build(id, TFEntities.makeBuilder(factory, classification, width, height, 80, 3), fireproof, primary, secondary);
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> buildNoEgg(ResourceLocation id, EntityType.Builder<E> builder, boolean fireproof) {
        if (fireproof) {
            builder.m_20719_();
        }
        return ENTITIES.register(id.m_135815_(), () -> builder.m_20712_(id.toString()));
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> build(ResourceLocation id, EntityType.Builder<E> builder, boolean fireproof, int primary, int secondary) {
        if (fireproof) {
            builder.m_20719_();
        }
        RegistryObject ret = ENTITIES.register(id.m_135815_(), () -> builder.m_20712_(id.toString()));
        if (primary != 0 && secondary != 0) {
            SPAWN_EGGS.register(id.m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)ret.get(), primary, secondary, new Item.Properties()));
        }
        return ret;
    }

    private static <E extends Entity> EntityType.Builder<E> makeCastedBuilder(Class<E> cast, EntityType.EntityFactory<E> factory, float width, float height, int range, int interval) {
        return TFEntities.makeBuilder(factory, MobCategory.MISC, width, height, range, interval);
    }

    private static <E extends Entity> EntityType.Builder<E> makeBuilder(EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, int range, int interval) {
        return EntityType.Builder.m_20704_(factory, (MobCategory)classification).m_20699_(width, height).setTrackingRange(range).setUpdateInterval(interval).setShouldReceiveVelocityUpdates(true);
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)BOAR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BIGHORN_SHEEP.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DEER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)REDCAP.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SKELETON_DRUID.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SkeletonDruid::checkDruidSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)WRAITH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wraith::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HOSTILE_WOLF.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HostileWolf::checkWolfSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HYDRA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)LICH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)PENGUIN.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Penguin::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)LICH_MINION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)LOYAL_ZOMBIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)TINY_BIRD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SQUIRREL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DWARF_RABBIT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)RAVEN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)QUEST_RAM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)KOBOLD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)MOSQUITO_SWARM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DEATH_TOME.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)MINOTAUR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)MINOSHROOM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)FIRE_BEETLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SLIME_BEETLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)PINCH_BEETLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)MIST_WOLF.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_GHASTLING.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CarminiteGhastling::canSpawnHere, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_GOLEM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)TOWERWOOD_BORER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_GHASTGUARD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CarminiteGhastguard::ghastSpawnHandler, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)UR_GHAST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CarminiteGhastguard::ghastSpawnHandler, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BLOCKCHAIN_GOBLIN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)UPPER_GOBLIN_KNIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)LOWER_GOBLIN_KNIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HELMET_CRAB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)KNIGHT_PHANTOM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)NAGA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SWARM_SPIDER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SwarmSpider::getCanSpawnHere, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)KING_SPIDER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_BROODLING.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HEDGE_SPIDER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HedgeSpider::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)REDCAP_SAPPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)MAZE_SLIME.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MazeSlime::getCanSpawnHere, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)YETI.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Yeti::yetiSnowyForestSpawnHandler, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ALPHA_YETI.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)WINTER_WOLF.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WinterWolf::canSpawnHere, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SNOW_GUARDIAN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)STABLE_ICE_CORE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)UNSTABLE_ICE_CORE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SNOW_QUEEN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)TROLL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)GIANT_MINER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GiantMiner::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ARMORED_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GiantMiner::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ICE_CRYSTAL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HARBINGER_CUBE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ADHERENT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ROVING_CUBE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)RISING_ZOMBIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOAR.get(), Boar.registerAttributes().m_22265_());
        event.put((EntityType)BIGHORN_SHEEP.get(), Sheep.m_29873_().m_22265_());
        event.put((EntityType)DEER.get(), Deer.registerAttributes().m_22265_());
        event.put((EntityType)REDCAP.get(), Redcap.registerAttributes().m_22265_());
        event.put((EntityType)SWARM_SPIDER.get(), SwarmSpider.registerAttributes().m_22265_());
        event.put((EntityType)NAGA.get(), Naga.registerAttributes().m_22265_());
        event.put((EntityType)SKELETON_DRUID.get(), AbstractSkeleton.m_32166_().m_22265_());
        event.put((EntityType)HOSTILE_WOLF.get(), HostileWolf.registerAttributes().m_22265_());
        event.put((EntityType)WRAITH.get(), Wraith.registerAttributes().m_22265_());
        event.put((EntityType)HEDGE_SPIDER.get(), Spider.m_33815_().m_22265_());
        event.put((EntityType)HYDRA.get(), Hydra.registerAttributes().m_22265_());
        event.put((EntityType)LICH.get(), Lich.registerAttributes().m_22265_());
        event.put((EntityType)PENGUIN.get(), Penguin.registerAttributes().m_22265_());
        event.put((EntityType)LICH_MINION.get(), Zombie.m_34328_().m_22265_());
        event.put((EntityType)LOYAL_ZOMBIE.get(), LoyalZombie.registerAttributes().m_22265_());
        event.put((EntityType)TINY_BIRD.get(), TinyBird.registerAttributes().m_22265_());
        event.put((EntityType)SQUIRREL.get(), Squirrel.registerAttributes().m_22265_());
        event.put((EntityType)DWARF_RABBIT.get(), DwarfRabbit.registerAttributes().m_22265_());
        event.put((EntityType)RAVEN.get(), Raven.registerAttributes().m_22265_());
        event.put((EntityType)QUEST_RAM.get(), QuestRam.registerAttributes().m_22265_());
        event.put((EntityType)KOBOLD.get(), Kobold.registerAttributes().m_22265_());
        event.put((EntityType)MOSQUITO_SWARM.get(), MosquitoSwarm.registerAttributes().m_22265_());
        event.put((EntityType)DEATH_TOME.get(), DeathTome.registerAttributes().m_22265_());
        event.put((EntityType)MINOTAUR.get(), Minotaur.registerAttributes().m_22265_());
        event.put((EntityType)MINOSHROOM.get(), Minoshroom.registerAttributes().m_22265_());
        event.put((EntityType)FIRE_BEETLE.get(), FireBeetle.registerAttributes().m_22265_());
        event.put((EntityType)SLIME_BEETLE.get(), SlimeBeetle.registerAttributes().m_22265_());
        event.put((EntityType)PINCH_BEETLE.get(), PinchBeetle.registerAttributes().m_22265_());
        event.put((EntityType)MAZE_SLIME.get(), MazeSlime.registerAttributes().m_22265_());
        event.put((EntityType)REDCAP_SAPPER.get(), RedcapSapper.registerAttributes().m_22265_());
        event.put((EntityType)MIST_WOLF.get(), MistWolf.registerAttributes().m_22265_());
        event.put((EntityType)KING_SPIDER.get(), KingSpider.registerAttributes().m_22265_());
        event.put((EntityType)CARMINITE_GHASTLING.get(), CarminiteGhastling.registerAttributes().m_22265_());
        event.put((EntityType)CARMINITE_GHASTGUARD.get(), CarminiteGhastguard.registerAttributes().m_22265_());
        event.put((EntityType)CARMINITE_GOLEM.get(), CarminiteGolem.registerAttributes().m_22265_());
        event.put((EntityType)TOWERWOOD_BORER.get(), TowerwoodBorer.registerAttributes().m_22265_());
        event.put((EntityType)CARMINITE_BROODLING.get(), TowerBroodling.registerAttributes().m_22265_());
        event.put((EntityType)UR_GHAST.get(), UrGhast.registerAttributes().m_22265_());
        event.put((EntityType)BLOCKCHAIN_GOBLIN.get(), BlockChainGoblin.registerAttributes().m_22265_());
        event.put((EntityType)UPPER_GOBLIN_KNIGHT.get(), UpperGoblinKnight.registerAttributes().m_22265_());
        event.put((EntityType)LOWER_GOBLIN_KNIGHT.get(), LowerGoblinKnight.registerAttributes().m_22265_());
        event.put((EntityType)HELMET_CRAB.get(), HelmetCrab.registerAttributes().m_22265_());
        event.put((EntityType)KNIGHT_PHANTOM.get(), KnightPhantom.registerAttributes().m_22265_());
        event.put((EntityType)YETI.get(), Yeti.registerAttributes().m_22265_());
        event.put((EntityType)ALPHA_YETI.get(), AlphaYeti.registerAttributes().m_22265_());
        event.put((EntityType)WINTER_WOLF.get(), WinterWolf.registerAttributes().m_22265_());
        event.put((EntityType)SNOW_GUARDIAN.get(), SnowGuardian.registerAttributes().m_22265_());
        event.put((EntityType)STABLE_ICE_CORE.get(), StableIceCore.registerAttributes().m_22265_());
        event.put((EntityType)UNSTABLE_ICE_CORE.get(), UnstableIceCore.registerAttributes().m_22265_());
        event.put((EntityType)SNOW_QUEEN.get(), SnowQueen.registerAttributes().m_22265_());
        event.put((EntityType)TROLL.get(), Troll.registerAttributes().m_22265_());
        event.put((EntityType)GIANT_MINER.get(), GiantMiner.registerAttributes().m_22265_());
        event.put((EntityType)ARMORED_GIANT.get(), GiantMiner.registerAttributes().m_22265_());
        event.put((EntityType)ICE_CRYSTAL.get(), IceCrystal.registerAttributes().m_22265_());
        event.put((EntityType)HARBINGER_CUBE.get(), HarbingerCube.registerAttributes().m_22265_());
        event.put((EntityType)ADHERENT.get(), Adherent.registerAttributes().m_22265_());
        event.put((EntityType)ROVING_CUBE.get(), RovingCube.registerAttributes().m_22265_());
        event.put((EntityType)PLATEAU_BOSS.get(), PlateauBoss.registerAttributes().m_22265_());
        event.put((EntityType)RISING_ZOMBIE.get(), Zombie.m_34328_().m_22265_());
    }
}

