/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;

public enum Diagonals implements StringRepresentable
{
    TOP_RIGHT((x, rX) -> rX - x, (y, rY) -> y, true, false),
    BOTTOM_RIGHT((x, rX) -> rX - x, (y, rY) -> rY - y, false, false),
    BOTTOM_LEFT((x, rX) -> x, (y, rY) -> rY - y, false, true),
    TOP_LEFT((x, rX) -> x, (y, rY) -> y, true, true);

    public final Inversion operationX;
    public final Inversion operationY;
    private final boolean isTop;
    private final boolean isLeft;

    private Diagonals(Inversion operationX, Inversion operationY, boolean isTop, boolean isLeft) {
        this.operationX = operationX;
        this.operationY = operationY;
        this.isTop = isTop;
        this.isLeft = isLeft;
    }

    public static Diagonals getDiagonalFromUpDownLeftRight(boolean isLeft, boolean isTop) {
        if (isLeft) {
            return isTop ? TOP_LEFT : BOTTOM_LEFT;
        }
        return isTop ? TOP_RIGHT : BOTTOM_RIGHT;
    }

    public static Diagonals rotate(Diagonals diagonal, Rotation rotation) {
        return Diagonals.values()[(diagonal.ordinal() + rotation.ordinal()) % 4];
    }

    public static Diagonals mirrorOn(Direction.Axis axis, Diagonals diagonal, Mirror mirror) {
        return switch (axis) {
            case Direction.Axis.X -> Diagonals.mirrorOnX(diagonal, mirror);
            case Direction.Axis.Z -> Diagonals.mirrorOnZ(diagonal, mirror);
            default -> Diagonals.mirror(diagonal, mirror);
        };
    }

    public static Diagonals mirrorOnX(Diagonals diagonal, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            return switch (diagonal) {
                default -> throw new IncompatibleClassChangeError();
                case TOP_RIGHT -> BOTTOM_RIGHT;
                case BOTTOM_RIGHT -> TOP_RIGHT;
                case BOTTOM_LEFT -> TOP_LEFT;
                case TOP_LEFT -> BOTTOM_LEFT;
            };
        }
        return diagonal;
    }

    public static Diagonals mirrorLeftRight(Diagonals diagonal) {
        return switch (diagonal) {
            default -> throw new IncompatibleClassChangeError();
            case TOP_RIGHT -> TOP_LEFT;
            case BOTTOM_RIGHT -> BOTTOM_LEFT;
            case BOTTOM_LEFT -> BOTTOM_RIGHT;
            case TOP_LEFT -> TOP_RIGHT;
        };
    }

    public static Diagonals mirrorUpDown(Diagonals diagonal) {
        return switch (diagonal) {
            default -> throw new IncompatibleClassChangeError();
            case TOP_RIGHT -> BOTTOM_RIGHT;
            case BOTTOM_RIGHT -> TOP_RIGHT;
            case BOTTOM_LEFT -> TOP_LEFT;
            case TOP_LEFT -> BOTTOM_LEFT;
        };
    }

    public static Diagonals mirror(Diagonals diagonal, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> Diagonals.mirrorLeftRight(diagonal);
            case Mirror.FRONT_BACK -> Diagonals.mirrorUpDown(diagonal);
            default -> diagonal;
        };
    }

    public static Diagonals mirrorOnZ(Diagonals diagonal, Mirror mirror) {
        if (mirror == Mirror.LEFT_RIGHT) {
            return switch (diagonal) {
                default -> throw new IncompatibleClassChangeError();
                case TOP_RIGHT -> TOP_LEFT;
                case BOTTOM_RIGHT -> BOTTOM_LEFT;
                case BOTTOM_LEFT -> BOTTOM_RIGHT;
                case TOP_LEFT -> TOP_RIGHT;
            };
        }
        return diagonal;
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isTop() {
        return this.isTop;
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public static interface Inversion {
        public int convert(int var1, int var2);
    }
}

