/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.goal.QuestRamEatWoolGoal;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;

public class QuestRam
extends Animal
implements EnforcedHomePoint {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(QuestRam.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_REWARDED = SynchedEntityData.m_135353_(QuestRam.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POINT = SynchedEntityData.m_135353_(QuestRam.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private int randomTickDivider = 0;

    public QuestRam(EntityType<? extends QuestRam> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.38f));
        this.f_21345_.m_25352_(2, (Goal)new QuestRamEatWoolGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_((TagKey)ItemTags.f_13167_), false));
        this.addRestrictionGoals((PathfinderMob)this, this.f_21345_);
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    @Nullable
    public Animal getBreedOffspring(ServerLevel level, AgeableMob mate) {
        return null;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22279_, 0.23);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_COLOR, (Object)0);
        this.m_20088_().m_135372_(DATA_REWARDED, (Object)false);
        this.m_20088_().m_135372_(HOME_POINT, Optional.empty());
    }

    protected void m_8024_() {
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 70 + this.m_217043_().m_188503_(50);
            if (this.countColorsSet() > 15 && !this.getRewarded()) {
                this.rewardQuest();
                this.setRewarded(true);
            }
        }
        if (this.countColorsSet() > 15 && !this.getRewarded()) {
            this.animateAddColor(DyeColor.m_41053_((int)this.m_217043_().m_188503_(16)), 5);
            this.m_8032_();
        }
        super.m_8024_();
    }

    private void rewardQuest() {
        LootParams ctx = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81417_);
        ObjectArrayList rewards = this.m_9236_().m_7654_().m_278653_().m_278676_(TFLootTables.QUESTING_RAM_REWARDS).m_287195_(ctx);
        rewards.forEach(stack -> this.m_5552_((ItemStack)stack, 1.0f));
        for (ServerPlayer player : this.m_9236_().m_45976_(ServerPlayer.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0))) {
            TFAdvancements.QUEST_RAM_COMPLETED.trigger(player);
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack currentItem = player.m_21120_(hand);
        if (this.tryAccept(currentItem)) {
            if (!player.m_150110_().f_35937_) {
                currentItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    public boolean tryAccept(ItemStack stack) {
        DyeColor color;
        if (stack.m_204117_(ItemTags.f_13167_) && (color = this.guessColor(stack)) != null && !this.isColorPresent(color)) {
            this.setColorPresent(color);
            this.animateAddColor(color, 50);
            this.m_8032_();
            return true;
        }
        return false;
    }

    @Nullable
    public DyeColor guessColor(ItemStack stack) {
        Item item;
        if (stack.m_204117_(ItemTags.f_13167_) && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            MapColor color = blockItem.m_40614_().m_284356_();
            for (DyeColor dye : DyeColor.values()) {
                if (color != dye.m_284406_()) continue;
                return dye;
            }
        }
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ColorFlags", this.getColorFlags());
        compound.m_128379_("Rewarded", this.getRewarded());
        this.saveHomePointToNbt(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColorFlags(compound.m_128451_("ColorFlags"));
        this.setRewarded(compound.m_128471_("Rewarded"));
        this.loadHomePointFromNbt(compound);
    }

    public int getColorFlags() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR);
    }

    private void setColorFlags(int flags) {
        this.m_20088_().m_135381_(DATA_COLOR, (Object)flags);
    }

    public boolean isColorPresent(DyeColor color) {
        return (this.getColorFlags() & 1 << color.m_41060_()) > 0;
    }

    public void setColorPresent(DyeColor color) {
        this.setColorFlags(this.getColorFlags() | 1 << color.m_41060_());
    }

    public boolean getRewarded() {
        return (Boolean)this.m_20088_().m_135370_(DATA_REWARDED);
    }

    public void setRewarded(boolean rewarded) {
        this.m_20088_().m_135381_(DATA_REWARDED, (Object)rewarded);
    }

    private void animateAddColor(DyeColor color, int iterations) {
        float[] colorVal = color.m_41068_();
        float red = colorVal[0];
        float green = colorVal[1];
        float blue = colorVal[2];
        if (!this.m_9236_().m_5776_()) {
            for (ServerPlayer serverplayer : ((ServerLevel)this.m_9236_()).m_6907_()) {
                if (!(serverplayer.m_20238_(Vec3.m_82512_((Vec3i)this.m_20183_())) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < iterations; ++i) {
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123811_, false, this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 1.5, this.m_20186_() + this.m_217043_().m_188500_() * (double)this.m_20206_() * 1.5, this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 1.5, red, green, blue);
                }
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverplayer), (Object)packet);
            }
        }
    }

    public int countColorsSet() {
        return Integer.bitCount(this.getColorFlags());
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public float m_6100_() {
        return (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 0.7f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.QUEST_RAM_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.QUEST_RAM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.QUEST_RAM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)TFSounds.QUEST_RAM_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public GlobalPos getRestrictionPoint() {
        return ((Optional)this.m_20088_().m_135370_(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 13;
    }
}

