/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.fml.loading.FMLLoader;
import twilightforest.command.TFCommand;
import twilightforest.util.LandmarkUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.components.structures.util.LandmarkStructure;
import twilightforest.world.registration.TFGenerationSettings;

public class InfoCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"info").requires(cs -> cs.m_6761_(2))).executes(InfoCommand::run);
    }

    private static int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Structure structure;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.m_81372_();
        if (!TFGenerationSettings.usesTwilightChunkGenerator(level)) {
            throw TFCommand.NOT_IN_TF.create();
        }
        BlockPos pos = BlockPos.m_274446_((Position)source.m_81371_());
        Optional possibleStructureRegistry = level.m_9598_().m_6632_(Registries.f_256944_);
        Optional<StructureStart> possibleNearLandmark = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)level, SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
        if (possibleStructureRegistry.isEmpty() || possibleNearLandmark.isEmpty() || !((structure = possibleNearLandmark.get().m_226861_()) instanceof LandmarkStructure)) {
            return 0;
        }
        LandmarkStructure landmarkStructure = (LandmarkStructure)structure;
        StructureStart structureStart = possibleNearLandmark.get();
        ResourceLocation key = ((Registry)possibleStructureRegistry.get()).m_7981_((Object)landmarkStructure);
        if (FMLLoader.isProduction()) {
            source.m_288197_(() -> Component.m_237115_((String)"This command is still WIP, some things may still be broken.").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
        }
        String structureName = Component.m_237115_((String)("structure." + key.m_135827_() + "." + key.m_135815_())).getString();
        source.m_288197_(() -> Component.m_237110_((String)"commands.tffeature.nearest", (Object[])new Object[]{structureName}), false);
        if (structureStart.m_73601_().m_71051_((Vec3i)pos)) {
            source.m_288197_(() -> Component.m_237115_((String)"commands.tffeature.structure.inside").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), false);
            if (structureStart instanceof TFStructureStart) {
                TFStructureStart tfStructureStart = (TFStructureStart)structureStart;
                source.m_288197_(() -> Component.m_237110_((String)"commands.tffeature.structure.conquer.status", (Object[])new Object[]{tfStructureStart.isConquered()}).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, tfStructureStart.isConquered() ? ChatFormatting.GREEN : ChatFormatting.RED}), false);
            }
            List<MobSpawnSettings.SpawnerData> spawnList = ChunkGeneratorTwilight.gatherPotentialSpawns(null, level.m_215010_(), MobCategory.MONSTER, pos);
            source.m_288197_(() -> Component.m_237115_((String)"commands.tffeature.structure.spawn_list").m_130940_(ChatFormatting.UNDERLINE), false);
            if (spawnList != null) {
                for (MobSpawnSettings.SpawnerData entry : spawnList) {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.tffeature.structure.spawn_info", (Object[])new Object[]{entry.f_48404_.m_20676_().getString(), entry.m_142631_().m_146281_()}), false);
                }
            }
        } else {
            source.m_288197_(() -> Component.m_237115_((String)"commands.tffeature.structure.outside").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), false);
        }
        return 1;
    }
}

