/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;

public class GrowingBeanstalkBlockEntity
extends BlockEntity {
    private int ticker;
    private int layer;
    private boolean isAreaClearEnough = true;
    private int nextLeafY;
    private int yOffset;
    private float cScale;
    private float rScale;
    private int maxY;
    private int blocksSkipped;

    public GrowingBeanstalkBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.BEANSTALK_GROWER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GrowingBeanstalkBlockEntity te) {
        ++te.ticker;
        if (te.ticker == 1) {
            te.nextLeafY = pos.m_123342_() + 10 + level.m_213780_().m_188503_(10);
            te.yOffset = level.m_213780_().m_188503_(100);
            te.cScale = level.m_213780_().m_188501_() * 0.25f + 0.125f;
            te.rScale = level.m_213780_().m_188501_() * 0.25f + 0.125f;
            te.maxY = Math.max(pos.m_123342_() + 100, 175);
        }
        if (level.m_5776_()) {
            if (te.ticker < 100) {
                for (int i = 0; i < 20; ++i) {
                    float x = (float)pos.m_123341_() + level.m_213780_().m_188501_() + (float)(level.m_213780_().m_188503_(5) * (level.m_213780_().m_188499_() ? -1 : 1));
                    float z = (float)pos.m_123343_() + level.m_213780_().m_188501_() + (float)(level.m_213780_().m_188503_(5) * (level.m_213780_().m_188499_() ? -1 : 1));
                    BlockState underState = level.m_8055_(BlockPos.m_274561_((double)x, (double)pos.m_7495_().m_123342_(), (double)z));
                    if (!underState.m_280296_()) continue;
                    level.m_7107_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, underState), (double)x, (double)pos.m_123342_(), (double)z, 0.0, 0.0, 0.0);
                }
            }
        } else if (te.ticker > 100 && te.ticker % 2 == 0) {
            int layerYPos = pos.m_123342_() + te.layer;
            if (te.isAreaClearEnough && layerYPos < te.maxY) {
                float x = pos.m_123341_();
                float z = pos.m_123343_();
                float radius = 4.0f + Mth.m_14031_((float)((float)(pos.m_123342_() + te.yOffset) * te.rScale)) * 3.0f;
                x -= Mth.m_14031_((float)((float)(pos.m_123342_() + te.yOffset) * te.cScale)) * radius;
                z -= Mth.m_14089_((float)((float)(pos.m_123342_() + te.yOffset) * te.cScale)) * radius;
                radius = 5.0f + Mth.m_14031_((float)((float)(layerYPos + te.yOffset) * te.rScale)) * 2.5f;
                float cx = x + Mth.m_14031_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float cz = z + Mth.m_14089_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float stalkThickness = 2.5f;
                if (te.maxY - layerYPos < 5) {
                    stalkThickness *= (float)(te.maxY - layerYPos) / 5.0f;
                }
                int minX = Mth.m_14143_((float)(x - radius - stalkThickness));
                int maxX = Mth.m_14167_((float)(x + radius + stalkThickness));
                int minZ = Mth.m_14143_((float)(z - radius - stalkThickness));
                int maxZ = Mth.m_14167_((float)(z + radius + stalkThickness));
                for (int dx = minX; dx < maxX && te.isAreaClearEnough; ++dx) {
                    for (int dz = minZ; dz < maxZ && te.isAreaClearEnough; ++dz) {
                        float circle = ((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz);
                        if (!(circle < stalkThickness * stalkThickness)) continue;
                        te.isAreaClearEnough = te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos, dz), true);
                        if (!(circle < stalkThickness)) continue;
                        te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos + 1, dz), false);
                        if (!(circle < stalkThickness / 2.0f)) continue;
                        te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos + 2, dz), false);
                    }
                }
                te.blocksSkipped = 0;
                if (layerYPos == te.nextLeafY) {
                    boolean wasAnEvenNumber = te.nextLeafY % 2 == 0;
                    float v = radius + (wasAnEvenNumber ? stalkThickness : -stalkThickness);
                    int lx = (int)(x + Mth.m_14031_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    int lz = (int)(z + Mth.m_14089_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    te.placeLeaves(level, new BlockPos(lx, layerYPos, lz));
                    te.nextLeafY = layerYPos + 5 + level.m_213780_().m_188503_(10);
                    if (te.nextLeafY % 2 == 0 == wasAnEvenNumber) {
                        ++te.nextLeafY;
                    }
                }
                ++te.layer;
            } else {
                level.m_46597_(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).m_49966_());
                level.m_46747_(pos);
            }
        }
    }

    private void placeLeaves(Level world, BlockPos pos) {
        int dz;
        int dx;
        world.m_46597_(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).m_49966_());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                int distance = Math.abs(dx) + Math.abs(dz) + 1;
                this.tryToPlaceLeaves(world, pos.m_7918_(dx, -1, dz), distance);
                this.tryToPlaceLeaves(world, pos.m_7918_(dx, 1, dz), distance);
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if ((dx == 2 || dx == -2) && (dz == 2 || dz == -2)) continue;
                this.tryToPlaceLeaves(world, pos.m_7918_(dx, 0, dz), Math.max(Math.abs(dx) + Math.abs(dz), 1));
            }
        }
    }

    private boolean tryToPlaceStalk(Level level, BlockPos pos, boolean checkBlocked) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_() || state.m_247087_() && !state.m_60713_((Block)TFBlocks.BEANSTALK_GROWER.get()) || state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_60734_().equals(TFBlocks.FLUFFY_CLOUD.get())) {
            level.m_46597_(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).m_49966_());
            if (pos.m_123342_() > 150) {
                for (int i = 0; i < 7; ++i) {
                    if (!level.m_8055_(pos.m_5484_(Direction.UP, i)).m_60713_((Block)TFBlocks.WISPY_CLOUD.get()) && !level.m_8055_(pos.m_5484_(Direction.UP, i)).m_60713_((Block)TFBlocks.FLUFFY_CLOUD.get())) continue;
                    level.m_46597_(pos.m_5484_(Direction.UP, i), Blocks.f_50016_.m_49966_());
                }
            }
            return true;
        }
        if (!state.m_60713_((Block)TFBlocks.HUGE_STALK.get()) && checkBlocked) {
            ++this.blocksSkipped;
        }
        return this.blocksSkipped < 15;
    }

    private void tryToPlaceLeaves(Level world, BlockPos pos, int distance) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() || state.m_204336_(BlockTags.f_13035_)) {
            world.m_7731_(pos, (BlockState)((Block)TFBlocks.BEANSTALK_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(distance)), 2);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("ticker", this.ticker);
        compoundTag.m_128405_("layer", this.layer);
        compoundTag.m_128379_("isAreaClearEnough", this.isAreaClearEnough);
        compoundTag.m_128405_("nextLeafY", this.nextLeafY);
        compoundTag.m_128405_("yOffset", this.yOffset);
        compoundTag.m_128350_("cScale", this.cScale);
        compoundTag.m_128350_("rScale", this.rScale);
        compoundTag.m_128405_("maxY", this.maxY);
        compoundTag.m_128405_("blocksSkipped", this.blocksSkipped);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.ticker = compoundTag.m_128451_("ticker");
        this.layer = compoundTag.m_128451_("layer");
        this.isAreaClearEnough = compoundTag.m_128471_("isAreaClearEnough");
        this.nextLeafY = compoundTag.m_128451_("nextLeafY");
        this.yOffset = compoundTag.m_128451_("yOffset");
        this.cScale = compoundTag.m_128457_("cScale");
        this.rScale = compoundTag.m_128457_("rScale");
        this.maxY = compoundTag.m_128451_("maxY");
        this.blocksSkipped = compoundTag.m_128451_("blocksSkipped");
    }

    public boolean isBeanstalkRumbling() {
        return this.ticker < 110;
    }
}

