/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.data;

import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import me.vierdant.playeremotes.util.StringUtil;
import net.minecraft.resources.ResourceLocation;

public class Animation {
    public ResourceLocation id;
    public boolean excludeHead;
    public boolean firstPersonOption;
    public boolean provideIcon;
    public String name;
    public String description;
    public String author;
    public HashMap<String, String[]> animationList;
    private BiFunction<Animation, Object, Animation> conditionalFunction;

    public Animation(String namespace, String id, boolean excludeHead) {
        this(namespace, id, excludeHead, id, "A playable animation");
    }

    public Animation(String namespace, String id, boolean excludeHead, String name, String description) {
        this(namespace, id, excludeHead, name, description, "");
    }

    public Animation(String namespace, String id, boolean excludeHead, String name, String description, String author) {
        this.id = new ResourceLocation(namespace, id);
        this.excludeHead = excludeHead;
        this.name = StringUtil.capitalizeFirstLetterOfWords(name, true);
        this.description = description;
        this.author = author;
        this.firstPersonOption = false;
        this.provideIcon = false;
        this.animationList = new HashMap();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFirstPersonOption(boolean bl) {
        this.firstPersonOption = bl;
    }

    public void populateAnimationList(Consumer<Animation> consumer) {
        if (consumer != null) {
            consumer.accept(this);
        }
    }

    public void populateAnimationList(String ... list) {
        this.animationList.put("default", list);
    }

    public void setConditionalFunction(BiFunction<Animation, Object, Animation> function) {
        this.conditionalFunction = function;
    }

    public ResourceLocation getIconIdentifier() {
        return new ResourceLocation(this.provideIcon ? this.id.m_135827_() : "playeremotes", "textures/gui/icons/" + this.id.m_135815_() + ".png");
    }

    public Animation getConditionalAnimation(Object context) {
        if (this.conditionalFunction != null) {
            return this.conditionalFunction.apply(this, context);
        }
        return this;
    }
}

