/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetIcon;
import fi.dy.masa.malilib.render.RenderUtils;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.GuiGraphics;

public class WidgetSearchBar
extends WidgetBase {
    protected final WidgetIcon iconSearch;
    protected final LeftRight iconAlignment;
    protected final GuiTextFieldGeneric searchBox;
    protected boolean searchOpen;

    public WidgetSearchBar(int x, int y, int width, int height, int searchBarOffsetX, IGuiIcon iconSearch, LeftRight iconAlignment) {
        super(x, y, width, height);
        int iw = iconSearch.getWidth();
        int ix = iconAlignment == LeftRight.RIGHT ? x + width - iw - 1 : x + 2;
        int tx = iconAlignment == LeftRight.RIGHT ? x - searchBarOffsetX + 1 : x + iw + 6 + searchBarOffsetX;
        this.iconSearch = new WidgetIcon(ix, y + 1, iconSearch);
        this.iconAlignment = iconAlignment;
        this.searchBox = new GuiTextFieldGeneric(tx, y, width - iw - 7 - Math.abs(searchBarOffsetX), height, this.textRenderer);
        this.searchBox.setZLevel(this.zLevel);
    }

    public String getFilter() {
        return this.searchOpen ? this.searchBox.m_94155_().toLowerCase() : "";
    }

    public boolean hasFilter() {
        return this.searchOpen && !this.searchBox.m_94155_().isEmpty();
    }

    public boolean isSearchOpen() {
        return this.searchOpen;
    }

    public void setSearchOpen(boolean isOpen) {
        this.searchOpen = isOpen;
        if (this.searchOpen) {
            this.searchBox.m_93692_(true);
        }
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (this.searchOpen && this.searchBox.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.iconSearch.isMouseOver(mouseX, mouseY)) {
            this.setSearchOpen(!this.searchOpen);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        if (this.searchOpen) {
            if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 256) {
                if (GuiBase.isShiftDown()) {
                    this.mc.f_91080_.m_7379_();
                }
                this.searchOpen = false;
                this.searchBox.m_93692_(false);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        if (this.searchOpen) {
            if (this.searchBox.m_5534_(charIn, modifiers)) {
                return true;
            }
        } else if (SharedConstants.m_136188_((char)charIn)) {
            this.searchOpen = true;
            this.searchBox.m_93692_(true);
            this.searchBox.m_94144_("");
            this.searchBox.m_5534_(charIn, modifiers);
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, GuiGraphics drawContext) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.iconSearch.render(false, this.iconSearch.isMouseOver(mouseX, mouseY));
        if (this.searchOpen) {
            this.searchBox.m_88315_(drawContext, mouseX, mouseY, 0.0f);
        }
    }
}

