/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IStringListConsumer;
import fi.dy.masa.malilib.gui.widgets.WidgetListStringSelection;
import fi.dy.masa.malilib.gui.widgets.WidgetStringListEntry;
import fi.dy.masa.malilib.interfaces.IStringListProvider;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collection;

public class GuiStringListSelection
extends GuiListBase<String, WidgetStringListEntry, WidgetListStringSelection>
implements IStringListProvider {
    protected final ImmutableList<String> strings;
    protected final IStringListConsumer consumer;

    public GuiStringListSelection(Collection<String> strings, IStringListConsumer consumer) {
        super(10, 30);
        this.strings = ImmutableList.copyOf(strings);
        this.consumer = consumer;
    }

    @Override
    protected int getBrowserWidth() {
        return this.f_96543_ - 20;
    }

    @Override
    protected int getBrowserHeight() {
        return this.f_96544_ - 60;
    }

    @Override
    public Collection<String> getStrings() {
        return this.strings;
    }

    @Override
    protected WidgetListStringSelection createListWidget(int listX, int listY) {
        return new WidgetListStringSelection(listX, listY, this.getBrowserWidth(), this.getBrowserHeight(), this);
    }

    @Override
    public void initGui() {
        super.initGui();
        int x = 12;
        int y = this.f_96544_ - 32;
        x += this.createButton(x, y, -1, ButtonListener.Type.OK) + 2;
        x += this.createButton(x, y, -1, ButtonListener.Type.CANCEL) + 2;
    }

    private int createButton(int x, int y, int width, ButtonListener.Type type) {
        ButtonListener listener = new ButtonListener(type, this);
        String label = type.getDisplayName(new Object[0]);
        if (width == -1) {
            width = this.getStringWidth(label) + 10;
        }
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, label, new String[0]);
        this.addButton(button, listener);
        return width;
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final GuiStringListSelection parent;
        private final Type type;

        public ButtonListener(Type type, GuiStringListSelection parent) {
            this.parent = parent;
            this.type = type;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.OK) {
                this.parent.consumer.consume(((WidgetListStringSelection)this.parent.getListWidget()).getSelectedEntries());
            } else {
                GuiBase.openGui(this.parent.getParent());
            }
        }

        public static enum Type {
            OK("malilib.gui.button.ok"),
            CANCEL("malilib.gui.button.cancel");

            private final String translationKey;

            private Type(String translationKey) {
                this.translationKey = translationKey;
            }

            public String getDisplayName(Object ... args) {
                return StringUtils.translate(this.translationKey, args);
            }
        }
    }
}

