/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.tech.AdvancedCrystalInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech.CrystalInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blocks.tech.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.CommonTransmissionConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.StatisticsInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.items.StargateIrisItem;
import net.povstalec.sgjourney.common.items.StargateShieldItem;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundStargateParticleSpawnPacket;
import net.povstalec.sgjourney.common.packets.ClientboundStargateStateUpdatePacket;
import net.povstalec.sgjourney.common.packets.ClientboundStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Dialing;
import net.povstalec.sgjourney.common.stargate.Galaxy;
import net.povstalec.sgjourney.common.stargate.ITransmissionReceiver;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateBlockCover;
import net.povstalec.sgjourney.common.stargate.StargateConnection;
import net.povstalec.sgjourney.common.stargate.Symbols;
import net.povstalec.sgjourney.common.stargate.Wormhole;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStargateEntity
extends EnergyBlockEntity
implements ITransmissionReceiver {
    public static final String EMPTY = StargateJourney.EMPTY;
    public static final String ADD_TO_NETWORK = "AddToNetwork";
    public static final String ID = "ID";
    public static final String ID_9_CHEVRON_ADDRESS = "9ChevronAddress";
    public static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    public static final String EVENT_RESET = "stargate_reset";
    public static final String EVENT_MESSAGE_RECEIVED = "stargate_message_received";
    public static final String ADDRESS = "Address";
    public static final String DHD_POS = "DHDPos";
    public static final String ENERGY = "Energy";
    public static final String IRIS_PROGRESS = "IrisProgress";
    public static final String SHIELD_PROGRESS = "ShieldProgress";
    public static final String CONNECTION_ID = "ConnectionID";
    public static final String NETWORK = "Network";
    public static final String RESTRICT_NETWORK = "RestrictNetwork";
    public static final String TIMES_OPENED = "TimesOpened";
    public static final String AUTOCLOSE = "Autoclose";
    public static final String FILTER_TYPE = "FilterType";
    public static final String WHITELIST = "Whitelist";
    public static final String BLACKLIST = "Blacklist";
    public static final String UPGRADED = "Upgraded";
    public static final String DISPLAY_ID = "DisplayID";
    public static final String VARIANT = "Variant";
    public static final String POINT_OF_ORIGIN = "PointOfOrigin";
    public static final String SYMBOLS = "Symbols";
    public static final String COVER_BLOCKS = "CoverBlocks";
    public static final String IRIS_INVENTORY = "IrisInventory";
    public static final String SHIELD_INVENTORY = "ShieldInventory";
    public static final boolean FORCE_LOAD_CHUNK = (Boolean)CommonStargateConfig.stargate_loads_chunk_when_connected.get();
    public static final float STANDARD_THICKNESS = 9.0f;
    public static final float VERTICAL_CENTER_STANDARD_HEIGHT = 0.5f;
    public static final float HORIZONTAL_CENTER_STANDARD_HEIGHT = 0.28125f;
    protected Address id9ChevronAddress = new Address();
    protected boolean addToNetwork = true;
    protected final Stargate.Gen generation;
    protected int symbolBounds = 38;
    protected int network;
    protected boolean restrictNetwork = false;
    protected BlockPos centerPosition;
    protected Direction direction;
    protected Orientation orientation;
    protected Stargate.Feedback recentFeedback = Stargate.Feedback.NONE;
    protected int kawooshTick = 0;
    protected int animationTick = 0;
    protected int[] engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
    protected int timesOpened = 0;
    protected String pointOfOrigin = EMPTY;
    protected String symbols = EMPTY;
    protected String variant = EMPTY;
    private final ResourceLocation defaultVariant;
    protected Address address = new Address();
    protected String connectionID = EMPTY;
    protected Wormhole wormhole = new Wormhole();
    protected Optional<AbstractDHDEntity> dhd = Optional.empty();
    protected Optional<Vec3i> dhdRelativePos = Optional.empty();
    protected int autoclose = 0;
    protected int openSoundLead = 28;
    protected float verticalCenterHeight;
    protected float horizontalCenterHeight;
    public SoundWrapper wormholeIdleSound = null;
    public SoundWrapper wormholeOpenSound = null;
    public SoundWrapper spinSound = null;
    protected boolean displayID = false;
    protected boolean upgraded = false;
    private boolean initialClientSync = false;
    private Stargate.FilterType filter = Stargate.FilterType.NONE;
    private ArrayList<Address.Immutable> whitelist = new ArrayList();
    private ArrayList<Address.Immutable> blacklist = new ArrayList();
    public StargateBlockCover blockCover = new StargateBlockCover(StargatePart.DEFAULT_PARTS);
    protected short irisProgress = 0;
    protected short oldIrisProgress = 0;
    protected final ItemStackHandler irisItemHandler = this.createIrisHandler();

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, Stargate.Gen gen, int defaultNetwork, float verticalCenterHeight, float horizontalCenterHeight) {
        super(blockEntity, pos, state);
        this.defaultVariant = defaultVariant;
        this.generation = gen;
        this.network = defaultNetwork;
        this.verticalCenterHeight = verticalCenterHeight;
        this.horizontalCenterHeight = horizontalCenterHeight;
    }

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, Stargate.Gen gen, int defaultNetwork) {
        this(blockEntity, defaultVariant, pos, state, gen, defaultNetwork, 0.5f, 0.28125f);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.addToNetwork) {
            this.addStargateToNetwork();
        }
        this.updateClientState();
        this.loadDHD();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.deserializeStargateInfo(tag, false);
    }

    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        super.m_142466_(tag);
        this.timesOpened = tag.m_128451_(TIMES_OPENED);
        this.address.fromArray(tag.m_128465_(ADDRESS));
        this.network = tag.m_128451_(NETWORK);
        this.restrictNetwork = tag.m_128471_(RESTRICT_NETWORK);
        this.connectionID = tag.m_128461_(CONNECTION_ID);
        if (tag.m_128441_(ID)) {
            this.id9ChevronAddress.fromString(tag.m_128461_(ID));
        } else {
            this.id9ChevronAddress.fromArray(tag.m_128465_(ID_9_CHEVRON_ADDRESS));
        }
        this.addToNetwork = tag.m_128471_(ADD_TO_NETWORK);
        this.displayID = tag.m_128471_(DISPLAY_ID);
        this.upgraded = isUpgraded ? true : tag.m_128471_(UPGRADED);
        this.variant = tag.m_128461_(VARIANT);
        if (tag.m_128441_(DHD_POS)) {
            int[] pos = tag.m_128465_(DHD_POS);
            this.dhdRelativePos = Optional.of(new Vec3i(pos[0], pos[1], pos[2]));
        }
        this.autoclose = tag.m_128451_(AUTOCLOSE);
        this.deserializeFilters(tag);
        this.blockCover.deserializeNBT(tag.m_128469_(COVER_BLOCKS));
        this.oldIrisProgress = this.irisProgress = tag.m_128448_(IRIS_PROGRESS);
        this.irisItemHandler.deserializeNBT(tag.m_128469_(IRIS_INVENTORY));
        this.m_6596_();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        this.serializeStargateInfo(tag);
    }

    public CompoundTag serializeStargateInfo(CompoundTag tag) {
        tag.m_128405_(TIMES_OPENED, this.timesOpened);
        tag.m_128385_(ADDRESS, this.address.toArray());
        tag.m_128405_(NETWORK, this.network);
        tag.m_128379_(RESTRICT_NETWORK, this.restrictNetwork);
        tag.m_128359_(CONNECTION_ID, this.connectionID);
        tag.m_128385_(ID_9_CHEVRON_ADDRESS, this.id9ChevronAddress.toArray());
        tag.m_128379_(ADD_TO_NETWORK, this.addToNetwork);
        tag.m_128356_(ENERGY, this.getEnergyStored());
        tag.m_128379_(DISPLAY_ID, this.displayID);
        tag.m_128379_(UPGRADED, this.upgraded);
        tag.m_128359_(VARIANT, this.variant);
        if (this.dhdRelativePos.isPresent()) {
            Vec3i pos = this.dhdRelativePos.get();
            tag.m_128385_(DHD_POS, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        }
        tag.m_128405_(AUTOCLOSE, this.autoclose);
        this.serializeFilters(tag);
        tag.m_128365_(COVER_BLOCKS, (Tag)this.blockCover.serializeNBT());
        tag.m_128376_(IRIS_PROGRESS, this.irisProgress);
        tag.m_128365_(IRIS_INVENTORY, (Tag)this.irisItemHandler.serializeNBT());
        super.m_183515_(tag);
        return tag;
    }

    public void deserializeFilters(CompoundTag tag) {
        if (tag.m_128441_(FILTER_TYPE)) {
            this.filter = Stargate.FilterType.getFilterType(tag.m_128451_(FILTER_TYPE));
        }
        if (tag.m_128441_(WHITELIST)) {
            CompoundTag whitelistTag = tag.m_128469_(WHITELIST);
            whitelistTag.m_128431_().forEach(addressString -> this.whitelist.add(new Address.Immutable((String)addressString)));
        }
        if (tag.m_128441_(BLACKLIST)) {
            CompoundTag blacklistTag = tag.m_128469_(BLACKLIST);
            blacklistTag.m_128431_().forEach(addressString -> this.blacklist.add(new Address.Immutable((String)addressString)));
        }
    }

    public void serializeFilters(CompoundTag tag) {
        tag.m_128405_(FILTER_TYPE, this.filter.getIntegerValue());
        CompoundTag whitelistTag = new CompoundTag();
        CompoundTag blacklistTag = new CompoundTag();
        this.whitelist.forEach(address -> whitelistTag.m_128379_(address.toString(), true));
        this.blacklist.forEach(address -> blacklistTag.m_128379_(address.toString(), true));
        tag.m_128365_(WHITELIST, (Tag)whitelistTag);
        tag.m_128365_(BLACKLIST, (Tag)blacklistTag);
    }

    public void addStargateToNetwork() {
        if (this.id9ChevronAddress.isEmpty() || BlockEntityList.get(this.f_58857_).getStargate(this.id9ChevronAddress.immutable()).isPresent()) {
            this.set9ChevronAddress(this.generate9ChevronAddress());
        }
        StargateNetwork.get(this.f_58857_).addStargate(this);
        this.addToNetwork = true;
        this.m_6596_();
    }

    public void removeStargateFromNetwork() {
        StargateNetwork.get(this.f_58857_).removeStargate(this.f_58857_, this.id9ChevronAddress.immutable());
    }

    public void set9ChevronAddress(Address address) {
        this.id9ChevronAddress = address;
        this.m_6596_();
        StargateJourney.LOGGER.info("Set 9-Chevron Address to " + this.id9ChevronAddress);
    }

    public Address get9ChevronAddress() {
        return this.id9ChevronAddress;
    }

    protected Address generate9ChevronAddress() {
        Address address;
        Random random = new Random();
        do {
            address = new Address().randomAddress(8, 36, random.nextLong());
        } while (!BlockEntityList.get(this.f_58857_).getStargate(address.immutable()).isEmpty());
        return address;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.getCenterPos().m_123341_() - 3), (double)(this.getCenterPos().m_123342_() - 3), (double)(this.getCenterPos().m_123343_() - 3), (double)(this.getCenterPos().m_123341_() + 4), (double)(this.getCenterPos().m_123342_() + 4), (double)(this.getCenterPos().m_123343_() + 4));
    }

    public int getSymbolBounds() {
        return this.symbolBounds;
    }

    public boolean isSymbolOutOfBounds(int symbol) {
        if (symbol < 0) {
            return true;
        }
        return symbol > this.getSymbolBounds();
    }

    public static int getChevron(AbstractStargateEntity stargate, int chevronNumber) {
        if (--chevronNumber < 0 || chevronNumber >= 8) {
            return 0;
        }
        return stargate.getEngagedChevrons()[chevronNumber];
    }

    public Stargate.Feedback engageSymbol(int symbol) {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (this.isSymbolOutOfBounds(symbol)) {
            return Stargate.Feedback.SYMBOL_OUT_OF_BOUNDS;
        }
        if (this.isConnected()) {
            if (symbol == 0) {
                return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
            }
            return this.setRecentFeedback(Stargate.Feedback.ENCODE_WHEN_CONNECTED);
        }
        if (symbol == 0) {
            return this.setRecentFeedback(this.lockPrimaryChevron());
        }
        return this.setRecentFeedback(this.encodeChevron(symbol, false, false));
    }

    public Stargate.Feedback encodeChevron(int symbol, boolean incoming, boolean encodeSound) {
        if (this.address.containsSymbol(symbol)) {
            return this.setRecentFeedback(Stargate.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (!this.address.canGrow()) {
            return this.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        this.growAddress(symbol);
        this.chevronSound((short)this.getAddress().getLength(), incoming, false, encodeSound);
        if (!incoming) {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        } else {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
        }
        this.updateAdvancedCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        this.m_6596_();
        return Stargate.Feedback.SYMBOL_ENCODED;
    }

    protected Stargate.Feedback lockPrimaryChevron() {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (!this.address.isComplete()) {
            this.chevronSound((short)0, false, false, false);
            return this.resetStargate(Stargate.Feedback.INCOMPLETE_ADDRESS);
        }
        if (!this.isConnected()) {
            if (!this.isObstructed()) {
                this.chevronSound((short)0, false, false, false);
                this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength() + 1, 0, false, 0);
                return this.setRecentFeedback(this.engageStargate(this.getAddress(), true));
            }
            return this.resetStargate(Stargate.Feedback.SELF_OBSTRUCTED, false);
        }
        return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
    }

    public void chevronSound(short chevron, boolean incoming, boolean open, boolean encode) {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, chevron, incoming, open, encode));
        }
    }

    public void openWormholeSound(boolean incoming) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.OpenWormhole(this.f_58858_, incoming));
    }

    public void idleWormholeSound(boolean incoming) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.IdleWormhole(this.f_58858_, incoming));
    }

    public void closeWormholeSound(boolean incoming) {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.CloseWormhole(this.f_58858_, incoming));
        }
    }

    public void playIrisThudSound() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.IrisThud(this.f_58858_));
        }
    }

    public abstract void playRotationSound();

    public abstract void stopRotationSound();

    public void playWormholeIdleSound() {
        this.wormholeIdleSound.playSound();
    }

    public Stargate.Feedback engageStargate(Address address, boolean doKawoosh) {
        Address.Immutable immutableAddress = address.immutable();
        if (this.getFilterType().shouldFilter()) {
            if (this.getFilterType().isBlacklist() && this.isAddressBlacklisted(immutableAddress)) {
                return this.resetStargate(Stargate.Feedback.BLACKLISTED_TARGET);
            }
            if (this.getFilterType().isWhitelist() && !this.isAddressWhitelisted(immutableAddress)) {
                return this.resetStargate(Stargate.Feedback.WHITELISTED_TARGET);
            }
        }
        Address dialingAddress = this.getConnectionAddress(address.getLength());
        Optional<Stargate> stargate = StargateNetwork.get(this.f_58857_).getStargate(this.get9ChevronAddress().immutable());
        if (stargate.isPresent()) {
            return Dialing.dialStargate((ServerLevel)this.f_58857_, stargate.get(), immutableAddress, dialingAddress.immutable(), doKawoosh);
        }
        return this.resetStargate(Stargate.Feedback.UNKNOWN_ERROR);
    }

    public void connectStargate(String connectionID, StargateConnection.State connectionState) {
        this.connectionID = connectionID;
        this.setConnected(connectionState);
        ++this.timesOpened;
        this.animationTick = 0;
        this.m_6596_();
        this.updateStargate(false);
    }

    public static double kawooshFunction(int kawooshTime) {
        return 8.0 * Math.sin(Math.PI * (double)kawooshTime / 40.0);
    }

    public void doKawoosh(int kawooshTime) {
        this.setKawooshTickCount(kawooshTime);
        if (kawooshTime > 40 || this.isIrisClosed()) {
            return;
        }
        Direction axisDirection = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        Direction direction = Orientation.getEffectiveDirection(this.getDirection(), this.getOrientation());
        double frontMultiplier = AbstractStargateEntity.kawooshFunction(kawooshTime);
        if (((Boolean)CommonStargateConfig.kawoosh_destroys_blocks.get()).booleanValue()) {
            this.destroyBlocks(frontMultiplier, axisDirection, direction);
        }
        if (((Boolean)CommonStargateConfig.kawoosh_disintegrates_entities.get()).booleanValue()) {
            this.disintegrateEntities(frontMultiplier, axisDirection, direction);
        }
    }

    protected void destroyBlocks(double frontMultiplier, Direction axisDirection, Direction direction) {
        BlockPos centerPos = this.getCenterPos();
        for (int width = -1; width <= 1; ++width) {
            for (int height = -1; height <= 1; ++height) {
                BlockPos pos = centerPos.m_5484_(axisDirection, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (state.m_60734_() instanceof AbstractStargateBlock) continue;
                for (int i = 0; i < (int)Math.round(frontMultiplier); ++i) {
                    BlockState relativeState;
                    BlockPos relativePos = pos.m_5484_(direction, i);
                    if (this.f_58857_.m_8055_(relativePos).m_60713_(Blocks.f_50016_) || (relativeState = this.f_58857_.m_8055_(relativePos)).m_204336_(TagInit.Blocks.KAWOOSH_IMMUNE)) continue;
                    this.f_58857_.m_46961_(relativePos, false);
                }
            }
        }
    }

    protected void disintegrateEntities(double frontMultiplier, Direction axisDirection, Direction direction) {
        Vec3 centerVector = this.getCenter();
        Vec3 backVector = centerVector.m_231075_(axisDirection, -2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), -2.25);
        frontMultiplier = frontMultiplier > 7.0 ? 7.0 : frontMultiplier;
        Vec3 facingVector = Orientation.getEffectiveVector(direction, this.getOrientation());
        facingVector = facingVector.m_82542_(frontMultiplier, frontMultiplier, frontMultiplier);
        facingVector = facingVector.m_82549_(centerVector);
        facingVector = facingVector.m_231075_(axisDirection, 2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), 2.25);
        AABB kawooshHitbox = new AABB(backVector.m_7096_(), backVector.m_7098_(), backVector.m_7094_(), facingVector.m_7096_(), facingVector.m_7098_(), facingVector.m_7094_());
        this.f_58857_.m_45976_(Entity.class, kawooshHitbox).stream().forEach(entity -> {
            if (this.shouldDisintegrate((Entity)entity) && entity.m_6084_()) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_36220_((ResourceLocation)StatisticsInit.TIMES_KILLED_BY_KAWOOSH.get());
                }
                entity.m_6074_();
            }
        });
    }

    public boolean shouldDisintegrate(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        if (!((Boolean)CommonStargateConfig.kawoosh_disintegrates_items.get()).booleanValue() && entity instanceof ItemEntity) {
            return false;
        }
        return !entity.m_6095_().m_204039_(TagInit.Entities.KAWOOSH_IMMUNE);
    }

    public Stargate.Feedback resetStargate(Stargate.Feedback feedback, boolean updateInterfaces) {
        Optional<BlockPos> dhdPos;
        if (this.isConnected()) {
            this.closeWormholeSound(!this.isDialingOut());
            this.setConnected(StargateConnection.State.IDLE);
        }
        this.resetAddress(updateInterfaces);
        this.connectionID = EMPTY;
        this.setKawooshTickCount(0);
        this.setTickCount(0);
        if (feedback.playFailSound() && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Fail(this.f_58858_));
        }
        if (updateInterfaces) {
            this.updateBasicInterfaceBlocks(EVENT_RESET, feedback.getCode());
            this.updateCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
            this.updateAdvancedCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
        }
        if (this.dhdRelativePos.isPresent() && (dhdPos = this.getDHDPos()).isPresent() && !(this.m_58904_().m_7702_(dhdPos.get()) instanceof AbstractDHDEntity)) {
            this.unsetDHD(true);
        }
        this.m_6596_();
        if (feedback == Stargate.Feedback.UNKNOWN_ERROR) {
            StargateJourney.LOGGER.error("Reset Stargate at " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_() + " " + this.m_58904_().m_46472_().m_135782_().toString() + " " + Stargate.Feedback.UNKNOWN_ERROR.getMessage());
        } else {
            StargateJourney.LOGGER.debug("Reset Stargate at " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_() + " " + this.m_58904_().m_46472_().m_135782_().toString() + " " + feedback.getMessage());
        }
        return this.setRecentFeedback(feedback);
    }

    public Stargate.Feedback resetStargate(Stargate.Feedback feedback) {
        return this.resetStargate(feedback, true);
    }

    public Stargate.Feedback disconnectStargate(Stargate.Feedback feedback, boolean updateInterfaces) {
        if (this.isConnected()) {
            if (!((Boolean)CommonStargateConfig.end_connection_from_both_ends.get()).booleanValue() && !this.isDialingOut()) {
                return Stargate.Feedback.WRONG_DISCONNECT_SIDE;
            }
            if (this.getOpenTime() <= 0) {
                return Stargate.Feedback.CONNECTION_FORMING;
            }
        }
        return this.bypassDisconnectStargate(feedback, updateInterfaces);
    }

    public Stargate.Feedback bypassDisconnectStargate(Stargate.Feedback feedback, boolean updateInterfaces) {
        if (this.connectionID != null && !this.connectionID.equals(EMPTY)) {
            StargateNetwork.get(this.f_58857_).terminateConnection(this.connectionID, feedback);
        }
        return this.resetStargate(feedback, updateInterfaces);
    }

    public void updateStargate(boolean updateInterfaces) {
        this.updateStargate(this.f_58857_, updateInterfaces);
    }

    private void updateStargate(Level level, boolean updateInterfaces) {
        if (level.m_5776_()) {
            return;
        }
        StargateNetwork.get(level).updateStargate((ServerLevel)level, this);
        this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), updateInterfaces);
    }

    protected void growAddress(int symbol) {
        this.address.addSymbol(symbol);
        this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true);
    }

    protected void resetAddress(boolean updateInterfaces) {
        this.address.reset();
        this.engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
        this.setStargateState(StargateConnection.State.IDLE, 0, updateInterfaces);
    }

    public Address getConnectionAddress(int addressLength) {
        Optional<Address.Immutable> address;
        ResourceKey dimension = this.f_58857_.m_46472_();
        if (addressLength == 6) {
            Optional<Address.Immutable> address2;
            Optional<Galaxy.Serializable> galaxy = Universe.get(this.f_58857_).getGalaxyFromDimension((ResourceKey<Level>)dimension);
            if (galaxy.isPresent() && (address2 = Universe.get(this.f_58857_).getAddressInGalaxyFromDimension(galaxy.get().getKey().m_135782_().toString(), (ResourceKey<Level>)dimension)).isPresent()) {
                return address2.get().mutable();
            }
        } else if (addressLength == 7 && (address = Universe.get(this.f_58857_).getExtragalacticAddressFromDimension((ResourceKey<Level>)dimension)).isPresent()) {
            return address.get().mutable();
        }
        return this.get9ChevronAddress();
    }

    public Stargate.Feedback setRecentFeedback(Stargate.Feedback feedback) {
        if (feedback != Stargate.Feedback.NONE) {
            this.recentFeedback = feedback;
        }
        this.sendDHDFeedback(feedback);
        this.updateDHD();
        return this.getRecentFeedback();
    }

    public Stargate.Feedback getRecentFeedback() {
        return this.recentFeedback;
    }

    public void setPointOfOriginFromDimension(ResourceKey<Level> dimension) {
        this.pointOfOrigin = Universe.get(this.f_58857_).getPointOfOrigin(dimension).m_135782_().toString();
        this.m_6596_();
    }

    public void setRandomPointOfOrigin(ResourceKey<Level> dimension) {
        Random random = new Random();
        this.pointOfOrigin = Universe.get(this.f_58857_).getRandomPointOfOriginFromDimension(dimension, random.nextLong()).m_135782_().toString();
    }

    protected boolean isPointOfOriginValid(Level level) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        if (!this.isLocationValid(this.pointOfOrigin)) {
            return false;
        }
        return pointOfOriginRegistry.m_7804_(new ResourceLocation(this.pointOfOrigin));
    }

    public void setSymbolsFromDimension(ResourceKey<Level> dimension) {
        this.symbols = Universe.get(this.f_58857_).getSymbols((ResourceKey<Level>)this.f_58857_.m_46472_()).m_135782_().toString();
        this.m_6596_();
    }

    protected boolean areSymbolsValid(Level level) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry symbolRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
        if (!this.isLocationValid(this.symbols)) {
            return false;
        }
        return symbolRegistry.m_7804_(new ResourceLocation(this.symbols));
    }

    private boolean isLocationValid(String location) {
        String[] split = location.split(":");
        if (split.length != 2) {
            return false;
        }
        if (!ResourceLocation.m_135843_((String)split[0])) {
            return false;
        }
        return ResourceLocation.m_135841_((String)split[1]);
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int network) {
        this.network = network;
        this.updateStargate(false);
    }

    public boolean getRestrictNetwork() {
        return this.restrictNetwork;
    }

    public void setRestrictNetwork(boolean restrictNetwork) {
        this.restrictNetwork = restrictNetwork;
    }

    public boolean isRestricted(int network) {
        if (this.getRestrictNetwork()) {
            return network != this.getNetwork();
        }
        return false;
    }

    public int getMaxGateOpenTime() {
        return (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    }

    public Stargate.Gen getGeneration() {
        return this.generation;
    }

    public void setKawooshTickCount(int kawooshTick) {
        this.kawooshTick = kawooshTick;
    }

    public int getKawooshTickCount() {
        return this.kawooshTick;
    }

    public void setTickCount(int animationTick) {
        this.animationTick = animationTick;
    }

    public int getTickCount() {
        return this.animationTick;
    }

    public int increaseTickCount() {
        ++this.animationTick;
        return this.animationTick;
    }

    public boolean hasIris() {
        return this.irisItemHandler.getStackInSlot(0).m_41720_() instanceof StargateIrisItem;
    }

    public boolean setIris(ItemStack stack) {
        if (this.irisItemHandler.getStackInSlot(0).m_41619_()) {
            this.irisItemHandler.setStackInSlot(0, stack.m_41777_());
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack getIris() {
        return this.irisItemHandler.getStackInSlot(0).m_41777_();
    }

    public boolean unsetIris() {
        if (!this.irisItemHandler.getStackInSlot(0).m_41619_()) {
            this.irisItemHandler.setStackInSlot(0, ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    public void decreaseIrisDurability() {
        if (this.irisItemHandler.getStackInSlot(0).m_41619_()) {
            return;
        }
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            boolean shouldDestroyIris;
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            boolean bl = shouldDestroyIris = !StargateIrisItem.decreaseDurability(this.irisItemHandler.getStackInSlot(0));
            if (shouldDestroyIris) {
                AbstractShieldingBlock.destroyShielding(this.f_58857_, this.m_58899_(), stargateBlock.getShieldingParts(), this.getDirection(), this.getOrientation());
            }
        }
    }

    public Optional<ResourceLocation> getIrisTexture() {
        if (!this.hasIris()) {
            return Optional.empty();
        }
        return Optional.ofNullable(StargateIrisItem.getIrisTexture(this.irisItemHandler.getStackInSlot(0)));
    }

    public void setIrisProgress(short irisProgress) {
        this.oldIrisProgress = this.irisProgress;
        this.irisProgress = irisProgress;
    }

    public short getIrisProgress() {
        return this.hasIris() ? this.irisProgress : (short)0;
    }

    public float getIrisProgress(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getIrisProgress() : Mth.m_14179_((float)partialTick, (float)this.oldIrisProgress, (float)this.irisProgress);
    }

    public boolean isIrisClosed() {
        return this.hasIris() && this.irisProgress == 58;
    }

    public int getIrisDurability() {
        return this.hasIris() ? StargateIrisItem.getDurability(this.getIris()) : 0;
    }

    public int getIrisMaxDurability() {
        Item item = this.getIris().m_41720_();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem iris = (StargateIrisItem)item;
            return iris.getMaxDurability();
        }
        return 0;
    }

    public ShieldingState getShieldingState() {
        return ShieldingState.fromProgress(this.irisProgress);
    }

    protected void setIrisState() {
        if (this.irisProgress == ShieldingState.CLOSED.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_4);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.CLOSED);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_4.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_3);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_4);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_3.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_2);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_3);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_2.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_1);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_2);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_1.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.OPEN);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.MOVING_1);
            }
            return;
        }
        if (this.irisProgress == 0 && this.oldIrisProgress > this.irisProgress) {
            this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.OPEN);
        }
    }

    public boolean addIris(ItemStack stack) {
        if (this.setIris(stack)) {
            this.irisProgress = (short)58;
            this.oldIrisProgress = (short)58;
            this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.CLOSED);
            return true;
        }
        return false;
    }

    public void removeIris() {
        if (this.unsetIris()) {
            ShieldingState shieldingState = ShieldingState.OPEN;
            this.irisProgress = shieldingState.getProgress();
            this.oldIrisProgress = shieldingState.getProgress();
            this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true, true, ShieldingState.OPEN);
        }
    }

    public short increaseIrisProgress() {
        this.oldIrisProgress = this.irisProgress;
        if (this.hasIris() && this.irisProgress < 58) {
            this.irisProgress = (short)(this.irisProgress + 1);
            this.setIrisState();
        }
        return this.irisProgress;
    }

    public short decreaseIrisProgress() {
        this.oldIrisProgress = this.irisProgress;
        if (this.hasIris() && this.irisProgress > 0) {
            this.irisProgress = (short)(this.irisProgress - 1);
            this.setIrisState();
        }
        return this.irisProgress;
    }

    public void setDHD(AbstractDHDEntity dhd, int autoclose) {
        Direction direction = this.getDirection();
        if (dhd != null && direction != null) {
            if (this.dhd.isEmpty() || this.dhd.isPresent() && this.dhd.get() == dhd) {
                Vec3i relativeOffset = CoordinateHelper.Relative.getRelativeOffset(direction, this.m_58899_(), dhd.m_58899_());
                this.dhdRelativePos = Optional.of(relativeOffset);
                this.dhd = Optional.of(dhd);
                this.updateDHD();
            }
            this.autoclose = autoclose;
        }
        this.updateStargate(this.f_58857_, false);
        this.m_6596_();
    }

    public void unsetDHD(boolean notifyDHD) {
        if (notifyDHD && this.dhd.isPresent()) {
            this.dhd.get().unsetStargate();
        }
        this.dhd = Optional.empty();
        this.dhdRelativePos = Optional.empty();
        this.autoclose = 0;
        this.updateStargate(this.f_58857_, false);
        this.updateDHD();
        this.m_6596_();
    }

    public Optional<BlockPos> getDHDPos() {
        if (this.dhdRelativePos.isEmpty()) {
            return Optional.empty();
        }
        BlockPos dhdPos = CoordinateHelper.Relative.getOffsetPos(this.getDirection(), this.m_58899_(), this.dhdRelativePos.get());
        if (dhdPos != null) {
            return Optional.of(dhdPos);
        }
        return Optional.empty();
    }

    public void loadDHD() {
        Optional<BlockPos> dhdPos = this.getDHDPos();
        if (dhdPos.isEmpty()) {
            return;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(dhdPos.get());
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            this.dhd = Optional.of(dhd);
        }
        this.updateDHD();
        this.m_6596_();
    }

    public int autoclose() {
        return this.autoclose;
    }

    public boolean hasDHD() {
        if (this.dhd.isPresent()) {
            if (this.dhd.get() != null) {
                return true;
            }
            this.unsetDHD(true);
        }
        return false;
    }

    public void updateDHD() {
        if (this.hasDHD()) {
            this.dhd.get().updateDHD(!this.isConnected() || this.isConnected() && this.isDialingOut() ? this.address : new Address(), this.isConnected());
        }
    }

    public void sendDHDFeedback(Stargate.Feedback feedback) {
        if (this.hasDHD() && feedback.isError()) {
            this.dhd.get().sendMessageToNearbyPlayers(feedback.getFeedbackMessage(), 5);
        }
    }

    public boolean shouldCallForward() {
        return this.hasDHD() && this.dhd.get().callForwardingEnabled();
    }

    public int getOpenTime() {
        if (this.f_58857_.m_5776_()) {
            return 0;
        }
        return StargateNetwork.get(this.f_58857_).getOpenTime(this.connectionID);
    }

    public boolean isWormholeOpen() {
        return this.getOpenTime() > 0;
    }

    public int getTimeSinceLastTraveler() {
        if (this.f_58857_.m_5776_()) {
            return 0;
        }
        return StargateNetwork.get(this.f_58857_).getTimeSinceLastTraveler(this.connectionID);
    }

    public int getTimesOpened() {
        return this.timesOpened;
    }

    public void setPointOfOrigin(String pointOfOrigin) {
        this.pointOfOrigin = pointOfOrigin;
        this.m_6596_();
    }

    public String getPointOfOrigin() {
        return this.pointOfOrigin;
    }

    public void setSymbols(String symbols) {
        this.symbols = symbols;
        this.m_6596_();
    }

    public String getSymbols() {
        return this.symbols;
    }

    public void setVariant(String variant) {
        this.variant = variant;
        this.m_6596_();
    }

    public String getVariant() {
        return this.variant;
    }

    public ResourceLocation defaultVariant() {
        return this.defaultVariant;
    }

    public void setAddress(Address address) {
        this.address = address;
        this.m_6596_();
    }

    public Address getAddress() {
        return this.address;
    }

    public int getChevronsEngaged() {
        int chevronsEngaged = this.address.getLength();
        return this.isConnected() ? chevronsEngaged + 1 : chevronsEngaged;
    }

    public void setEngagedChevrons(int[] engagedChevrons) {
        this.engagedChevrons = engagedChevrons;
    }

    public static int[] getChevronConfiguration(int addressLength) {
        switch (addressLength) {
            case 6: {
                return Dialing.DIALED_7_CHEVRON_CONFIGURATION;
            }
            case 7: {
                return Dialing.DIALED_8_CHEVRON_CONFIGURATION;
            }
            case 8: {
                return Dialing.DIALED_9_CHEVRON_CONFIGURATION;
            }
        }
        return Dialing.DEFAULT_CHEVRON_CONFIGURATION;
    }

    public int[] getEngagedChevrons() {
        return this.engagedChevrons;
    }

    public int chevronsRendered() {
        return this.address.getLength();
    }

    public int getRedstoneSymbolOutput() {
        return 0;
    }

    public int getRedstoneSegmentOutput() {
        return 0;
    }

    public Stargate.FilterType setFilterType(int integerValue) {
        this.filter = Stargate.FilterType.getFilterType(integerValue);
        return this.filter;
    }

    public Stargate.FilterType getFilterType() {
        return this.filter;
    }

    public boolean isAddressWhitelisted(Address.Immutable address) {
        return this.whitelist.contains(address);
    }

    public boolean addToWhitelist(Address.Immutable address) {
        if (this.whitelist.contains(address)) {
            return false;
        }
        this.whitelist.add(address);
        return true;
    }

    public boolean removeFromWhitelist(Address.Immutable address) {
        if (!this.whitelist.contains(address)) {
            return false;
        }
        this.whitelist.remove(address);
        return true;
    }

    public void clearWhitelist() {
        this.whitelist.clear();
    }

    public boolean isAddressBlacklisted(Address.Immutable address) {
        return this.blacklist.contains(address);
    }

    public boolean addToBlacklist(Address.Immutable address) {
        if (this.blacklist.contains(address)) {
            return false;
        }
        this.blacklist.add(address);
        return true;
    }

    public boolean removeFromBlacklist(Address.Immutable address) {
        if (!this.blacklist.contains(address)) {
            return false;
        }
        this.blacklist.remove(address);
        return true;
    }

    public void clearBlacklist() {
        this.blacklist.clear();
    }

    public BlockPos getCenterPos() {
        if (this.centerPosition == null) {
            BlockPos mainBlockPos = this.m_58899_();
            Direction centerDirection = Orientation.getCenterDirection(this.getDirection(), this.getOrientation());
            this.centerPosition = mainBlockPos.m_5484_(centerDirection, 3);
        }
        return this.centerPosition;
    }

    public Vec3 getCenter() {
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_() + y, (double)centerPos.m_123343_() + 0.5);
    }

    public Vec3 getRelativeCenter() {
        BlockPos mainBlockPos = this.m_58899_();
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)(centerPos.m_123341_() - mainBlockPos.m_123341_()) + 0.5, (double)(centerPos.m_123342_() - mainBlockPos.m_123342_()) + y, (double)(centerPos.m_123343_() - mainBlockPos.m_123343_()) + 0.5);
    }

    protected BlockState getState() {
        BlockPos gatePos = this.m_58899_();
        return this.f_58857_.m_8055_(gatePos);
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            BlockState gateState = this.getState();
            if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
                this.orientation = (Orientation)((Object)gateState.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
            } else {
                StargateJourney.LOGGER.error("Couldn't find Stargate Orientation " + this.m_58899_().toString());
            }
        }
        return this.orientation;
    }

    public Direction getDirection() {
        if (this.direction == null) {
            BlockState gateState = this.getState();
            if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
                this.direction = (Direction)gateState.m_61143_((Property)AbstractStargateBaseBlock.FACING);
            } else {
                StargateJourney.LOGGER.error("Couldn't find Stargate Direction " + this.m_58899_().toString());
            }
        }
        return this.direction;
    }

    public void setConnected(StargateConnection.State connectionState) {
        this.setStargateState(connectionState, this.getChevronsEngaged(), true);
        if (FORCE_LOAD_CHUNK) {
            if (connectionState != StargateConnection.State.IDLE) {
                ForgeChunkManager.forceChunk((ServerLevel)this.f_58857_.m_7654_().m_129880_(this.f_58857_.m_46472_()), (String)"sgjourney", (BlockPos)this.m_58899_(), (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45578_, (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45579_, (boolean)true, (boolean)true);
            } else {
                ForgeChunkManager.forceChunk((ServerLevel)this.f_58857_.m_7654_().m_129880_(this.f_58857_.m_46472_()), (String)"sgjourney", (BlockPos)this.m_58899_(), (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45578_, (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45579_, (boolean)false, (boolean)true);
            }
        }
    }

    public void setStargateState(StargateConnection.State connectionState, int chevronsEngaged, boolean updateInterfaces) {
        this.setStargateState(connectionState, chevronsEngaged, updateInterfaces, false, this.getShieldingState());
        this.updateClientState();
    }

    public void setStargateState(StargateConnection.State connectionState, int chevronsEngaged, boolean updateInterfaces, boolean updateIris, ShieldingState shieldingState) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargate = (AbstractStargateBaseBlock)block;
            stargate.updateStargate(this.f_58857_, gatePos, gateState, connectionState, chevronsEngaged, shieldingState);
            if (updateIris) {
                stargate.updateIris(this.f_58857_, gatePos, gateState, shieldingState);
            }
            if (updateInterfaces) {
                this.updateInterfaceBlocks(null, new Object[0]);
            }
        } else {
            StargateJourney.LOGGER.error("Couldn't find Stargate");
        }
        this.m_6596_();
    }

    public StargateConnection.State getConnectionState() {
        BlockState gateState = this.getState();
        if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
            return (StargateConnection.State)((Object)gateState.m_61143_((Property)AbstractStargateBaseBlock.CONNECTION_STATE));
        }
        return StargateConnection.State.IDLE;
    }

    public boolean isConnected() {
        return this.getConnectionState().isConnected();
    }

    public boolean isDialingOut() {
        return this.getConnectionState().isDialingOut();
    }

    public boolean isObstructed() {
        Direction direction = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        BlockPos centerPos = this.getCenterPos();
        int obstructingBlocks = 0;
        for (int width = -2; width <= 2; ++width) {
            for (int height = -2; height <= 2; ++height) {
                BlockPos pos = centerPos.m_5484_(direction, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if ((state.m_247087_() || state.m_60734_() instanceof AbstractStargateBlock || state.m_60734_() instanceof AbstractShieldingBlock) && !state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) continue;
                ++obstructingBlocks;
            }
        }
        return obstructingBlocks >= (Integer)CommonStargateConfig.max_obstructive_blocks.get();
    }

    public void updateBasicInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof BasicInterfaceEntity)) continue;
                    BasicInterfaceEntity interfaceEntity = (BasicInterfaceEntity)blockEntity;
                    if (direction.m_122424_() != state.m_61143_((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof CrystalInterfaceEntity)) continue;
                    CrystalInterfaceEntity interfaceEntity = (CrystalInterfaceEntity)blockEntity;
                    if (direction.m_122424_() != state.m_61143_((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateAdvancedCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof AdvancedCrystalInterfaceEntity)) continue;
                    AdvancedCrystalInterfaceEntity interfaceEntity = (AdvancedCrystalInterfaceEntity)blockEntity;
                    if (direction.m_122424_() != state.m_61143_((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        this.updateBasicInterfaceBlocks(eventName, objects);
        this.updateCrystalInterfaceBlocks(eventName, objects);
        this.updateAdvancedCrystalInterfaceBlocks(eventName, objects);
    }

    public Wormhole getWormhole() {
        return this.wormhole;
    }

    public void setOpenSoundLead(int openSoundLead) {
        this.openSoundLead = openSoundLead;
    }

    public int getOpenSoundLead() {
        return this.openSoundLead;
    }

    public abstract Stargate.ChevronLockSpeed getChevronLockSpeed();

    @Override
    public void getStatus(Player player) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)(": " + this.pointOfOrigin))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)(": " + this.symbols))).m_130940_(ChatFormatting.LIGHT_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.open_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getOpenTime() + "/" + this.getMaxGateOpenTime()))).m_130940_(ChatFormatting.DARK_AQUA));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.times_opened").m_7220_((Component)Component.m_237113_((String)(": " + this.timesOpened))).m_130940_(ChatFormatting.BLUE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.has_dhd").m_7220_((Component)Component.m_237113_((String)(": " + this.hasDHD()))).m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.autoclose").m_7220_((Component)Component.m_237113_((String)(": " + this.autoclose()))).m_130940_(ChatFormatting.RED));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.last_traveler_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getTimeSinceLastTraveler()))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.encoded_address").m_7220_((Component)Component.m_237113_((String)": ").m_7220_(this.address.toComponent(true))).m_130940_(ChatFormatting.GREEN));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.recent_feedback").m_7220_((Component)Component.m_237113_((String)": ").m_7220_(this.getRecentFeedback().getFeedbackMessage())).m_130940_(ChatFormatting.WHITE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.iris").m_7220_((Component)Component.m_237113_((String)": ").m_7220_((Component)(!this.getIris().m_41619_() ? this.getIris().m_41611_() : Component.m_237113_((String)"-")))).m_130940_(ChatFormatting.GRAY));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.iris_durability").m_7220_((Component)Component.m_237113_((String)(": " + (Serializable)(!this.getIris().m_41619_() ? Integer.valueOf(StargateIrisItem.getDurability(this.getIris())) : "-")))).m_130940_(ChatFormatting.GRAY));
        if (!this.getIris().m_41619_() && StargateIrisItem.hasCustomTexture(this.getIris())) {
            player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.iris_texture").m_7220_((Component)Component.m_237113_((String)(": " + StargateIrisItem.getIrisTexture(this.getIris())))).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.9_chevron_address").m_130946_(": ").m_130940_(ChatFormatting.AQUA).m_7220_(this.id9ChevronAddress.toComponent(true)));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.add_to_network").m_7220_((Component)Component.m_237113_((String)(": " + this.addToNetwork))).m_130940_(ChatFormatting.YELLOW));
        super.getStatus(player);
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return false;
    }

    @Override
    public long capacity() {
        return (Long)CommonStargateConfig.stargate_energy_capacity.get();
    }

    @Override
    public long maxReceive() {
        return (Long)CommonStargateConfig.stargate_energy_max_receive.get();
    }

    @Override
    public long maxExtract() {
        return (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    }

    public float getVerticalCenterHeight() {
        return this.verticalCenterHeight;
    }

    public float getHorizontalCenterHeight() {
        return this.horizontalCenterHeight;
    }

    public double getGateAddition() {
        return this.getOrientation() == Orientation.REGULAR ? (double)this.getVerticalCenterHeight() : (double)this.getHorizontalCenterHeight();
    }

    public abstract void registerInterfaceMethods(StargatePeripheralWrapper var1);

    public void doWhileDialed(int openTime, Stargate.ChevronLockSpeed chevronLockSpeed) {
    }

    public void updateClient() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateUpdatePacket(this.f_58858_, this.address.toArray(), this.engagedChevrons, this.kawooshTick, this.animationTick, this.irisProgress, this.pointOfOrigin, this.symbols, this.variant, this.irisItemHandler.getStackInSlot(0)));
    }

    public void updateClientState() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateStateUpdatePacket(this.f_58858_, this.blockCover.canSinkGate, this.blockCover.blockStates));
    }

    public void spawnCoverParticles() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateParticleSpawnPacket(this.f_58858_, this.blockCover.blockStates));
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void checkStargate() {
        if (this.isConnected() && (!StargateNetwork.get(this.m_58904_()).hasConnection(this.getConnectionID()) || this.getConnectionID().equals(StargateJourney.EMPTY))) {
            this.resetStargate(Stargate.Feedback.CONNECTION_ENDED_BY_NETWORK);
        }
    }

    public boolean sendStargateMessage(String message) {
        return StargateNetwork.get(this.f_58857_).sendStargateMessage(this, this.connectionID, message);
    }

    public void receiveStargateMessage(String message) {
        this.updateInterfaceBlocks(EVENT_MESSAGE_RECEIVED, message);
    }

    public float transmissionRadius() {
        return ((Integer)CommonTransmissionConfig.max_stargate_transmission_distance.get()).intValue();
    }

    @Override
    public void receiveTransmission(int transmissionJumps, int frequency, String transmission) {
        if (transmissionJumps < (Integer)CommonTransmissionConfig.max_transmission_jumps.get()) {
            StargateNetwork.get(this.f_58857_).sendStargateTransmission(this, this.connectionID, transmissionJumps + 1, frequency, transmission);
        }
    }

    public void forwardTransmission(int transmissionJumps, int frequency, String transmission) {
        int roundedRadius = (int)Math.ceil(this.transmissionRadius() / 16.0f);
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = this.f_58857_.m_46865_(this.m_58899_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (blockEntity instanceof ITransmissionReceiver) {
                        ITransmissionReceiver receiver = (ITransmissionReceiver)blockEntity;
                        receiver.receiveTransmission(transmissionJumps, frequency, transmission);
                    }
                });
            }
        }
    }

    public float checkConnectionShieldingState() {
        return StargateNetwork.get(this.f_58857_).checkStargateShieldingState(this, this.connectionID);
    }

    public float checkIrisState() {
        return (float)this.irisProgress * 100.0f / 58.0f;
    }

    protected ItemStackHandler createIrisHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractStargateEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof StargateIrisItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected ItemStackHandler createStargateShieldHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractStargateEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof StargateShieldItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractStargateEntity stargate) {
        if (stargate.isConnected()) {
            stargate.increaseTickCount();
        }
        if (level.m_5776_()) {
            return;
        }
        stargate.updateClient();
        if (!stargate.initialClientSync) {
            stargate.updateClientState();
        }
    }
}

