/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.resourcepack.stargate_variant;

import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClassicStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.MilkyWayStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.PegasusStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.RotatingStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.TollanStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.UniverseStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.TollanStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public class ClientStargateVariants {
    private static Minecraft minecraft = Minecraft.m_91087_();
    private static final HashMap<ResourceLocation, UniverseStargateVariant> UNIVERSE_STARGATE_VARIANTS = new HashMap();
    private static final HashMap<ResourceLocation, MilkyWayStargateVariant> MILKY_WAY_STARGATE_VARIANTS = new HashMap();
    private static final HashMap<ResourceLocation, PegasusStargateVariant> PEGASUS_STARGATE_VARIANTS = new HashMap();
    private static final HashMap<ResourceLocation, TollanStargateVariant> TOLLAN_STARGATE_VARIANTS = new HashMap();
    private static final HashMap<ResourceLocation, ClassicStargateVariant> CLASSIC_STARGATE_VARIANTS = new HashMap();

    public static void clear() {
        UNIVERSE_STARGATE_VARIANTS.clear();
        MILKY_WAY_STARGATE_VARIANTS.clear();
        PEGASUS_STARGATE_VARIANTS.clear();
        TOLLAN_STARGATE_VARIANTS.clear();
        CLASSIC_STARGATE_VARIANTS.clear();
    }

    public static boolean hasUniverseStargateVariant(ResourceLocation location) {
        return UNIVERSE_STARGATE_VARIANTS.containsKey(location);
    }

    public static UniverseStargateVariant getUniverseStargateVariant(ResourceLocation location) {
        if (ClientStargateVariants.hasUniverseStargateVariant(location)) {
            return UNIVERSE_STARGATE_VARIANTS.get(location);
        }
        return UniverseStargateVariant.DEFAULT_VARIANT;
    }

    public static void addUniverseStargateVariant(ResourceLocation location, UniverseStargateVariant stargateVariant) {
        if (!ClientStargateVariants.hasUniverseStargateVariant(location)) {
            UNIVERSE_STARGATE_VARIANTS.put(location, stargateVariant);
        } else {
            StargateJourney.LOGGER.error("Universe Stargate Variant " + location.toString() + " already exists");
        }
    }

    public static boolean hasMilkyWayStargateVariant(ResourceLocation location) {
        return MILKY_WAY_STARGATE_VARIANTS.containsKey(location);
    }

    public static MilkyWayStargateVariant getMilkyWayStargateVariant(ResourceLocation location) {
        if (ClientStargateVariants.hasMilkyWayStargateVariant(location)) {
            return MILKY_WAY_STARGATE_VARIANTS.get(location);
        }
        return ClientStargateConfig.milky_way_stargate_back_lights_up.get() ? MilkyWayStargateVariant.DEFAULT_BACK_VARIANT : MilkyWayStargateVariant.DEFAULT_VARIANT;
    }

    public static void addMilkyWayStargateVariant(ResourceLocation location, MilkyWayStargateVariant stargateVariant) {
        if (!ClientStargateVariants.hasMilkyWayStargateVariant(location)) {
            MILKY_WAY_STARGATE_VARIANTS.put(location, stargateVariant);
        } else {
            StargateJourney.LOGGER.error("Milky Way Stargate Variant " + location.toString() + " already exists");
        }
    }

    public static boolean hasPegasusStargateVariant(ResourceLocation location) {
        return PEGASUS_STARGATE_VARIANTS.containsKey(location);
    }

    public static PegasusStargateVariant getPegasusStargateVariant(ResourceLocation location) {
        if (ClientStargateVariants.hasPegasusStargateVariant(location)) {
            return PEGASUS_STARGATE_VARIANTS.get(location);
        }
        return ClientStargateConfig.pegasus_stargate_back_lights_up.get() ? PegasusStargateVariant.DEFAULT_BACK_VARIANT : PegasusStargateVariant.DEFAULT_VARIANT;
    }

    public static void addPegasusStargateVariant(ResourceLocation location, PegasusStargateVariant stargateVariant) {
        if (!ClientStargateVariants.hasPegasusStargateVariant(location)) {
            PEGASUS_STARGATE_VARIANTS.put(location, stargateVariant);
        } else {
            StargateJourney.LOGGER.error("Pegasus Stargate Variant " + location.toString() + " already exists");
        }
    }

    public static boolean hasTollanStargateVariant(ResourceLocation location) {
        return TOLLAN_STARGATE_VARIANTS.containsKey(location);
    }

    public static TollanStargateVariant getTollanStargateVariant(ResourceLocation location) {
        if (ClientStargateVariants.hasTollanStargateVariant(location)) {
            return TOLLAN_STARGATE_VARIANTS.get(location);
        }
        return TollanStargateVariant.DEFAULT_VARIANT;
    }

    public static void addTollanStargateVariant(ResourceLocation location, TollanStargateVariant stargateVariant) {
        if (!ClientStargateVariants.hasTollanStargateVariant(location)) {
            TOLLAN_STARGATE_VARIANTS.put(location, stargateVariant);
        } else {
            StargateJourney.LOGGER.error("Tollan Stargate Variant " + location.toString() + " already exists");
        }
    }

    public static boolean hasClassicStargateVariant(ResourceLocation location) {
        return CLASSIC_STARGATE_VARIANTS.containsKey(location);
    }

    public static ClassicStargateVariant getClassicStargateVariant(ResourceLocation location) {
        if (ClientStargateVariants.hasClassicStargateVariant(location)) {
            return CLASSIC_STARGATE_VARIANTS.get(location);
        }
        return ClassicStargateVariant.DEFAULT_VARIANT;
    }

    public static void addClassicStargateVariant(ResourceLocation location, ClassicStargateVariant stargateVariant) {
        if (!ClientStargateVariants.hasClassicStargateVariant(location)) {
            CLASSIC_STARGATE_VARIANTS.put(location, stargateVariant);
        } else {
            StargateJourney.LOGGER.error("Classic Stargate Variant " + location.toString() + " already exists");
        }
    }

    public static ClientStargateVariant getClientStargateVariant(ResourceLocation location, AbstractStargateEntity stargate) {
        if (stargate instanceof UniverseStargateEntity) {
            return ClientStargateVariants.getUniverseStargateVariant(location);
        }
        if (stargate instanceof MilkyWayStargateEntity) {
            return ClientStargateVariants.getMilkyWayStargateVariant(location);
        }
        if (stargate instanceof PegasusStargateEntity) {
            return ClientStargateVariants.getPegasusStargateVariant(location);
        }
        if (stargate instanceof TollanStargateEntity) {
            return ClientStargateVariants.getTollanStargateVariant(location);
        }
        if (stargate instanceof ClassicStargateEntity) {
            return ClientStargateVariants.getClassicStargateVariant(location);
        }
        return MilkyWayStargateVariant.DEFAULT_VARIANT;
    }

    public static RotatingStargateVariant getRotatingStargateVariant(ResourceLocation location, AbstractStargateEntity stargate) {
        if (stargate instanceof UniverseStargateEntity) {
            return ClientStargateVariants.getUniverseStargateVariant(location);
        }
        if (stargate instanceof MilkyWayStargateEntity) {
            return ClientStargateVariants.getMilkyWayStargateVariant(location);
        }
        if (stargate instanceof PegasusStargateEntity) {
            return ClientStargateVariants.getPegasusStargateVariant(location);
        }
        return MilkyWayStargateVariant.DEFAULT_VARIANT;
    }

    public static Optional<StargateVariant> getVariant(AbstractStargateEntity stargate) {
        Optional<StargateVariant> optional = Optional.empty();
        if (!ClientStargateConfig.stargate_variants.get()) {
            return optional;
        }
        String variantString = stargate.getVariant();
        if (variantString.equals(StargateJourney.EMPTY)) {
            return optional;
        }
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry variantRegistry = registries.m_175515_(StargateVariant.REGISTRY_KEY);
        optional = Optional.ofNullable((StargateVariant)variantRegistry.m_7745_(new ResourceLocation(variantString)));
        return optional;
    }
}

