/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.client.models.PegasusStargateModel;
import net.povstalec.sgjourney.client.render.block_entity.AbstractStargateRenderer;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.PegasusStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.PegasusStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public class PegasusStargateRenderer
extends AbstractStargateRenderer<PegasusStargateEntity, PegasusStargateVariant> {
    protected final PegasusStargateModel stargateModel = new PegasusStargateModel();

    public PegasusStargateRenderer(BlockEntityRendererProvider.Context context) {
        super(context, 0.25f, false, 84.0f);
    }

    @Override
    protected PegasusStargateVariant getClientVariant(PegasusStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            if (stargateVariant.get().isFound()) {
                return ClientStargateVariants.getPegasusStargateVariant(stargateVariant.get().clientVariant());
            }
            if (!stargateVariant.get().isMissing()) {
                stargateVariant.get().handleLocation(ClientStargateVariants.hasPegasusStargateVariant(stargateVariant.get().clientVariant()));
            }
        }
        return ClientStargateVariants.getPegasusStargateVariant(stargate.defaultVariant());
    }

    public void render(PegasusStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        PegasusStargateVariant stargateVariant = this.getClientVariant(stargate);
        BlockState blockstate = stargate.m_58900_();
        float facing = ((Direction)blockstate.m_61143_((Property)PegasusStargateBlock.FACING)).m_122435_();
        Vec3 center = stargate.getRelativeCenter();
        Orientation orientation = (Orientation)((Object)blockstate.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
        this.renderCover(stargate, stack, source, combinedLight, combinedOverlay);
        stack.m_85836_();
        stack.m_85837_(center.m_7096_(), center.m_7098_(), center.m_7094_());
        stack.m_252781_(Axis.f_252436_.m_252977_(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        this.stargateModel.setCurrentSymbol(stargate.currentSymbol);
        this.stargateModel.renderStargate(stargate, stargateVariant, partialTick, stack, source, combinedLight, combinedOverlay);
        this.irisModel.renderIris(stargate, stack, source, combinedLight, combinedOverlay, stargate.getIrisProgress(partialTick));
        this.renderWormhole(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
        stack.m_85849_();
    }
}

