/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsInputHandler;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsPacket;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ValueSettingsClient
implements IGuiOverlay {
    private Minecraft mc = Minecraft.m_91087_();
    public int interactHeldTicks = -1;
    public BlockPos interactHeldPos = null;
    public BehaviourType<?> interactHeldBehaviour = null;
    public InteractionHand interactHeldHand = null;
    public Direction interactHeldFace = null;
    public List<MutableComponent> lastHoverTip;
    public int hoverTicks;
    public int hoverWarmup;

    public void cancelIfWarmupAlreadyStarted(PlayerInteractEvent.RightClickBlock event) {
        if (this.interactHeldTicks != -1 && event.getPos().equals((Object)this.interactHeldPos)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    public void startInteractionWith(BlockPos pos, BehaviourType<?> behaviourType, InteractionHand hand, Direction side) {
        this.interactHeldTicks = 0;
        this.interactHeldPos = pos;
        this.interactHeldBehaviour = behaviourType;
        this.interactHeldHand = hand;
        this.interactHeldFace = side;
    }

    public void cancelInteraction() {
        this.interactHeldTicks = -1;
    }

    public void tick() {
        ValueSettingsBehaviour valueSettingBehaviour;
        BlockHitResult blockHitResult;
        if (this.hoverWarmup > 0) {
            --this.hoverWarmup;
        }
        if (this.hoverTicks > 0) {
            --this.hoverTicks;
        }
        if (this.interactHeldTicks == -1) {
            return;
        }
        LocalPlayer player = this.mc.f_91074_;
        if (!ValueSettingsInputHandler.canInteract((Player)player) || AllBlocks.CLIPBOARD.isIn(player.m_21205_())) {
            this.cancelInteraction();
            return;
        }
        HitResult hitResult = this.mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult) || !(blockHitResult = (BlockHitResult)hitResult).m_82425_().equals((Object)this.interactHeldPos)) {
            this.cancelInteraction();
            return;
        }
        Object behaviour = BlockEntityBehaviour.get((BlockGetter)this.mc.f_91073_, this.interactHeldPos, this.interactHeldBehaviour);
        if (!(behaviour instanceof ValueSettingsBehaviour) || !(valueSettingBehaviour = (ValueSettingsBehaviour)behaviour).testHit(blockHitResult.m_82450_())) {
            this.cancelInteraction();
            return;
        }
        if (!this.mc.f_91066_.f_92095_.m_90857_()) {
            AllPackets.getChannel().sendToServer((Object)new ValueSettingsPacket(this.interactHeldPos, 0, 0, this.interactHeldHand, this.interactHeldFace, false));
            this.cancelInteraction();
            return;
        }
        if (this.interactHeldTicks > 3) {
            player.f_20911_ = false;
        }
        if (this.interactHeldTicks++ < 5) {
            return;
        }
        ScreenOpener.open(new ValueSettingsScreen(this.interactHeldPos, valueSettingBehaviour.createBoard((Player)player, blockHitResult), valueSettingBehaviour.getValueSettings(), valueSettingBehaviour::newSettingHovered));
        this.interactHeldTicks = -1;
    }

    public void showHoverTip(List<MutableComponent> tip) {
        if (this.mc.f_91080_ != null) {
            return;
        }
        if (this.hoverWarmup < 6) {
            this.hoverWarmup += 2;
            return;
        }
        ++this.hoverWarmup;
        this.hoverTicks = this.hoverTicks == 0 ? 11 : Math.max(this.hoverTicks, 6);
        this.lastHoverTip = tip;
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || !ValueSettingsInputHandler.canInteract((Player)mc.f_91074_)) {
            return;
        }
        if (this.hoverTicks == 0 || this.lastHoverTip == null) {
            return;
        }
        int x = width / 2;
        int y = height - 75 - this.lastHoverTip.size() * 12;
        float alpha = this.hoverTicks > 5 ? (float)(11 - this.hoverTicks) / 5.0f : Math.min(1.0f, (float)this.hoverTicks / 5.0f);
        Color color = new Color(0xFFFFFF);
        Color titleColor = new Color(16505981);
        color.setAlpha(alpha);
        titleColor.setAlpha(alpha);
        for (int i = 0; i < this.lastHoverTip.size(); ++i) {
            MutableComponent mutableComponent = this.lastHoverTip.get(i);
            graphics.m_280430_(mc.f_91062_, (Component)mutableComponent, x - mc.f_91062_.m_92852_((FormattedText)mutableComponent) / 2, y, (i == 0 ? titleColor : color).getRGB());
            y += 12;
        }
    }
}

