/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AttributeFilterMenu
extends AbstractFilterMenu {
    WhitelistMode whitelistMode;
    List<Pair<ItemAttribute, Boolean>> selectedAttributes;

    public AttributeFilterMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public AttributeFilterMenu(MenuType<?> type, int id, Inventory inv, ItemStack stack) {
        super(type, id, inv, stack);
    }

    public static AttributeFilterMenu create(int id, Inventory inv, ItemStack stack) {
        return new AttributeFilterMenu((MenuType)AllMenuTypes.ATTRIBUTE_FILTER.get(), id, inv, stack);
    }

    public void appendSelectedAttribute(ItemAttribute itemAttribute, boolean inverted) {
        this.selectedAttributes.add(Pair.of(itemAttribute, inverted));
    }

    @Override
    protected void init(Inventory inv, ItemStack contentHolder) {
        super.init(inv, contentHolder);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42656_);
        stack.m_41714_((Component)Components.literal("Selected Tags").m_130944_(new ChatFormatting[]{ChatFormatting.RESET, ChatFormatting.BLUE}));
        this.ghostInventory.setStackInSlot(1, stack);
    }

    @Override
    protected int getPlayerInventoryXOffset() {
        return 51;
    }

    @Override
    protected int getPlayerInventoryYOffset() {
        return 107;
    }

    @Override
    protected void addFilterSlots() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 0, 16, 24));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 1, 22, 59){

            public boolean m_8010_(Player playerIn) {
                return false;
            }
        });
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(2);
    }

    @Override
    public void clearContents() {
        this.selectedAttributes.clear();
    }

    @Override
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == 37) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public boolean m_5622_(Slot slotIn) {
        if (slotIn.f_40219_ == 37) {
            return false;
        }
        return super.m_5622_(slotIn);
    }

    @Override
    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        if (slotIn.f_40219_ == 37) {
            return false;
        }
        return super.m_5882_(stack, slotIn);
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int index) {
        if (index == 37) {
            return ItemStack.f_41583_;
        }
        if (index == 36) {
            this.ghostInventory.setStackInSlot(37, ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.m_8020_(index);
            ItemStack copy = stackToInsert.m_41777_();
            copy.m_41764_(1);
            this.ghostInventory.setStackInSlot(0, copy);
        }
        return ItemStack.f_41583_;
    }

    @Override
    protected void initAndReadInventory(ItemStack filterItem) {
        super.initAndReadInventory(filterItem);
        this.selectedAttributes = new ArrayList<Pair<ItemAttribute, Boolean>>();
        this.whitelistMode = WhitelistMode.values()[filterItem.m_41784_().m_128451_("WhitelistMode")];
        ListTag attributes = filterItem.m_41784_().m_128437_("MatchedAttributes", 10);
        attributes.forEach(inbt -> {
            CompoundTag compound = (CompoundTag)inbt;
            this.selectedAttributes.add(Pair.of(ItemAttribute.fromNBT(compound), compound.m_128471_("Inverted")));
        });
    }

    @Override
    protected void saveData(ItemStack filterItem) {
        filterItem.m_41784_().m_128405_("WhitelistMode", this.whitelistMode.ordinal());
        ListTag attributes = new ListTag();
        this.selectedAttributes.forEach(at -> {
            if (at == null) {
                return;
            }
            CompoundTag compoundNBT = new CompoundTag();
            ((ItemAttribute)at.getFirst()).serializeNBT(compoundNBT);
            compoundNBT.m_128379_("Inverted", ((Boolean)at.getSecond()).booleanValue());
            attributes.add((Object)compoundNBT);
        });
        filterItem.m_41784_().m_128365_("MatchedAttributes", (Tag)attributes);
        if (attributes.isEmpty() && this.whitelistMode == WhitelistMode.WHITELIST_DISJ) {
            filterItem.m_41751_(null);
        }
    }

    public static enum WhitelistMode {
        WHITELIST_DISJ,
        WHITELIST_CONJ,
        BLACKLIST;

    }
}

