/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.transmission;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class SplitShaftRenderer
extends KineticBlockEntityRenderer<SplitShaftBlockEntity> {
    public SplitShaftRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(SplitShaftBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        Block block = be.m_58900_().m_60734_();
        Direction.Axis boxAxis = ((IRotate)block).getRotationAxis(be.m_58900_());
        BlockPos pos = be.m_58899_();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.m_122434_();
            if (boxAxis != axis) continue;
            float offset = SplitShaftRenderer.getRotationOffsetForPosition(be, pos, axis);
            float angle = time * be.getSpeed() * 3.0f / 10.0f % 360.0f;
            float modifier = be.getRotationSpeedModifier(direction);
            angle *= modifier;
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            SuperByteBuffer superByteBuffer = CachedBufferer.partialFacing(AllPartialModels.SHAFT_HALF, be.m_58900_(), direction);
            SplitShaftRenderer.kineticRotationTransform(superByteBuffer, be, axis, angle, light);
            superByteBuffer.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
    }
}

